/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.testcaserun.started.Content;
import dev.cdevents.models.testcaserun.started.Context;
import dev.cdevents.models.testcaserun.started.Environment;
import dev.cdevents.models.testcaserun.started.Subject;
import dev.cdevents.models.testcaserun.started.TestCase;
import dev.cdevents.models.testcaserun.started.TestSuiteRun;
import dev.cdevents.models.testcaserun.started.Testcaserunstarted;
import dev.cdevents.models.testcaserun.started.Trigger;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class TestcaserunStartedCDEvent
extends Testcaserunstarted
implements CDEvent {
    public TestcaserunStartedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setTrigger(new Trigger());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().getContent().setTestSuiteRun(new TestSuiteRun());
        this.getSubject().getContent().setTestCase(new TestCase());
        this.getSubject().setType(Subject.Type.TEST_CASE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/test-case-run-started-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("testcaserunstarted.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectTriggerType(Trigger.Type type) {
        this.getSubject().getContent().getTrigger().setType(type);
    }

    public void setSubjectTriggerUri(URI uri) {
        this.getSubject().getContent().getTrigger().setUri(uri);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }

    public void setSubjectTestSuiteRunId(String id) {
        this.getSubject().getContent().getTestSuiteRun().setId(id);
    }

    public void setSubjectTestSuiteRunSource(String source) {
        this.getSubject().getContent().getTestSuiteRun().setSource(source);
    }

    public void setSubjectTestCaseId(String id) {
        this.getSubject().getContent().getTestCase().setId(id);
    }

    public void setSubjectTestCaseVersion(String version) {
        this.getSubject().getContent().getTestCase().setVersion(version);
    }

    public void setSubjectTestCaseName(String name) {
        this.getSubject().getContent().getTestCase().setName(name);
    }

    public void setSubjectTestCaseType(TestCase.Type type) {
        this.getSubject().getContent().getTestCase().setType(type);
    }

    public void setSubjectTestCaseUri(URI uri) {
        this.getSubject().getContent().getTestCase().setUri(uri);
    }
}

