/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.testsuiterun.finished.Content;
import dev.cdevents.models.testsuiterun.finished.Context;
import dev.cdevents.models.testsuiterun.finished.Environment;
import dev.cdevents.models.testsuiterun.finished.Subject;
import dev.cdevents.models.testsuiterun.finished.TestSuite;
import dev.cdevents.models.testsuiterun.finished.Testsuiterunfinished;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class TestsuiterunFinishedCDEvent
extends Testsuiterunfinished
implements CDEvent {
    public TestsuiterunFinishedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().getContent().setTestSuite(new TestSuite());
        this.getSubject().setType(Subject.Type.TEST_SUITE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/test-suite-finished-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("testsuiterunfinished.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectOutcome(Content.Outcome outcome) {
        this.getSubject().getContent().setOutcome(outcome);
    }

    public void setSubjectSeverity(Content.Severity severity) {
        this.getSubject().getContent().setSeverity(severity);
    }

    public void setSubjectReason(String reason) {
        this.getSubject().getContent().setReason(reason);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }

    public void setSubjectTestSuiteId(String id) {
        this.getSubject().getContent().getTestSuite().setId(id);
    }

    public void setSubjectTestSuiteVersion(String version) {
        this.getSubject().getContent().getTestSuite().setVersion(version);
    }

    public void setSubjectTestSuiteName(String name) {
        this.getSubject().getContent().getTestSuite().setName(name);
    }

    public void setSubjectTestSuiteUri(URI uri) {
        this.getSubject().getContent().getTestSuite().setUri(uri);
    }
}

