/*
 * Decompiled with CFR 0.152.
 */
package dev.cdevents.events;

import dev.cdevents.models.CDEvent;
import dev.cdevents.models.testsuiterun.started.Content;
import dev.cdevents.models.testsuiterun.started.Context;
import dev.cdevents.models.testsuiterun.started.Environment;
import dev.cdevents.models.testsuiterun.started.Subject;
import dev.cdevents.models.testsuiterun.started.TestSuite;
import dev.cdevents.models.testsuiterun.started.Testsuiterunstarted;
import dev.cdevents.models.testsuiterun.started.Trigger;
import dev.cdevents.spec.schemas.SchemaLoader;
import java.net.URI;
import java.util.Date;
import java.util.UUID;

public class TestsuiterunStartedCDEvent
extends Testsuiterunstarted
implements CDEvent {
    public TestsuiterunStartedCDEvent() {
        this.initCDEvent();
    }

    @Override
    public void initCDEvent() {
        this.setContext(new Context());
        this.setSubject(new Subject());
        this.setCustomData(new Object());
        this.setCustomDataContentType("application/json");
        Context context = this.getContext();
        context.setId(UUID.randomUUID().toString());
        context.setTimestamp(new Date());
        context.setVersion("0.3.0");
        this.getSubject().setContent(new Content());
        this.getSubject().getContent().setTrigger(new Trigger());
        this.getSubject().getContent().setEnvironment(new Environment());
        this.getSubject().getContent().setTestSuite(new TestSuite());
        this.getSubject().setType(Subject.Type.TEST_SUITE_RUN);
    }

    @Override
    public String eventSource() {
        return this.getContext().getSource();
    }

    @Override
    public String currentCDEventType() {
        return this.getContext().getType().value();
    }

    @Override
    public String schemaURL() {
        return "https://cdevents.dev/0.3.0/schema/test-suite-run-started-event";
    }

    @Override
    public String eventSchema() {
        return SchemaLoader.loadSchema("testsuiterunstarted.json");
    }

    public void setSource(URI source) {
        this.getContext().setSource(source.toString());
    }

    public void setSubjectId(String subjectId) {
        this.getSubject().setId(subjectId);
    }

    public void setSubjectSource(URI subjectSource) {
        this.getSubject().setSource(subjectSource.toString());
    }

    public void setSubjectTriggerType(Trigger.Type type) {
        this.getSubject().getContent().getTrigger().setType(type);
    }

    public void setSubjectTriggerUri(URI uri) {
        this.getSubject().getContent().getTrigger().setUri(uri);
    }

    public void setSubjectEnvironmentId(String id) {
        this.getSubject().getContent().getEnvironment().setId(id);
    }

    public void setSubjectEnvironmentSource(String source) {
        this.getSubject().getContent().getEnvironment().setSource(source);
    }

    public void setSubjectTestSuiteId(String id) {
        this.getSubject().getContent().getTestSuite().setId(id);
    }

    public void setSubjectTestSuiteVersion(String version) {
        this.getSubject().getContent().getTestSuite().setVersion(version);
    }

    public void setSubjectTestSuiteName(String name) {
        this.getSubject().getContent().getTestSuite().setName(name);
    }

    public void setSubjectTestSuiteUri(URI uri) {
        this.getSubject().getContent().getTestSuite().setUri(uri);
    }
}

