/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import dev.cerbos.api.v1.policy.PolicyOuterClass;
import dev.cerbos.api.v1.request.Request;
import dev.cerbos.api.v1.svc.CerbosAdminServiceGrpc;
import dev.cerbos.sdk.CerbosException;
import io.envoyproxy.pgv.ReflectiveValidatorIndex;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.Validator;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class AddOrUpdatePolicyRequestBuilder {
    private final Supplier<CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub> clientStub;
    private static final Validator<PolicyOuterClass.Policy> VALIDATOR = new ReflectiveValidatorIndex().validatorFor(PolicyOuterClass.Policy.class);
    private final List<PolicyOuterClass.Policy> policies = new ArrayList<PolicyOuterClass.Policy>();

    AddOrUpdatePolicyRequestBuilder(Supplier<CerbosAdminServiceGrpc.CerbosAdminServiceBlockingStub> clientStub) {
        this.clientStub = clientStub;
    }

    public AddOrUpdatePolicyRequestBuilder with(Reader policyJson) throws IOException, ValidationException {
        PolicyOuterClass.Policy.Builder pb = PolicyOuterClass.Policy.newBuilder();
        JsonFormat.parser().merge(policyJson, (Message.Builder)pb);
        this.addPolicy(pb);
        return this;
    }

    public AddOrUpdatePolicyRequestBuilder with(String policyJson) throws IOException, ValidationException {
        return this.with(new StringReader(policyJson));
    }

    private void addPolicy(PolicyOuterClass.Policy.Builder builder) throws ValidationException {
        PolicyOuterClass.Policy policy = builder.build();
        VALIDATOR.assertValid((Object)policy);
        this.policies.add(policy);
    }

    public AddOrUpdatePolicyRequestBuilder with(Iterable<PolicyOuterClass.Policy> policyList) throws ValidationException {
        for (PolicyOuterClass.Policy p : policyList) {
            VALIDATOR.assertValid((Object)p);
            this.policies.add(p);
        }
        return this;
    }

    public void addOrUpdate() {
        Request.AddOrUpdatePolicyRequest.Builder batch = Request.AddOrUpdatePolicyRequest.newBuilder();
        int batchSize = 0;
        for (int i = 1; i <= this.policies.size(); ++i) {
            if (i % 10 == 0) {
                try {
                    this.clientStub.get().addOrUpdatePolicy(batch.build());
                }
                catch (StatusRuntimeException sre) {
                    throw new CerbosException(sre.getStatus(), sre.getCause());
                }
                batch = Request.AddOrUpdatePolicyRequest.newBuilder();
                batchSize = 0;
            }
            batch.addPolicies(this.policies.get(i - 1));
            ++batchSize;
        }
        if (batchSize > 0) {
            try {
                this.clientStub.get().addOrUpdatePolicy(batch.build());
            }
            catch (StatusRuntimeException sre) {
                throw new CerbosException(sre.getStatus(), sre.getCause());
            }
        }
    }
}

