/*
 * Decompiled with CFR 0.152.
 */
package dev.cerbos.sdk;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CerbosContainer
extends GenericContainer<CerbosContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"ghcr.io/cerbos/cerbos");
    private static final String DEFAULT_VERSION = "latest";
    private static final int HTTP_PORT = 3592;
    private static final int GRPC_PORT = 3593;

    public CerbosContainer() {
        this(DEFAULT_VERSION);
    }

    public CerbosContainer(String version) {
        this(DEFAULT_IMAGE_NAME.withTag(version));
    }

    public CerbosContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{3592, 3593});
        this.setWaitStrategy((WaitStrategy)Wait.forLogMessage((String)".*Starting gRPC server.*", (int)1));
    }

    public Integer getGrpcPort() {
        return this.getMappedPort(3593);
    }

    public Integer getHttpPort() {
        return this.getMappedPort(3592);
    }

    public String getTarget() {
        return String.format("127.0.0.1:%d", this.getGrpcPort());
    }
}

