/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.haze;

import android.os.Build;
import androidx.compose.ui.graphics.AndroidCanvas_androidKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import dev.chrisbanes.haze.BlurEffect;
import dev.chrisbanes.haze.HazeEffectNode;
import dev.chrisbanes.haze.HazeEffectNodeKt;
import dev.chrisbanes.haze.RenderEffectBlurEffect;
import dev.chrisbanes.haze.RenderScriptBlurEffect;
import dev.chrisbanes.haze.ScrimBlurEffect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\b\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"updateBlurEffectIfNeeded", "", "Ldev/chrisbanes/haze/HazeEffectNode;", "drawScope", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "invalidateOnHazeAreaPreDraw", "", "haze_release"})
public final class HazeEffectNode_androidKt {
    public static final void updateBlurEffectIfNeeded(@NotNull HazeEffectNode $this$updateBlurEffectIfNeeded, @NotNull DrawScope drawScope) {
        Intrinsics.checkNotNullParameter((Object)$this$updateBlurEffectIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"drawScope");
        boolean canUseRenderEffect = Build.VERSION.SDK_INT >= 31 && AndroidCanvas_androidKt.getNativeCanvas((Canvas)drawScope.getDrawContext().getCanvas()).isHardwareAccelerated();
        boolean blurEnabled = HazeEffectNodeKt.resolveBlurEnabled($this$updateBlurEffectIfNeeded);
        if (blurEnabled && canUseRenderEffect) {
            BlurEffect newBlurEffect = $this$updateBlurEffectIfNeeded.getBlurEffect$haze_release() instanceof RenderEffectBlurEffect ? $this$updateBlurEffectIfNeeded.getBlurEffect$haze_release() : (BlurEffect)new RenderEffectBlurEffect($this$updateBlurEffectIfNeeded);
            $this$updateBlurEffectIfNeeded.setBlurEffect$haze_release(newBlurEffect);
            return;
        }
        if (blurEnabled) {
            BlurEffect newBlurEffect;
            BlurEffect blurEffect = newBlurEffect = $this$updateBlurEffectIfNeeded.getBlurEffect$haze_release() instanceof RenderScriptBlurEffect ? $this$updateBlurEffectIfNeeded.getBlurEffect$haze_release() : (BlurEffect)RenderScriptBlurEffect.Companion.createOrNull($this$updateBlurEffectIfNeeded);
            if (newBlurEffect != null) {
                $this$updateBlurEffectIfNeeded.setBlurEffect$haze_release(newBlurEffect);
                return;
            }
        }
        if (!($this$updateBlurEffectIfNeeded.getBlurEffect$haze_release() instanceof ScrimBlurEffect)) {
            $this$updateBlurEffectIfNeeded.setBlurEffect$haze_release(new ScrimBlurEffect($this$updateBlurEffectIfNeeded));
        }
    }

    public static final boolean invalidateOnHazeAreaPreDraw() {
        return Build.VERSION.SDK_INT < 32;
    }
}

