/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.haze;

import androidx.compose.runtime.CompositionLocal;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.snapshots.Snapshot;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.GraphicsContext;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.layer.GraphicsLayer;
import androidx.compose.ui.graphics.layer.GraphicsLayerKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.DrawModifierNode;
import androidx.compose.ui.node.GlobalPositionAwareModifierNode;
import androidx.compose.ui.node.LayoutAwareModifierNode;
import androidx.compose.ui.node.TraversableNode;
import androidx.compose.ui.platform.CompositionLocalsKt;
import androidx.compose.ui.unit.IntSizeKt;
import dev.chrisbanes.haze.CanvasKt;
import dev.chrisbanes.haze.ExperimentalHazeApi;
import dev.chrisbanes.haze.HazeArea;
import dev.chrisbanes.haze.HazeLogger;
import dev.chrisbanes.haze.HazeSourceNode_androidKt;
import dev.chrisbanes.haze.HazeState;
import dev.chrisbanes.haze.HazeTraversableNodeKeys;
import dev.chrisbanes.haze.OnPreDrawListener;
import dev.chrisbanes.haze.PreDraw_androidKt;
import dev.chrisbanes.haze.Utils_androidKt;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.DisposableHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalHazeApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u00018B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010.\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0002J\f\u00101\u001a\u00020)*\u000202H\u0016J\b\u00103\u001a\u00020)H\u0016J\b\u00104\u001a\u00020)H\u0016J\f\u00105\u001a\u00020)*\u00020\u0013H\u0002J\u0011\u00106\u001a\u00020)*\u00020\u0013H\u0000\u00a2\u0006\u0002\b7R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0011\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00069"}, d2={"Ldev/chrisbanes/haze/HazeSourceNode;", "Landroidx/compose/ui/Modifier$Node;", "Landroidx/compose/ui/node/CompositionLocalConsumerModifierNode;", "Landroidx/compose/ui/node/GlobalPositionAwareModifierNode;", "Landroidx/compose/ui/node/LayoutAwareModifierNode;", "Landroidx/compose/ui/node/DrawModifierNode;", "Landroidx/compose/ui/node/TraversableNode;", "state", "Ldev/chrisbanes/haze/HazeState;", "zIndex", "", "key", "", "<init>", "(Ldev/chrisbanes/haze/HazeState;FLjava/lang/Object;)V", "traverseKey", "getTraverseKey", "()Ljava/lang/Object;", "area", "Ldev/chrisbanes/haze/HazeArea;", "getArea$haze_release", "()Ldev/chrisbanes/haze/HazeArea;", "value", "getZIndex", "()F", "setZIndex", "(F)V", "getState", "()Ldev/chrisbanes/haze/HazeState;", "setState", "(Ldev/chrisbanes/haze/HazeState;)V", "getKey", "setKey", "(Ljava/lang/Object;)V", "preDrawDisposable", "Lkotlinx/coroutines/DisposableHandle;", "shouldAutoInvalidate", "", "getShouldAutoInvalidate", "()Z", "onAttach", "", "onPlaced", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "onGloballyPositioned", "onPositioned", "source", "", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "onDetach", "onReset", "reset", "releaseLayer", "releaseLayer$haze_release", "Companion", "haze_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHazeSourceNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HazeSourceNode.kt\ndev/chrisbanes/haze/HazeSourceNode\n+ 2 Snapshot.kt\nandroidx/compose/runtime/snapshots/Snapshot$Companion\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n602#2,6:245\n609#2:252\n278#3:251\n1#4:253\n*S KotlinDebug\n*F\n+ 1 HazeSourceNode.kt\ndev/chrisbanes/haze/HazeSourceNode\n*L\n118#1:245,6\n118#1:252\n119#1:251\n*E\n"})
public final class HazeSourceNode
extends Modifier.Node
implements CompositionLocalConsumerModifierNode,
GlobalPositionAwareModifierNode,
LayoutAwareModifierNode,
DrawModifierNode,
TraversableNode {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final HazeArea area;
    private float zIndex;
    @NotNull
    private HazeState state;
    @Nullable
    private DisposableHandle preDrawDisposable;
    private final boolean shouldAutoInvalidate;
    public static final int $stable = 8;
    @Deprecated
    @NotNull
    public static final String TAG = "HazeSource";

    public HazeSourceNode(@NotNull HazeState state, float zIndex, @Nullable Object key) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.area = new HazeArea();
        this.area.setZIndex$haze_release(zIndex);
        this.zIndex = zIndex;
        this.state = state;
        this.setKey(key);
    }

    public /* synthetic */ HazeSourceNode(HazeState hazeState, float f, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        if ((n & 4) != 0) {
            object = null;
        }
        this(hazeState, f, object);
    }

    @NotNull
    public Object getTraverseKey() {
        return HazeTraversableNodeKeys.Source;
    }

    @NotNull
    public final HazeArea getArea$haze_release() {
        return this.area;
    }

    public final float getZIndex() {
        return this.zIndex;
    }

    public final void setZIndex(float value) {
        this.zIndex = value;
        this.area.setZIndex$haze_release(value);
    }

    @NotNull
    public final HazeState getState() {
        return this.state;
    }

    public final void setState(@NotNull HazeState value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean attachedToState = this.state.getAreas().contains(this.area);
        if (attachedToState) {
            this.state.removeArea$haze_release(this.area);
        }
        this.state = value;
        if (attachedToState) {
            value.addArea$haze_release(this.area);
        }
    }

    @Nullable
    public final Object getKey() {
        return this.area.getKey();
    }

    public final void setKey(@Nullable Object value) {
        this.area.setKey$haze_release(value);
    }

    public boolean getShouldAutoInvalidate() {
        return this.shouldAutoInvalidate;
    }

    public void onAttach() {
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.onAttach$lambda$0(this)));
        this.state.addArea$haze_release(this.area);
        HazeSourceNode_androidKt.clearHazeAreaLayerOnStop(this);
        this.preDrawDisposable = PreDraw_androidKt.doOnPreDraw(this, () -> HazeSourceNode.onAttach$lambda$2(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPlaced(@NotNull LayoutCoordinates coordinates) {
        Snapshot previousSnapshot$iv;
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Snapshot.Companion this_$iv = Snapshot.Companion;
        boolean $i$f$withoutReadObservation = false;
        Snapshot snapshot = previousSnapshot$iv = this_$iv.getCurrentThreadSnapshot();
        Function1 observer$iv = snapshot != null ? snapshot.getReadObserver() : null;
        Snapshot newSnapshot$iv = this_$iv.makeCurrentNonObservable(previousSnapshot$iv);
        try {
            boolean bl = false;
            long $this$isUnspecified$iv = this.area.getPositionOnScreen-F1C5BW0();
            boolean bl2 = false;
            if (($this$isUnspecified$iv & 0x7FFFFFFF7FFFFFFFL) == 9205357640488583168L) {
                this.onPositioned(coordinates, "onPlaced");
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.restoreNonObservable(previousSnapshot$iv, newSnapshot$iv, observer$iv);
        }
    }

    public void onGloballyPositioned(@NotNull LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        this.onPositioned(coordinates, "onGloballyPositioned");
    }

    private final void onPositioned(LayoutCoordinates coordinates, String source) {
        if (!this.isAttached()) {
            return;
        }
        this.area.setPositionOnScreen-k-4lQ0M$haze_release(Utils_androidKt.positionForHaze(coordinates));
        this.area.setSize-uvyYCjk$haze_release(IntSizeKt.toSize-ozmzZPI((long)coordinates.getSize-YbymL2g()));
        this.area.setWindowId$haze_release(Utils_androidKt.getWindowId(this));
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.onPositioned$lambda$4(source, this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void draw(@NotNull ContentDrawScope $this$draw) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
            try {
                block8: {
                    HazeLogger.INSTANCE.d("HazeSource", (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, draw$lambda$5(), ()Ljava/lang/String;)());
                    this.area.setContentDrawing$haze_release(true);
                    if (!this.isAttached()) {
                        return;
                    }
                    if (MathKt.roundToInt((float)Size.getMinDimension-impl((long)$this$draw.getSize-NH-jbRc())) < 1) break block8;
                    graphicsContext = (GraphicsContext)CompositionLocalConsumerModifierNodeKt.currentValueOf((CompositionLocalConsumerModifierNode)this, (CompositionLocal)((CompositionLocal)CompositionLocalsKt.getLocalGraphicsContext()));
                    var4_4 = this.area.getContentLayer();
                    if (var4_4 == null) ** GOTO lbl-1000
                    it = var6_5 = var4_4;
                    $i$a$-takeUnless-HazeSourceNode$draw$contentLayer$1 = false;
                    v0 /* !! */  = var5_8 = it.isReleased() == false ? var6_5 : null;
                    if (var5_8 != null) {
                        v1 = var5_8;
                    } else lbl-1000:
                    // 2 sources

                    {
                        it = var6_5 = graphicsContext.createGraphicsLayer();
                        $i$a$-also-HazeSourceNode$draw$contentLayer$2 = false;
                        this.area.setContentLayer$haze_release(it);
                        HazeLogger.INSTANCE.d("HazeSource", (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, draw$lambda$8$lambda$7(dev.chrisbanes.haze.HazeSourceNode ), ()Ljava/lang/String;)((HazeSourceNode)this));
                        v1 = var6_5;
                    }
                    contentLayer = v1;
                    DrawScope.record-JVtK1S4$default((DrawScope)((DrawScope)$this$draw), (GraphicsLayer)contentLayer, (long)0L, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, draw$lambda$10(androidx.compose.ui.graphics.drawscope.ContentDrawScope androidx.compose.ui.graphics.layer.GraphicsLayer androidx.compose.ui.graphics.drawscope.DrawScope ), (Landroidx/compose/ui/graphics/drawscope/DrawScope;)Lkotlin/Unit;)((ContentDrawScope)$this$draw, (GraphicsLayer)contentLayer), (int)1, null);
                    GraphicsLayerKt.drawLayer((DrawScope)((DrawScope)$this$draw), (GraphicsLayer)contentLayer);
                    HazeLogger.INSTANCE.d("HazeSource", (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, draw$lambda$11(androidx.compose.ui.graphics.layer.GraphicsLayer ), ()Ljava/lang/String;)((GraphicsLayer)contentLayer));
                    break block7;
                }
                HazeLogger.INSTANCE.d("HazeSource", (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, draw$lambda$12(), ()Ljava/lang/String;)());
                CanvasKt.drawContentSafely($this$draw);
            }
            finally {
                this.area.setContentDrawing$haze_release(false);
                HazeLogger.INSTANCE.d("HazeSource", (Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, draw$lambda$13(), ()Ljava/lang/String;)());
            }
        }
    }

    public void onDetach() {
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.onDetach$lambda$14(this)));
        DisposableHandle disposableHandle = this.preDrawDisposable;
        if (disposableHandle != null) {
            disposableHandle.dispose();
        }
        this.reset(this.area);
        this.releaseLayer$haze_release(this.area);
        this.state.removeArea$haze_release(this.area);
    }

    public void onReset() {
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.onReset$lambda$15(this)));
        this.reset(this.area);
    }

    private final void reset(HazeArea $this$reset) {
        $this$reset.setPositionOnScreen-k-4lQ0M$haze_release(Offset.Companion.getUnspecified-F1C5BW0());
        $this$reset.setSize-uvyYCjk$haze_release(Size.Companion.getUnspecified-NH-jbRc());
        $this$reset.setContentDrawing$haze_release(false);
    }

    public final void releaseLayer$haze_release(@NotNull HazeArea $this$releaseLayer) {
        Intrinsics.checkNotNullParameter((Object)$this$releaseLayer, (String)"<this>");
        GraphicsLayer graphicsLayer = $this$releaseLayer.getContentLayer();
        if (graphicsLayer != null) {
            GraphicsLayer layer = graphicsLayer;
            boolean bl = false;
            HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.releaseLayer$lambda$17$lambda$16(layer)));
            ((GraphicsContext)CompositionLocalConsumerModifierNodeKt.currentValueOf((CompositionLocalConsumerModifierNode)this, (CompositionLocal)((CompositionLocal)CompositionLocalsKt.getLocalGraphicsContext()))).releaseGraphicsLayer(layer);
        }
        $this$releaseLayer.setContentLayer$haze_release(null);
    }

    private static final String onAttach$lambda$0(HazeSourceNode this$0) {
        return "onAttach. Adding HazeArea: " + this$0.area;
    }

    private static final String onAttach$lambda$2$lambda$1() {
        return "onPreDraw";
    }

    private static final void onAttach$lambda$2(HazeSourceNode this$0) {
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)HazeSourceNode::onAttach$lambda$2$lambda$1));
        for (OnPreDrawListener listener : this$0.area.getPreDrawListeners$haze_release()) {
            listener.invoke();
        }
    }

    private static final String onPositioned$lambda$4(String $source, HazeSourceNode this$0) {
        return $source + ": positionOnScreen=" + Offset.toString-impl((long)this$0.area.getPositionOnScreen-F1C5BW0()) + ", size=" + Size.toString-impl((long)this$0.area.getSize-NH-jbRc()) + ", positionOnScreens=" + Offset.toString-impl((long)this$0.area.getPositionOnScreen-F1C5BW0());
    }

    private static final String draw$lambda$5() {
        return "start draw()";
    }

    private static final String draw$lambda$8$lambda$7(HazeSourceNode this$0) {
        return "Updated contentLayer in HazeArea: " + this$0.area;
    }

    private static final String draw$lambda$10$lambda$9(GraphicsLayer $contentLayer) {
        return "Drawn content into layer: " + $contentLayer;
    }

    private static final Unit draw$lambda$10(ContentDrawScope $this_draw, GraphicsLayer $contentLayer, DrawScope $this$record) {
        Intrinsics.checkNotNullParameter((Object)$this$record, (String)"$this$record");
        CanvasKt.drawContentSafely($this_draw);
        HazeLogger.INSTANCE.d(TAG, (Function0<String>)((Function0)() -> HazeSourceNode.draw$lambda$10$lambda$9($contentLayer)));
        return Unit.INSTANCE;
    }

    private static final String draw$lambda$11(GraphicsLayer $contentLayer) {
        return "Drawn layer to canvas: " + $contentLayer;
    }

    private static final String draw$lambda$12() {
        return "Not using graphics layer, so drawing content direct to canvas";
    }

    private static final String draw$lambda$13() {
        return "end draw()";
    }

    private static final String onDetach$lambda$14(HazeSourceNode this$0) {
        return "onDetach. Removing HazeArea: " + this$0.area;
    }

    private static final String onReset$lambda$15(HazeSourceNode this$0) {
        return "onReset. Resetting HazeArea: " + this$0.area;
    }

    private static final String releaseLayer$lambda$17$lambda$16(GraphicsLayer $layer) {
        return "Releasing content layer: " + $layer;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/chrisbanes/haze/HazeSourceNode$Companion;", "", "<init>", "()V", "TAG", "", "haze_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

