/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.haze;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\"\u001b\u0010\u0004\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\"\u001b\u0010\t\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\f"}, d2={"makeBlurSksl", "", "vertical", "", "VERTICAL_BLUR_SKSL", "getVERTICAL_BLUR_SKSL", "()Ljava/lang/String;", "VERTICAL_BLUR_SKSL$delegate", "Lkotlin/Lazy;", "HORIZONTAL_BLUR_SKSL", "getHORIZONTAL_BLUR_SKSL", "HORIZONTAL_BLUR_SKSL$delegate", "haze_release"})
@SourceDebugExtension(value={"SMAP\nHazeShaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HazeShaders.kt\ndev/chrisbanes/haze/HazeShadersKt\n+ 2 Utils.kt\ndev/chrisbanes/haze/UtilsKt\n*L\n1#1,98:1\n39#2:99\n39#2:100\n*S KotlinDebug\n*F\n+ 1 HazeShaders.kt\ndev/chrisbanes/haze/HazeShadersKt\n*L\n92#1:99\n95#1:100\n*E\n"})
public final class HazeShadersKt {
    @NotNull
    private static final Lazy VERTICAL_BLUR_SKSL$delegate;
    @NotNull
    private static final Lazy HORIZONTAL_BLUR_SKSL$delegate;

    private static final String makeBlurSksl(boolean vertical) {
        return "\n  uniform shader content;\n  uniform float blurRadius;\n  uniform vec4 crop;\n  uniform shader mask;\n\n  const half maxRadius = 150.0;\n\n  float gaussian(float x, float sigma) {\n    return exp(-(x * x) / (2.0 * sigma * sigma));\n  }\n\n  vec4 blur(vec2 coord, float radius) {\n    // Truncate the radius\n    half r = floor(radius);\n\n    // Need to use float and vec here for higher precision, otherwise we see\n    // visually clipping on certain devices (Samsung for example)\n    // https://github.com/chrisbanes/haze/issues/520\n    float sigma = max(radius / 2.0, 1.0);\n    float weightSum = 1.0;\n    vec4 result = content.eval(coord);\n\n    // We need to use a constant max size Skia to know the size of the program. We use a large\n    // number, along with a break\n    for (half i = 1.0; i < maxRadius; i += 2.0) {\n      // i is always odd.\n      // The algorithm needs pixels exist at the offset of [i] (odd) and [i + 1] (even).\n      // If radius r is even (i > r), we can break safely here, as all the pixels have been calculated;\n      // otherwise (i == r) we need to calculate the pixel at the offset of [r], so break in advance.\n      if (i >= r) { break; }\n\n      float weightL = gaussian(i, sigma);\n      float weightH = gaussian(i + 1.0, sigma);\n      float weight = weightL + weightH;\n      vec2 offset = " + (vertical ? "vec2(0.0, i + weightH / weight)" : "vec2(i + weightH / weight, 0.0)") + ";\n\n      vec2 newCoord = coord - offset;\n      if (newCoord.x >= crop[0] && newCoord.y >= crop[1]) {\n        result += weight * content.eval(newCoord);\n        weightSum += weight;\n      }\n\n      newCoord = coord + offset;\n      if (newCoord.x < crop[2] && newCoord.y < crop[3]) {\n        result += weight * content.eval(newCoord);\n        weightSum += weight;\n      }\n    }\n\n    // Check if radius is odd\n    if (r < maxRadius && mod(r, 2.0) == 1.0) {\n      float weight = gaussian(r, sigma);\n      vec2 offset = " + (vertical ? "vec2(0.0, r)" : "vec2(r, 0.0)") + ";\n\n      vec2 newCoord = coord - offset;\n      if (newCoord.x >= crop[0] && newCoord.y >= crop[1]) {\n        result += weight * content.eval(newCoord);\n        weightSum += weight;\n      }\n\n      newCoord = coord + offset;\n      if (newCoord.x < crop[2] && newCoord.y < crop[3]) {\n        result += weight * content.eval(newCoord);\n        weightSum += weight;\n      }\n    }\n\n    return result / weightSum;\n  }\n\n  vec4 main(vec2 coord) {\n    // Offset the coord for the mask, but coerce it to be at least 0, 0\n    vec2 maskCoord = max(coord - crop.xy, vec2(0.0, 0.0));\n    float intensity = mask.eval(maskCoord).a;\n\n    return blur(coord, mix(0.0, blurRadius, intensity));\n  }\n";
    }

    @NotNull
    public static final String getVERTICAL_BLUR_SKSL() {
        Lazy lazy = VERTICAL_BLUR_SKSL$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public static final String getHORIZONTAL_BLUR_SKSL() {
        Lazy lazy = HORIZONTAL_BLUR_SKSL$delegate;
        return (String)lazy.getValue();
    }

    private static final String VERTICAL_BLUR_SKSL_delegate$lambda$0() {
        return HazeShadersKt.makeBlurSksl(true);
    }

    private static final String HORIZONTAL_BLUR_SKSL_delegate$lambda$1() {
        return HazeShadersKt.makeBlurSksl(false);
    }

    static {
        Function0 initializer$iv = HazeShadersKt::VERTICAL_BLUR_SKSL_delegate$lambda$0;
        boolean $i$f$unsynchronizedLazy = false;
        VERTICAL_BLUR_SKSL$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)initializer$iv);
        initializer$iv = HazeShadersKt::HORIZONTAL_BLUR_SKSL_delegate$lambda$1;
        $i$f$unsynchronizedLazy = false;
        HORIZONTAL_BLUR_SKSL$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)initializer$iv);
    }
}

