/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import dev.chrisbanes.insetter.OnApplyInsetsListener;
import dev.chrisbanes.insetter.ViewDimensions;

public class InsetUtils {
    private InsetUtils() {
    }

    public static void setOnApplyInsetsListener(@NonNull View view, final @NonNull OnApplyInsetsListener listener) {
        final ViewDimensions initialPadding = InsetUtils.createPaddingDimensions(view);
        final ViewDimensions initialMargin = InsetUtils.createMarginDimensions(view);
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                listener.onInsetsListener(insets, initialPadding, initialMargin);
                return insets;
            }
        });
        InsetUtils.requestApplyInsetsWhenAttached(view);
    }

    public static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    ViewCompat.requestApplyInsets((View)v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    @NonNull
    private static ViewDimensions createPaddingDimensions(@NonNull View view) {
        return new ViewDimensions(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
    }

    @NonNull
    private static ViewDimensions createMarginDimensions(@NonNull View view) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            return new ViewDimensions(mlp.leftMargin, mlp.topMargin, mlp.rightMargin, mlp.bottomMargin);
        }
        return ViewDimensions.EMPTY;
    }
}

