/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import dev.chrisbanes.insetter.ViewDimensions;

public class ViewState {
    private ViewDimensions paddings;
    private ViewDimensions margins;

    ViewState(@NonNull View view) {
        this.updateForView(view);
    }

    public ViewDimensions getPaddings() {
        return this.paddings;
    }

    public ViewDimensions getMargins() {
        return this.margins;
    }

    private void updateForView(@NonNull View view) {
        this.paddings = ViewState.createPaddingDimensions(view);
        this.margins = ViewState.createMarginDimensions(view);
    }

    @NonNull
    private static ViewDimensions createPaddingDimensions(@NonNull View view) {
        return new ViewDimensions(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
    }

    @NonNull
    private static ViewDimensions createMarginDimensions(@NonNull View view) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            return new ViewDimensions(mlp.leftMargin, mlp.topMargin, mlp.rightMargin, mlp.bottomMargin);
        }
        return ViewDimensions.EMPTY;
    }
}

