/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import dev.chrisbanes.insetter.OnApplyInsetsListener;
import dev.chrisbanes.insetter.ViewState;

public class Insetter {
    private Insetter() {
    }

    public static void setOnApplyInsetsListener(@NonNull View view, final @NonNull OnApplyInsetsListener listener) {
        final ViewState initialState = new ViewState(view);
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                listener.onApplyInsets(v, insets, initialState);
                return insets;
            }
        });
        Insetter.requestApplyInsetsWhenAttached(view);
    }

    public static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    ViewCompat.requestApplyInsets((View)v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }
}

