/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import dev.chrisbanes.insetter.ViewDimensions;
import java.util.Locale;

public class ViewState {
    private ViewDimensions paddings;
    private ViewDimensions margins;

    public ViewState(@NonNull View view) {
        this.updateForView(view);
    }

    public ViewDimensions getPaddings() {
        return this.paddings;
    }

    public ViewDimensions getMargins() {
        return this.margins;
    }

    private void updateForView(@NonNull View view) {
        this.paddings = ViewState.createPaddingDimensions(view);
        this.margins = ViewState.createMarginDimensions(view);
    }

    @NonNull
    private static ViewDimensions createPaddingDimensions(@NonNull View view) {
        return new ViewDimensions(view.getPaddingLeft(), view.getPaddingTop(), view.getPaddingRight(), view.getPaddingBottom());
    }

    @NonNull
    private static ViewDimensions createMarginDimensions(@NonNull View view) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            return new ViewDimensions(mlp.leftMargin, mlp.topMargin, mlp.rightMargin, mlp.bottomMargin);
        }
        return ViewDimensions.EMPTY;
    }

    public String toString() {
        return String.format(Locale.US, "ViewState{paddings=%s, margins=%s}", this.paddings, this.margins);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewState viewState = (ViewState)o;
        if (!ObjectsCompat.equals((Object)this.paddings, (Object)viewState.paddings)) {
            return false;
        }
        return ObjectsCompat.equals((Object)this.margins, (Object)viewState.margins);
    }

    public int hashCode() {
        int result = this.paddings != null ? this.paddings.hashCode() : 0;
        result = 31 * result + (this.margins != null ? this.margins.hashCode() : 0);
        return result;
    }
}

