/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.annotation.SuppressLint;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import dev.chrisbanes.insetter.InsetDimension;
import dev.chrisbanes.insetter.OnApplyInsetsListener;
import dev.chrisbanes.insetter.R;
import dev.chrisbanes.insetter.ViewDimensions;
import dev.chrisbanes.insetter.ViewState;
import java.util.EnumSet;
import java.util.Locale;

public class Insetter {
    static final String TAG = "Insetter";
    @SuppressLint(value={"InlinedApi"})
    @VisibleForTesting
    static final int EDGE_TO_EDGE_FLAGS = 1792;

    private Insetter() {
    }

    public static void setOnApplyInsetsListener(@NonNull View view, final @NonNull OnApplyInsetsListener listener) {
        ViewState initialState;
        ViewState tagState = (ViewState)view.getTag(R.id.insetter_initial_state);
        if (tagState != null) {
            initialState = tagState;
        } else {
            initialState = new ViewState(view);
            view.setTag(R.id.insetter_initial_state, (Object)initialState);
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                listener.onApplyInsets(v, insets, initialState);
                return insets;
            }
        });
        Insetter.requestApplyInsetsWhenAttached(view);
    }

    public static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewCompat.requestApplyInsets((View)v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public static void applyInsetsToView(@NonNull View view, @NonNull WindowInsetsCompat insets, @NonNull ViewState initialState, @Nullable EnumSet<InsetDimension> paddingSystemWindowInsets, @Nullable EnumSet<InsetDimension> marginSystemWindowInsets, @Nullable EnumSet<InsetDimension> paddingSystemGestureInsets, @Nullable EnumSet<InsetDimension> marginSystemGestureInsets) {
        ViewGroup.LayoutParams lp;
        Insets systemWindowInsets = insets.getSystemWindowInsets();
        Insets systemGestureInsets = insets.getSystemGestureInsets();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. View: %s. Insets: %s. State: %s", view, insets, initialState));
        }
        ViewDimensions initialPadding = initialState.getPaddings();
        int paddingLeft = view.getPaddingLeft();
        if (paddingSystemGestureInsets != null && paddingSystemGestureInsets.contains((Object)InsetDimension.LEFT)) {
            paddingLeft = initialPadding.getLeft() + systemGestureInsets.left;
        } else if (paddingSystemWindowInsets != null && paddingSystemWindowInsets.contains((Object)InsetDimension.LEFT)) {
            paddingLeft = initialPadding.getLeft() + systemWindowInsets.left;
        }
        int paddingTop = view.getPaddingTop();
        if (paddingSystemGestureInsets != null && paddingSystemGestureInsets.contains((Object)InsetDimension.TOP)) {
            paddingTop = initialPadding.getTop() + systemGestureInsets.top;
        } else if (paddingSystemWindowInsets != null && paddingSystemWindowInsets.contains((Object)InsetDimension.TOP)) {
            paddingTop = initialPadding.getTop() + systemWindowInsets.top;
        }
        int paddingRight = view.getPaddingRight();
        if (paddingSystemGestureInsets != null && paddingSystemGestureInsets.contains((Object)InsetDimension.RIGHT)) {
            paddingRight = initialPadding.getRight() + systemGestureInsets.right;
        } else if (paddingSystemWindowInsets != null && paddingSystemWindowInsets.contains((Object)InsetDimension.RIGHT)) {
            paddingRight = initialPadding.getRight() + systemWindowInsets.right;
        }
        int paddingBottom = view.getPaddingBottom();
        if (paddingSystemGestureInsets != null && paddingSystemGestureInsets.contains((Object)InsetDimension.BOTTOM)) {
            paddingBottom = initialPadding.getBottom() + systemGestureInsets.bottom;
        } else if (paddingSystemWindowInsets != null && paddingSystemWindowInsets.contains((Object)InsetDimension.BOTTOM)) {
            paddingBottom = initialPadding.getBottom() + systemWindowInsets.bottom;
        }
        view.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. Applied padding to %s: left=%d, top=%d, right=%d, bottom=%d}", view, paddingLeft, paddingTop, paddingRight, paddingBottom));
        }
        if ((lp = view.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)lp;
            ViewDimensions initialMargins = initialState.getMargins();
            int marginLeft = mlp.leftMargin;
            if (marginSystemGestureInsets != null && marginSystemGestureInsets.contains((Object)InsetDimension.LEFT)) {
                marginLeft = initialMargins.getLeft() + systemGestureInsets.left;
            } else if (marginSystemWindowInsets != null && marginSystemWindowInsets.contains((Object)InsetDimension.LEFT)) {
                marginLeft = initialMargins.getLeft() + systemWindowInsets.left;
            }
            int marginTop = mlp.topMargin;
            if (marginSystemGestureInsets != null && marginSystemGestureInsets.contains((Object)InsetDimension.TOP)) {
                marginTop = initialMargins.getTop() + systemGestureInsets.top;
            } else if (marginSystemWindowInsets != null && marginSystemWindowInsets.contains((Object)InsetDimension.TOP)) {
                marginTop = initialMargins.getTop() + systemWindowInsets.top;
            }
            int marginRight = mlp.rightMargin;
            if (marginSystemGestureInsets != null && marginSystemGestureInsets.contains((Object)InsetDimension.RIGHT)) {
                marginRight = initialMargins.getRight() + systemGestureInsets.right;
            } else if (marginSystemWindowInsets != null && marginSystemWindowInsets.contains((Object)InsetDimension.RIGHT)) {
                marginRight = initialMargins.getRight() + systemWindowInsets.right;
            }
            int marginBottom = mlp.bottomMargin;
            if (marginSystemGestureInsets != null && marginSystemGestureInsets.contains((Object)InsetDimension.BOTTOM)) {
                marginBottom = initialMargins.getBottom() + systemGestureInsets.bottom;
            } else if (marginSystemWindowInsets != null && marginSystemWindowInsets.contains((Object)InsetDimension.BOTTOM)) {
                marginBottom = initialMargins.getBottom() + systemWindowInsets.bottom;
            }
            if (mlp.leftMargin != marginLeft || mlp.topMargin != marginTop || mlp.rightMargin != marginRight || mlp.bottomMargin != marginBottom) {
                mlp.leftMargin = marginLeft;
                mlp.topMargin = marginTop;
                mlp.rightMargin = marginRight;
                mlp.bottomMargin = marginBottom;
                view.setLayoutParams(lp);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. Applied margin to %s: left=%d, top=%d, right=%d, bottom=%d}", view, marginLeft, marginTop, marginRight, marginBottom));
                }
            }
        } else if (marginSystemGestureInsets != null && !marginSystemGestureInsets.isEmpty() || marginSystemWindowInsets != null && !marginSystemWindowInsets.isEmpty()) {
            throw new IllegalArgumentException("Margin inset handling requested but view LayoutParams do not extend MarginLayoutParams");
        }
    }

    @Deprecated
    public static void applyInsetsToView(@NonNull View view, @NonNull WindowInsetsCompat insets, @NonNull ViewState initialState, boolean paddingSystemWindowLeft, boolean paddingSystemWindowTop, boolean paddingSystemWindowRight, boolean paddingSystemWindowBottom, boolean paddingSystemGestureLeft, boolean paddingSystemGestureTop, boolean paddingSystemGestureRight, boolean paddingSystemGestureBottom, boolean marginSystemWindowLeft, boolean marginSystemWindowTop, boolean marginSystemWindowRight, boolean marginSystemWindowBottom, boolean marginSystemGestureLeft, boolean marginSystemGestureTop, boolean marginSystemGestureRight, boolean marginSystemGestureBottom) {
        Insetter.applyInsetsToView(view, insets, initialState, Insetter.generateEnumSet(paddingSystemWindowLeft, paddingSystemWindowTop, paddingSystemWindowRight, paddingSystemWindowBottom), Insetter.generateEnumSet(marginSystemWindowLeft, marginSystemWindowTop, marginSystemWindowRight, marginSystemWindowBottom), Insetter.generateEnumSet(paddingSystemGestureLeft, paddingSystemGestureTop, paddingSystemGestureRight, paddingSystemGestureBottom), Insetter.generateEnumSet(marginSystemGestureLeft, marginSystemGestureTop, marginSystemGestureRight, marginSystemGestureBottom));
    }

    @RequiresApi(api=16)
    public static void setEdgeToEdgeSystemUiFlags(@NonNull View view, boolean enabled) {
        view.setSystemUiVisibility(view.getSystemUiVisibility() & 0xFFFFF8FF | (enabled ? 1792 : 0));
    }

    @Nullable
    static EnumSet<InsetDimension> generateEnumSet(boolean left, boolean top, boolean right, boolean bottom) {
        if (!(left || top || right || bottom)) {
            return null;
        }
        EnumSet<InsetDimension> set = EnumSet.noneOf(InsetDimension.class);
        if (left) {
            set.add(InsetDimension.LEFT);
        }
        if (top) {
            set.add(InsetDimension.TOP);
        }
        if (right) {
            set.add(InsetDimension.RIGHT);
        }
        if (bottom) {
            set.add(InsetDimension.BOTTOM);
        }
        return set;
    }
}

