/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.chrisbanes.insetter;

public final class Side {
  public static final int NONE = 0;

  public static final int LEFT = 1;

  public static final int TOP = 1 << 1;

  public static final int RIGHT = 1 << 2;

  public static final int BOTTOM = 1 << 3;

  public static final int ALL = LEFT | TOP | RIGHT | BOTTOM;

  private Side() {
    // no instantiation
  }

  @Sides
  public static int create(boolean left, boolean top, boolean right, boolean bottom) {
    return (left ? Side.LEFT : 0)
        | (top ? Side.TOP : 0)
        | (right ? Side.RIGHT : 0)
        | (bottom ? Side.BOTTOM : 0);
  }
}
