/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dev.chrisbanes.insetter;

import java.util.Locale;

public class ViewDimensions {
  private final int left;
  private final int top;
  private final int right;
  private final int bottom;

  public static final ViewDimensions EMPTY = new ViewDimensions(0, 0, 0, 0);

  ViewDimensions(int left, int top, int right, int bottom) {
    this.left = left;
    this.top = top;
    this.right = right;
    this.bottom = bottom;
  }

  public int getLeft() {
    return left;
  }

  public int getTop() {
    return top;
  }

  public int getRight() {
    return right;
  }

  public int getBottom() {
    return bottom;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ViewDimensions that = (ViewDimensions) o;

    if (left != that.left) return false;
    if (top != that.top) return false;
    if (right != that.right) return false;
    return bottom == that.bottom;
  }

  @Override
  public int hashCode() {
    int result = left;
    result = 31 * result + top;
    result = 31 * result + right;
    result = 31 * result + bottom;
    return result;
  }

  @Override
  public String toString() {
    return String.format(
        Locale.US,
        "ViewDimensions{left=%d, top=%d, right=%d, bottom=%d}",
        left,
        top,
        right,
        bottom);
  }
}
