/*
 * Decompiled with CFR 0.152.
 */
package dev.chrisbanes.insetter;

import android.annotation.SuppressLint;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import dev.chrisbanes.insetter.OnApplyInsetsListener;
import dev.chrisbanes.insetter.R;
import dev.chrisbanes.insetter.SideUtils;
import dev.chrisbanes.insetter.ViewDimensions;
import dev.chrisbanes.insetter.ViewState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public final class Insetter {
    public static final int CONSUME_NONE = 0;
    public static final int CONSUME_ALL = 1;
    public static final int CONSUME_AUTO = 2;
    static final String TAG = "Insetter";
    @Nullable
    private OnApplyInsetsListener onApplyInsetsListener;
    private int paddingSystemWindowInsets;
    private int marginSystemWindowInsets;
    private int paddingSystemGestureInsets;
    private int marginSystemGestureInsets;
    private int consumeSystemWindowInsets;
    @SuppressLint(value={"InlinedApi"})
    @VisibleForTesting
    static final int EDGE_TO_EDGE_FLAGS = 1792;

    private Insetter(@NonNull Builder builder) {
        this.onApplyInsetsListener = builder.onApplyInsetsListener;
        this.paddingSystemWindowInsets = builder.paddingSystemWindowInsets;
        this.marginSystemWindowInsets = builder.marginSystemWindowInsets;
        this.paddingSystemGestureInsets = builder.paddingSystemGestureInsets;
        this.marginSystemGestureInsets = builder.marginSystemGestureInsets;
        this.consumeSystemWindowInsets = builder.consumeSystemWindowInsets;
    }

    public static Builder builder() {
        return new Builder();
    }

    private void setOnApplyInsetsListener(@NonNull View view) {
        ViewState initialState;
        ViewState tagState = (ViewState)view.getTag(R.id.insetter_initial_state);
        if (tagState != null) {
            initialState = tagState;
        } else {
            initialState = new ViewState(view);
            view.setTag(R.id.insetter_initial_state, (Object)initialState);
        }
        ViewCompat.setOnApplyWindowInsetsListener((View)view, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                int sidesApplied;
                if (Insetter.this.onApplyInsetsListener != null) {
                    Insetter.this.onApplyInsetsListener.onApplyInsets(v, insets, initialState);
                    sidesApplied = 15;
                } else {
                    Insetter.this.applyInsetsToView(v, insets, initialState);
                    sidesApplied = Insetter.this.paddingSystemWindowInsets | Insetter.this.marginSystemWindowInsets | Insetter.this.paddingSystemGestureInsets | Insetter.this.marginSystemGestureInsets;
                }
                switch (Insetter.this.consumeSystemWindowInsets) {
                    case 1: {
                        return insets.consumeSystemWindowInsets();
                    }
                    case 2: {
                        if ((sidesApplied & 0xF) == 0) {
                            return insets;
                        }
                        if ((sidesApplied & 0xF) == 15) {
                            return insets.consumeSystemWindowInsets();
                        }
                        int left = insets.getSystemWindowInsetLeft();
                        int top = insets.getSystemWindowInsetTop();
                        int right = insets.getSystemWindowInsetRight();
                        int bottom = insets.getSystemWindowInsetBottom();
                        if (SideUtils.hasSide(sidesApplied, 1)) {
                            left = 0;
                        }
                        if (SideUtils.hasSide(sidesApplied, 2)) {
                            top = 0;
                        }
                        if (SideUtils.hasSide(sidesApplied, 4)) {
                            right = 0;
                        }
                        if (SideUtils.hasSide(sidesApplied, 8)) {
                            bottom = 0;
                        }
                        return insets.replaceSystemWindowInsets(left, top, right, bottom);
                    }
                }
                return insets;
            }
        });
        Insetter.requestApplyInsetsWhenAttached(view);
    }

    private static void requestApplyInsetsWhenAttached(@NonNull View view) {
        if (ViewCompat.isAttachedToWindow((View)view)) {
            ViewCompat.requestApplyInsets((View)view);
        } else {
            view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    ViewCompat.requestApplyInsets((View)v);
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public void applyInsetsToView(@NonNull View view, @NonNull WindowInsetsCompat insets, @NonNull ViewState initialState) {
        ViewGroup.LayoutParams lp;
        Insets systemWindowInsets = insets.getSystemWindowInsets();
        Insets systemGestureInsets = insets.getSystemGestureInsets();
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. View: %s. Insets: %s. State: %s", view, insets, initialState));
        }
        ViewDimensions initialPadding = initialState.getPaddings();
        int paddingLeft = view.getPaddingLeft();
        if (SideUtils.hasSide(this.paddingSystemGestureInsets, 1)) {
            paddingLeft = initialPadding.getLeft() + systemGestureInsets.left;
        } else if (SideUtils.hasSide(this.paddingSystemWindowInsets, 1)) {
            paddingLeft = initialPadding.getLeft() + systemWindowInsets.left;
        }
        int paddingTop = view.getPaddingTop();
        if (SideUtils.hasSide(this.paddingSystemGestureInsets, 2)) {
            paddingTop = initialPadding.getTop() + systemGestureInsets.top;
        } else if (SideUtils.hasSide(this.paddingSystemWindowInsets, 2)) {
            paddingTop = initialPadding.getTop() + systemWindowInsets.top;
        }
        int paddingRight = view.getPaddingRight();
        if (SideUtils.hasSide(this.paddingSystemGestureInsets, 4)) {
            paddingRight = initialPadding.getRight() + systemGestureInsets.right;
        } else if (SideUtils.hasSide(this.paddingSystemWindowInsets, 4)) {
            paddingRight = initialPadding.getRight() + systemWindowInsets.right;
        }
        int paddingBottom = view.getPaddingBottom();
        if (SideUtils.hasSide(this.paddingSystemGestureInsets, 8)) {
            paddingBottom = initialPadding.getBottom() + systemGestureInsets.bottom;
        } else if (SideUtils.hasSide(this.paddingSystemWindowInsets, 8)) {
            paddingBottom = initialPadding.getBottom() + systemWindowInsets.bottom;
        }
        view.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. Applied padding to %s: left=%d, top=%d, right=%d, bottom=%d}", view, paddingLeft, paddingTop, paddingRight, paddingBottom));
        }
        if ((lp = view.getLayoutParams()) instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)lp;
            ViewDimensions initialMargins = initialState.getMargins();
            int marginLeft = mlp.leftMargin;
            if (SideUtils.hasSide(this.marginSystemGestureInsets, 1)) {
                marginLeft = initialMargins.getLeft() + systemGestureInsets.left;
            } else if (SideUtils.hasSide(this.marginSystemWindowInsets, 1)) {
                marginLeft = initialMargins.getLeft() + systemWindowInsets.left;
            }
            int marginTop = mlp.topMargin;
            if (SideUtils.hasSide(this.marginSystemGestureInsets, 2)) {
                marginTop = initialMargins.getTop() + systemGestureInsets.top;
            } else if (SideUtils.hasSide(this.marginSystemWindowInsets, 2)) {
                marginTop = initialMargins.getTop() + systemWindowInsets.top;
            }
            int marginRight = mlp.rightMargin;
            if (SideUtils.hasSide(this.marginSystemGestureInsets, 4)) {
                marginRight = initialMargins.getRight() + systemGestureInsets.right;
            } else if (SideUtils.hasSide(this.marginSystemWindowInsets, 4)) {
                marginRight = initialMargins.getRight() + systemWindowInsets.right;
            }
            int marginBottom = mlp.bottomMargin;
            if (SideUtils.hasSide(this.marginSystemGestureInsets, 8)) {
                marginBottom = initialMargins.getBottom() + systemGestureInsets.bottom;
            } else if (SideUtils.hasSide(this.marginSystemWindowInsets, 8)) {
                marginBottom = initialMargins.getBottom() + systemWindowInsets.bottom;
            }
            if (mlp.leftMargin != marginLeft || mlp.topMargin != marginTop || mlp.rightMargin != marginRight || mlp.bottomMargin != marginBottom) {
                mlp.leftMargin = marginLeft;
                mlp.topMargin = marginTop;
                mlp.rightMargin = marginRight;
                mlp.bottomMargin = marginBottom;
                view.setLayoutParams(lp);
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)String.format(Locale.US, "applyInsetsToView. Applied margin to %s: left=%d, top=%d, right=%d, bottom=%d}", view, marginLeft, marginTop, marginRight, marginBottom));
                }
            }
        } else if (this.marginSystemGestureInsets != 0 || this.marginSystemWindowInsets != 0) {
            throw new IllegalArgumentException("Margin inset handling requested but view LayoutParams do not extend MarginLayoutParams");
        }
    }

    @RequiresApi(api=16)
    public static void setEdgeToEdgeSystemUiFlags(@NonNull View view, boolean enabled) {
        view.setSystemUiVisibility(view.getSystemUiVisibility() & 0xFFFFF8FF | (enabled ? 1792 : 0));
    }

    public static final class Builder {
        @Nullable
        private OnApplyInsetsListener onApplyInsetsListener;
        private int paddingSystemWindowInsets;
        private int marginSystemWindowInsets;
        private int paddingSystemGestureInsets;
        private int marginSystemGestureInsets;
        private int consumeSystemWindowInsets = 0;

        private Builder() {
        }

        @NonNull
        public Builder setOnApplyInsetsListener(@Nullable OnApplyInsetsListener onApplyInsetsListener) {
            this.onApplyInsetsListener = onApplyInsetsListener;
            return this;
        }

        @NonNull
        public Builder applySystemWindowInsetsToPadding(int flags) {
            this.paddingSystemWindowInsets = flags;
            return this;
        }

        @NonNull
        public Builder applySystemWindowInsetsToMargin(int flags) {
            this.marginSystemWindowInsets = flags;
            return this;
        }

        @NonNull
        public Builder applySystemGestureInsetsToPadding(int flags) {
            this.paddingSystemGestureInsets = flags;
            return this;
        }

        @NonNull
        public Builder applySystemGestureInsetsToMargin(int flags) {
            this.marginSystemGestureInsets = flags;
            return this;
        }

        @NonNull
        public Builder consumeSystemWindowInsets(boolean consumeSystemWindowInsets) {
            return this.consumeSystemWindowInsets(consumeSystemWindowInsets ? 1 : 0);
        }

        @NonNull
        public Builder consumeSystemWindowInsets(int consume) {
            this.consumeSystemWindowInsets = consume;
            return this;
        }

        @NonNull
        public Insetter applyToView(@NonNull View view) {
            Insetter insetter = this.build();
            insetter.setOnApplyInsetsListener(view);
            return insetter;
        }

        @NonNull
        public Insetter build() {
            return new Insetter(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConsumeOptions {
    }
}

