/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.toolchain.protobuf;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.RequirementMatcher;
import org.apache.maven.toolchain.RequirementMatcherFactory;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.xolstice.maven.toolchain.protobuf.DefaultProtobufToolchain;

@Component(role=ToolchainFactory.class, hint="protobuf", description="A default factory for 'protobuf' toolchains")
public class DefaultProtobufToolchainFactory
implements ToolchainFactory {
    @Requirement
    private Logger logger;

    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        if (model == null) {
            return null;
        }
        DefaultProtobufToolchain toolchain = new DefaultProtobufToolchain(model, this.logger);
        Properties configuration = DefaultProtobufToolchainFactory.toProperties((Xpp3Dom)model.getConfiguration());
        String protocExecutable = configuration.getProperty("protocExecutable");
        if (protocExecutable == null) {
            throw new MisconfiguredToolchainException("Protobuf toolchain without the protocExecutable configuration element.");
        }
        String normalizedProtocExecutablePath = FileUtils.normalize((String)protocExecutable);
        File protocExecutableFile = new File(normalizedProtocExecutablePath);
        if (!protocExecutableFile.exists()) {
            throw new MisconfiguredToolchainException("Non-existing protoc executable at " + protocExecutableFile.getAbsolutePath());
        }
        toolchain.setProtocExecutable(normalizedProtocExecutablePath);
        Properties provides = model.getProvides();
        for (Map.Entry<Object, Object> provide : provides.entrySet()) {
            String key = (String)provide.getKey();
            String value = (String)provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            RequirementMatcher matcher = "version".equals(key) ? RequirementMatcherFactory.createVersionMatcher((String)value) : RequirementMatcherFactory.createExactMatcher((String)value);
            toolchain.addProvideToken(key, matcher);
        }
        return toolchain;
    }

    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected static Properties toProperties(Xpp3Dom dom) {
        Xpp3Dom[] children;
        Properties props = new Properties();
        for (Xpp3Dom child : children = dom.getChildren()) {
            props.setProperty(child.getName(), child.getValue());
        }
        return props;
    }
}

