/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.database;

import com.clickhouse.jdbc.ClickHouseDriver;
import java.text.SimpleDateFormat;
import java.util.Date;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

public class ClickHouseDatabase
extends AbstractJdbcDatabase {
    private static final String DATABASE_NAME = "ClickHouse";
    private static final int DEFAULT_PORT = 8123;
    private static final String DRIVER_CLASS_NAME = ClickHouseDriver.class.getName();
    public static final String CURRENT_DATE_TIME_FUNCTION = "toDateTime64('" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS").format(new Date()) + "',3)";

    public ClickHouseDatabase() {
        this.setCurrentDateTimeFunction(CURRENT_DATE_TIME_FUNCTION);
    }

    public int getPriority() {
        return 5;
    }

    protected String getDefaultDatabaseProductName() {
        return DATABASE_NAME;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return DATABASE_NAME.equals(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        return url != null && url.startsWith("jdbc:clickhouse") ? DRIVER_CLASS_NAME : null;
    }

    public String getShortName() {
        return "clickhouse";
    }

    public Integer getDefaultPort() {
        return 8123;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }
}

