/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.lockservice;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.lockservice.StandardLockService;
import liquibase.logging.Logger;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class ClickHouseLockService
extends StandardLockService {
    private boolean isLockTableInitialized;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) {
        if (!this.isLockTableInitialized) {
            try {
                String query = String.format("SELECT COUNT(*) FROM `%s`.%s", this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
                int nbRows = this.getExecutor().queryForInt((SqlStatement)new RawSqlStatement(query));
                this.isLockTableInitialized = nbRows > 0;
            }
            catch (LiquibaseException e) {
                if (this.getExecutor().updatesDatabase()) {
                    throw new UnexpectedLiquibaseException((Throwable)e);
                }
                this.isLockTableInitialized = !tableJustCreated;
            }
        }
        return this.isLockTableInitialized;
    }

    public boolean hasDatabaseChangeLogLockTable() {
        boolean hasTable = false;
        try {
            String query = String.format("SELECT ID FROM `%s`.%s LIMIT 1", this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            this.getExecutor().execute((SqlStatement)new RawSqlStatement(query));
            hasTable = true;
        }
        catch (DatabaseException e) {
            this.getLogger().info(String.format("No %s table available", this.database.getDatabaseChangeLogLockTableName()));
        }
        return hasTable;
    }

    private Executor getExecutor() {
        return ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
    }

    private Logger getLogger() {
        return Scope.getCurrentScope().getLog(ClickHouseLockService.class);
    }
}

