/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import java.util.Locale;
import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogLockTableGenerator;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;

public class CreateDatabaseChangeLogLockTableClickHouse
extends CreateDatabaseChangeLogLockTableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateDatabaseChangeLogLockTableStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(CreateDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String tableName = database.getDatabaseChangeLogLockTableName();
        String createTableQuery = String.format("CREATE TABLE IF NOT EXISTS `%s`.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "(ID Int64,LOCKED UInt8,LOCKGRANTED Nullable(DateTime64),LOCKEDBY Nullable(String)) " + SqlGeneratorUtil.generateSqlEngineClause(properties, tableName.toLowerCase(Locale.ROOT)), database.getDefaultSchemaName(), tableName);
        return SqlGeneratorUtil.generateSql(database, createTableQuery);
    }
}

