/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import java.util.Locale;
import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateDatabaseChangeLogTableGenerator;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;

public class CreateDatabaseChangeLogTableClickHouse
extends CreateDatabaseChangeLogTableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(CreateDatabaseChangeLogTableStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String tableName = database.getDatabaseChangeLogTableName();
        String createTableQuery = String.format("CREATE TABLE IF NOT EXISTS `%s`.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "(ID String,AUTHOR String,FILENAME String,DATEEXECUTED DateTime64,ORDEREXECUTED UInt64,EXECTYPE String,MD5SUM Nullable(String),DESCRIPTION Nullable(String),COMMENTS Nullable(String),TAG Nullable(String),LIQUIBASE Nullable(String),CONTEXTS Nullable(String),LABELS Nullable(String),DEPLOYMENT_ID Nullable(String)) " + SqlGeneratorUtil.generateSqlEngineClause(properties, tableName.toLowerCase(Locale.ROOT)), database.getDefaultSchemaName(), tableName);
        return SqlGeneratorUtil.generateSql(database, createTableQuery);
    }
}

