/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InitializeDatabaseChangeLogLockTableGenerator;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;

public class InitializeDatabaseChangeLogLockClickHouse
extends InitializeDatabaseChangeLogLockTableGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(InitializeDatabaseChangeLogLockTableStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(InitializeDatabaseChangeLogLockTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String clearDatabaseQuery = String.format("ALTER TABLE `%s`.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "DELETE WHERE 1 SETTINGS mutations_sync = 1", database.getDefaultSchemaName(), database.getDatabaseChangeLogLockTableName());
        String initLockQuery = String.format("INSERT INTO `%s`.%s (ID, LOCKED) VALUES (1, 0)", database.getDefaultSchemaName(), database.getDatabaseChangeLogLockTableName());
        return SqlGeneratorUtil.generateSql(database, clearDatabaseQuery, initLockQuery);
    }
}

