/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.clickhouse.database.ClickHouseDatabase;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.ext.clickhouse.params.ParamsLoader;
import liquibase.ext.clickhouse.sqlgenerator.SqlGeneratorUtil;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.LockDatabaseChangeLogGenerator;
import liquibase.statement.core.LockDatabaseChangeLogStatement;

public class LockDatabaseChangeLogClickHouse
extends LockDatabaseChangeLogGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(LockDatabaseChangeLogStatement statement, Database database) {
        return database instanceof ClickHouseDatabase;
    }

    public Sql[] generateSql(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ClusterConfig properties = ParamsLoader.getLiquibaseClickhouseProperties();
        String host = String.format("%s %s (%s)", hostname, hostDescription, hostaddress);
        String lockQuery = String.format("ALTER TABLE `%s`.%s " + SqlGeneratorUtil.generateSqlOnClusterClause(properties) + "UPDATE LOCKED = 1,LOCKEDBY = '%s',LOCKGRANTED = %s WHERE ID = 1 AND LOCKED = 0 SETTINGS mutations_sync = 1", database.getDefaultSchemaName(), database.getDatabaseChangeLogLockTableName(), host, ClickHouseDatabase.CURRENT_DATE_TIME_FUNCTION);
        return SqlGeneratorUtil.generateSql(database, lockQuery);
    }
}

