/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.clickhouse.sqlgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import liquibase.database.Database;
import liquibase.ext.clickhouse.params.ClusterConfig;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

class SqlGeneratorUtil {
    SqlGeneratorUtil() {
    }

    public static Sql[] generateSql(Database database, String ... statements) {
        SqlGeneratorFactory sqlGeneratorFactory = SqlGeneratorFactory.getInstance();
        ArrayList<Sql> allSqlStatements = new ArrayList<Sql>();
        for (String statement : statements) {
            RawSqlStatement rawSqlStatement = new RawSqlStatement(statement);
            Sql[] perStatement = sqlGeneratorFactory.generateSql((SqlStatement)rawSqlStatement, database);
            allSqlStatements.addAll(Arrays.asList(perStatement));
        }
        return allSqlStatements.toArray(new Sql[0]);
    }

    public static String generateSqlOnClusterClause(ClusterConfig properties) {
        if (properties != null) {
            return String.format("ON CLUSTER '%s' ", properties.getClusterName());
        }
        return " ";
    }

    public static String generateSqlEngineClause(ClusterConfig properties, String tableName) {
        if (properties != null) {
            return String.format("ENGINE ReplicatedMergeTree('%s','%s') ORDER BY ID", properties.getTableZooKeeperPathPrefix() + tableName.toLowerCase(Locale.ROOT), properties.getTableReplicaName());
        }
        return "ENGINE MergeTree() ORDER BY ID";
    }
}

