/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef;

import java.nio.ByteBuffer;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class SharedMemory {
    private static final String ALT_MEM_HELPER_PATH = Utils.getString("ALT_MEM_HELPER_PATH");
    public final String mname;
    public final long boostHandle;
    public long lasUsedMs = 0L;
    private final long mySegment;
    private final long myPtr;
    private volatile boolean myClosed = false;
    private final long myMutex;

    public static void loadDynamicLib() {
        try {
            if (ALT_MEM_HELPER_PATH == null || ALT_MEM_HELPER_PATH.isEmpty()) {
                System.loadLibrary("shared_mem_helper");
            } else {
                System.load(ALT_MEM_HELPER_PATH.trim());
            }
        }
        catch (UnsatisfiedLinkError e) {
            CefLog.Error("Can't load shared_mem_helper, exception: %s", e.getMessage());
        }
    }

    public SharedMemory(String sharedMemName, long boostHandle) {
        this.mname = sharedMemName;
        this.boostHandle = boostHandle;
        this.mySegment = SharedMemory.openSharedSegment(sharedMemName);
        this.myPtr = SharedMemory.getPointer(this.mySegment, boostHandle);
        this.myMutex = SharedMemory.openSharedMutex(sharedMemName);
    }

    public void lock() {
        SharedMemory.lockSharedMutex(this.myMutex);
    }

    public void unlock() {
        SharedMemory.unlockSharedMutex(this.myMutex);
    }

    public long getPtr() {
        return this.myPtr;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public synchronized void close() {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        SharedMemory.closeSharedSegment(this.mySegment);
        SharedMemory.closeSharedMutex(this.myMutex);
    }

    public ByteBuffer wrap(int size) {
        return SharedMemory.wrapNativeMem(this.myPtr, size);
    }

    public int readInt() {
        return SharedMemory.readInt(this.myPtr, 0);
    }

    public int readInt(int offset) {
        return SharedMemory.readInt(this.myPtr, offset);
    }

    public int readByte(int offset) {
        return SharedMemory.readByte(this.myPtr, offset);
    }

    private static native ByteBuffer wrapNativeMem(long var0, int var2);

    private static native int readInt(long var0, int var2);

    private static native int readByte(long var0, int var2);

    private static native long openSharedSegment(String var0);

    private static native long getPointer(long var0, long var2);

    private static native void closeSharedSegment(long var0);

    private static native long openSharedMutex(String var0);

    private static native void lockSharedMutex(long var0);

    private static native void unlockSharedMutex(long var0);

    private static native void closeSharedMutex(long var0);

    static {
        SharedMemory.loadDynamicLib();
    }

    public static class WithRaster
    extends SharedMemory {
        private int myWidth;
        private int myHeight;
        private int myDirtyRectsCount;

        public WithRaster(String sharedMemName, long boostHandle) {
            super(sharedMemName, boostHandle);
        }

        public ByteBuffer wrapRaster() {
            return SharedMemory.wrapNativeMem(this.getPtr(), this.myWidth * this.myHeight * 4);
        }

        public ByteBuffer wrapRects() {
            return SharedMemory.wrapNativeMem(this.getPtr() + (long)this.getRectsOffset(), this.myDirtyRectsCount * 4 * 4);
        }

        public int getRectsOffset() {
            return this.myWidth * this.myHeight * 4;
        }

        public int getWidth() {
            return this.myWidth;
        }

        public void setWidth(int width) {
            this.myWidth = width;
        }

        public int getHeight() {
            return this.myHeight;
        }

        public void setHeight(int height) {
            this.myHeight = height;
        }

        public int getDirtyRectsCount() {
            return this.myDirtyRectsCount;
        }

        public void setDirtyRectsCount(int dirtyRectsCount) {
            this.myDirtyRectsCount = dirtyRectsCount;
        }
    }
}

