/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote;

import com.jetbrains.cef.remote.ClientHandlersDummy;
import com.jetbrains.cef.remote.ClientHandlersImpl;
import com.jetbrains.cef.remote.NativeServerManager;
import com.jetbrains.cef.remote.RemoteBrowser;
import com.jetbrains.cef.remote.RemoteClient;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.ThriftTransport;
import com.jetbrains.cef.remote.thrift_codegen.ClientHandlers;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.thrift.TException;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerTransport;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.handler.CefAppHandler;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;

public class CefServer {
    private static final boolean CONNECT_AS_SLAVE = Utils.getBoolean("JCEF_CONNECT_AS_SLAVE");
    private static final CefServer INSTANCE = CefApp.isRemoteEnabled() ? new CefServer() : null;
    private Thread myClientHandlersThread;
    private TServer myClientHandlersServer;
    private TServerTransport myClientHandlersTransport;
    private final RpcExecutor myRpc = new RpcExecutor();
    private final Map<Integer, RemoteBrowser> myBid2Browser = new ConcurrentHashMap<Integer, RemoteBrowser>();
    private final ClientHandlersImpl myClientHandlersImpl = new ClientHandlersImpl(this.myRpc, this.myBid2Browser);
    private volatile boolean myIsConnected = false;
    private volatile boolean myIsContextInitialized = false;
    private final LinkedList<Runnable> myDelayedActions = new LinkedList();

    public static boolean connect(CefAppHandler appHandler, CefSettings settings) {
        if (!CefApp.isRemoteEnabled()) {
            return false;
        }
        if (NativeServerManager.isRunning()) {
            CefLog.Error("Found running cef_server instance. TODO: we must check that running instance has the same <CefSettings, cmd-line switches, custom schemes> and restart cef_server with correct args if necessary.", new Object[0]);
        } else {
            long waitTimeoutMs = Utils.getInteger("WAIT_SERVER_TIMEOUT_MS", 15000);
            boolean success = NativeServerManager.startProcessAndWait(appHandler, settings, waitTimeoutMs);
            if (!success) {
                return false;
            }
        }
        if (!INSTANCE.connect(appHandler::onContextInitialized)) {
            CefLog.Error("Can't initialize client for native server.", new Object[0]);
            return false;
        }
        return true;
    }

    public static CefServer instance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onConnected(Runnable r, String name, boolean first) {
        LinkedList<Runnable> linkedList = this.myDelayedActions;
        synchronized (linkedList) {
            if (this.myIsConnected) {
                if (r != null) {
                    r.run();
                }
                return true;
            }
            if (r != null) {
                if (first) {
                    this.myDelayedActions.addFirst(r);
                } else {
                    this.myDelayedActions.addLast(r);
                }
                CefLog.Debug("Delay action '%s' until server connected (first=%s).", name, String.valueOf(first));
            }
            return false;
        }
    }

    public RpcExecutor getService() {
        return this.myRpc;
    }

    public RemoteClient createClient() {
        return new RemoteClient(this.myRpc, this.myBid2Browser);
    }

    public static String getVersion() {
        if (CefApp.isRemoteEnabled() && CefServer.INSTANCE.myIsConnected) {
            return CefServer.INSTANCE.myRpc.execObj(r -> r.version());
        }
        return "unknown(not connected)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(Runnable onContextInitialized) {
        this.myClientHandlersImpl.setOnContextInitialized(() -> {
            this.myIsContextInitialized = true;
            onContextInitialized.run();
        });
        try {
            try {
                CefLog.Debug("Initialize CefServer, open server transport.", new Object[0]);
                this.myRpc.openTransport();
            }
            catch (TException x) {
                CefLog.Error("TException when opening server %s : %s", ThriftTransport.isTcp() ? "tcp-socket" : "pipe", x.getMessage());
                boolean bl = false;
                LinkedList<Runnable> linkedList = this.myDelayedActions;
                synchronized (linkedList) {
                    this.myDelayedActions.clear();
                }
                return bl;
            }
            try {
                this.myClientHandlersTransport = ThriftTransport.createServerTransport();
            }
            catch (Exception e) {
                CefLog.Error("Exception when opening client %s : %s", ThriftTransport.isTcp() ? "tcp-socket" : "pipe", e.getMessage());
                if (ThriftTransport.isTcp()) {
                    CefLog.Error("Port : %d", ThriftTransport.getJavaHandlersPort());
                } else {
                    CefLog.Error("Pipe : %s", ThriftTransport.getJavaHandlersPipe());
                }
                boolean bl = false;
                LinkedList<Runnable> linkedList = this.myDelayedActions;
                synchronized (linkedList) {
                    this.myDelayedActions.clear();
                }
                return bl;
            }
            Object processor = new ClientHandlers.Processor<ClientHandlersImpl>(this.myClientHandlersImpl);
            TThreadPoolServer.Args serverArgs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args(this.myClientHandlersTransport).processor(processor)).executorService((ExecutorService)new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
                final AtomicLong count = new AtomicLong();

                @Override
                public Thread newThread(Runnable r) {
                    String name = String.format("CefHandlers-execution-%d", this.count.getAndIncrement());
                    Thread thread = new Thread(r, name);
                    thread.setDaemon(true);
                    return thread;
                }
            }));
            this.myClientHandlersServer = new TThreadPoolServer(serverArgs);
            this.myClientHandlersThread = new Thread(() -> this.myClientHandlersServer.serve());
            this.myClientHandlersThread.setName("CefHandlers-listening");
            this.myClientHandlersThread.start();
            int cid = this.myRpc.connect(!CONNECT_AS_SLAVE);
            LinkedList<Runnable> linkedList = this.myDelayedActions;
            synchronized (linkedList) {
                this.myIsConnected = true;
                this.myDelayedActions.forEach(r -> r.run());
                this.myDelayedActions.clear();
            }
            CefLog.Debug("Connected to CefSever, cid=" + cid, new Object[0]);
        }
        catch (Throwable e) {
            CefLog.Error("RuntimeException in CefServer.connect: %s", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            LinkedList<Runnable> linkedList = this.myDelayedActions;
            synchronized (linkedList) {
                this.myDelayedActions.clear();
            }
        }
        return true;
    }

    public void disconnect() {
        CefLog.Debug("Disconnect from native server (it will be automatically stopped soon because we were connected as master).", new Object[0]);
        this.myIsConnected = false;
        this.myRpc.closeTransport();
        if (this.myClientHandlersTransport != null) {
            this.myClientHandlersTransport.close();
            this.myClientHandlersTransport = null;
        }
        if (this.myClientHandlersServer != null) {
            this.myClientHandlersServer.stop();
            this.myClientHandlersServer = null;
        }
    }

    public static TServer startTestHandlersService(CountDownLatch finished) {
        TServerTransport transport;
        try {
            transport = ThriftTransport.createServerTransport();
        }
        catch (Exception e) {
            CefLog.Error("Exception when opening test-client %s : %s", ThriftTransport.isTcp() ? "tcp-socket" : "pipe", e.getMessage());
            if (ThriftTransport.isTcp()) {
                CefLog.Error("Port : %d", ThriftTransport.getJavaHandlersPort());
            } else {
                CefLog.Error("Pipe : %s", ThriftTransport.getJavaHandlersPipe());
            }
            return null;
        }
        ClientHandlers.Processor<ClientHandlersDummy> processor = new ClientHandlers.Processor<ClientHandlersDummy>(new ClientHandlersDummy());
        TThreadPoolServer.Args serverArgs = ((TThreadPoolServer.Args)new TThreadPoolServer.Args(transport).processor(processor)).executorService((ExecutorService)new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            final AtomicLong count = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format("CefHandlers(dummy)-execution-%d", this.count.getAndIncrement());
                Thread thread = new Thread(r, name);
                return thread;
            }
        }));
        TThreadPoolServer result = new TThreadPoolServer(serverArgs){

            public void stop() {
                super.stop();
                transport.close();
            }
        };
        Thread t = new Thread(() -> CefServer.lambda$startTestHandlersService$4((TServer)result, finished));
        t.setName("CefHandlers(dummy)-listening");
        t.start();
        return result;
    }

    private static /* synthetic */ void lambda$startTestHandlersService$4(TServer result, CountDownLatch finished) {
        try {
            result.serve();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (finished != null) {
                finished.countDown();
            }
        }
    }
}

