/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.RemoteServerObjectLocal;
import com.jetbrains.cef.remote.RpcExecutor;
import com.jetbrains.cef.remote.network.RemotePostData;
import com.jetbrains.cef.remote.thrift_codegen.PostData;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.Map;
import org.cef.misc.CefLog;
import org.cef.network.CefPostData;
import org.cef.network.CefRequest;

public class RemoteRequestImpl
extends RemoteServerObjectLocal {
    public RemoteRequestImpl(RpcExecutor server, RObject request) {
        super(server, request);
    }

    @Override
    public void flush() {
        this.myServer.exec(s -> s.Request_Update(this.thriftIdWithCache()));
    }

    public long getIdentifier() {
        return this.getLongVal("Identifier");
    }

    public boolean isReadOnly() {
        return this.getBoolVal("IsReadOnly");
    }

    public String getURL() {
        return (String)this.myCache.get("URL");
    }

    public void setURL(String url) {
        this.setStrVal("URL", url);
    }

    public String getMethod() {
        return (String)this.myCache.get("Method");
    }

    public void setMethod(String method) {
        this.setStrVal("Method", method);
    }

    public void setReferrer(String url, CefRequest.ReferrerPolicy policy) {
        this.setStrVal("ReferrerURL", url);
        this.setStrVal("ReferrerPolicy", policy.name());
    }

    public String getReferrerURL() {
        return (String)this.myCache.get("ReferrerURL");
    }

    public CefRequest.ReferrerPolicy getReferrerPolicy() {
        String sval = (String)this.myCache.get("ReferrerPolicy");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefRequest.ReferrerPolicy.valueOf(sval);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("getReferrerPolicy: ", e.getMessage());
            }
        }
        return null;
    }

    public CefPostData getPostData() {
        PostData pd = this.myServer.execObj(s -> s.Request_GetPostData(this.thriftId()));
        return pd == null ? null : new RemotePostData(pd);
    }

    public void setPostData(CefPostData postData) {
        this.myServer.exec(s -> s.Request_SetPostData(this.thriftId(), RemotePostData.toThriftWithMap(postData)));
    }

    public void set(String url, String method, CefPostData postData, Map<String, String> headerMap) {
        this.myServer.exec(s -> s.Request_Set(this.thriftId(), url, method, RemotePostData.toThriftWithMap(postData), headerMap));
    }

    public String getHeaderByName(String name) {
        return this.myServer.execObj(s -> s.Request_GetHeaderByName(this.thriftId(), name));
    }

    public void setHeaderByName(String name, String value, boolean overwrite) {
        this.myServer.exec(s -> s.Request_SetHeaderByName(this.thriftId(), name, value, overwrite));
    }

    public void getHeaderMap(Map<String, String> headerMap) {
        if (headerMap == null) {
            return;
        }
        Map result = this.myServer.execObj(s -> s.Request_GetHeaderMap(this.thriftId()));
        if (result != null) {
            headerMap.putAll(result);
        }
    }

    public void setHeaderMap(Map<String, String> headerMap) {
        this.myServer.exec(s -> s.Request_SetHeaderMap(this.thriftId(), headerMap));
    }

    public int getFlags() {
        return (int)this.getLongVal("Flags");
    }

    public void setFlags(int flags) {
        this.setLongVal("Flags", flags);
    }

    public String getFirstPartyForCookies() {
        return (String)this.myCache.get("FirstPartyForCookies");
    }

    public void setFirstPartyForCookies(String url) {
        this.setStrVal("FirstPartyForCookies", url);
    }

    public CefRequest.ResourceType getResourceType() {
        String sval = (String)this.myCache.get("ResourceType");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefRequest.ResourceType.valueOf(sval);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("getResourceType: ", e.getMessage());
            }
        }
        return null;
    }

    public CefRequest.TransitionType getTransitionType() {
        String sval = (String)this.myCache.get("TransitionType");
        if (sval != null && !sval.isEmpty()) {
            try {
                return CefRequest.TransitionType.valueOf(sval);
            }
            catch (IllegalArgumentException e) {
                CefLog.Error("getTransitionType: ", e.getMessage());
            }
        }
        return null;
    }

    public String toString() {
        return this.myCache.toString();
    }
}

