/*
 * Decompiled with CFR 0.152.
 */
package org.cef.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.cef.CefApp;
import org.cef.callback.CefCommandLine;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.misc.CefLog;

public abstract class CefAppHandlerAdapter
implements CefAppHandler {
    private String[] args_;

    public CefAppHandlerAdapter(String[] args) {
        this.args_ = args;
    }

    public void updateArgs(String[] args) {
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String arg : args) {
            keysToRemove.add(arg.split("=", 2)[0]);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String arg : this.args_) {
            String key = arg.split("=", 2)[0];
            if (keysToRemove.contains(key)) continue;
            result.add(arg);
        }
        Collections.addAll(result, args);
        this.args_ = result.toArray(new String[0]);
    }

    public String[] getArgs() {
        return this.args_ == null ? null : Arrays.copyOf(this.args_, this.args_.length);
    }

    @Override
    public void onBeforeCommandLineProcessing(String process_type, CefCommandLine command_line) {
        if (process_type.isEmpty() && this.args_ != null) {
            boolean parseSwitchesDone = false;
            block5: for (String arg : this.args_) {
                if (parseSwitchesDone || arg.length() < 2) {
                    command_line.appendArgument(arg);
                    continue;
                }
                int switchCnt = arg.startsWith("--") ? 2 : (arg.startsWith("/") ? 1 : (arg.startsWith("-") ? 1 : 0));
                switch (switchCnt) {
                    case 2: {
                        if (arg.length() == 2) {
                            parseSwitchesDone = true;
                            continue block5;
                        }
                    }
                    case 1: {
                        String[] switchVals = arg.substring(switchCnt).split("=");
                        if (switchVals.length == 2) {
                            command_line.appendSwitchWithValue(switchVals[0], switchVals[1]);
                            continue block5;
                        }
                        command_line.appendSwitch(switchVals[0]);
                        continue block5;
                    }
                    case 0: {
                        command_line.appendArgument(arg);
                    }
                }
            }
        }
    }

    @Override
    public boolean onBeforeTerminate() {
        return false;
    }

    @Override
    public void stateHasChanged(CefApp.CefAppState state2) {
    }

    @Override
    public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
    }

    @Override
    public void onContextInitialized() {
    }

    @Override
    public void onScheduleMessagePumpWork(long delay_ms) {
        if (CefApp.getState() == CefApp.CefAppState.TERMINATED) {
            CefLog.Debug("CefApp is terminated, skip doMessageLoopWork", new Object[0]);
            return;
        }
        CefApp.getInstance().doMessageLoopWork(delay_ms);
    }

    @Override
    public void onBeforeChildProcessLaunch(String command_line) {
    }
}

