/*
 * Decompiled with CFR 0.152.
 */
package dev.datlag.kcef.step.extract;

import dev.datlag.kcef.KCEFException;
import dev.datlag.kcef.Platform;
import dev.datlag.kcef.common.ExtendFileKt;
import dev.datlag.kcef.step.extract.Extractor;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001\u00a8\u0006\u0017"}, d2={"Ldev/datlag/kcef/step/extract/TarGzExtractor;", "Ldev/datlag/kcef/step/extract/Extractor;", "<init>", "()V", "extract", "", "installDir", "Ljava/io/File;", "downloadedFile", "bufferSize", "", "move", "linuxMove", "macMove", "winMove", "equals", "", "other", "", "hashCode", "", "toString", "", "kcef"})
@SourceDebugExtension(value={"SMAP\nTarGzExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TarGzExtractor.kt\ndev/datlag/kcef/step/extract/TarGzExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n1863#3,2:168\n1863#3,2:170\n1863#3,2:172\n1863#3,2:174\n1863#3,2:176\n1863#3,2:178\n1863#3,2:180\n1863#3,2:182\n1863#3,2:184\n1863#3,2:186\n1863#3,2:188\n*S KotlinDebug\n*F\n+ 1 TarGzExtractor.kt\ndev/datlag/kcef/step/extract/TarGzExtractor\n*L\n68#1:168,2\n83#1:170,2\n89#1:172,2\n101#1:174,2\n110#1:176,2\n124#1:178,2\n130#1:180,2\n141#1:182,2\n149#1:184,2\n153#1:186,2\n159#1:188,2\n*E\n"})
public final class TarGzExtractor
implements Extractor {
    @NotNull
    public static final TarGzExtractor INSTANCE = new TarGzExtractor();

    private TarGzExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(@NotNull File installDir, @NotNull File downloadedFile, long bufferSize) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Intrinsics.checkNotNullParameter((Object)downloadedFile, (String)"downloadedFile");
        Closeable closeable = new FileInputStream(downloadedFile);
        Throwable throwable = null;
        try {
            FileInputStream in = (FileInputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new GzipCompressorInputStream((InputStream)in);
            Throwable throwable2 = null;
            try {
                GzipCompressorInputStream gzipIn = (GzipCompressorInputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = (Closeable)new TarArchiveInputStream((InputStream)gzipIn);
                Throwable throwable3 = null;
                try {
                    TarArchiveInputStream tarIn = (TarArchiveInputStream)closeable3;
                    boolean bl3 = false;
                    TarArchiveEntry entry = null;
                    while (true) {
                        boolean bl4;
                        TarArchiveEntry tarArchiveEntry;
                        TarArchiveEntry it = tarArchiveEntry = tarIn.getNextTarEntry();
                        boolean bl5 = false;
                        entry = it;
                        if (tarArchiveEntry == null) break;
                        TarArchiveEntry currentEntry = entry;
                        if (currentEntry == null) continue;
                        File file = new File(installDir, currentEntry.getName());
                        if (!ExtendFileKt.validate(file, installDir)) {
                            throw KCEFException.BadArchive.INSTANCE;
                        }
                        if (currentEntry.isDirectory()) {
                            ExtendFileKt.mkdirSafely(file);
                            bl4 = file.setExecutable(true, false);
                            continue;
                        }
                        int count = 0;
                        byte[] data = new byte[(int)bufferSize];
                        Closeable closeable4 = new BufferedOutputStream(new FileOutputStream(file, false), (int)bufferSize);
                        Throwable throwable4 = null;
                        try {
                            BufferedOutputStream dest = (BufferedOutputStream)closeable4;
                            boolean bl6 = false;
                            while (true) {
                                int n;
                                int it2 = n = tarIn.read(data, 0, (int)bufferSize);
                                boolean bl7 = false;
                                count = it2;
                                if (n == -1) break;
                                dest.write(data, 0, count);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable4 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                        }
                        bl4 = file.setExecutable(true, false);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ExtendFileKt.deleteSafely(downloadedFile);
    }

    public final void move(@NotNull File installDir) {
        Intrinsics.checkNotNullParameter((Object)installDir, (String)"installDir");
        Platform.OS os = Platform.INSTANCE.getCurrentPlatform().getOs();
        if (os.isLinux()) {
            this.linuxMove(installDir);
        } else if (os.isMacOSX()) {
            this.macMove(installDir);
        } else if (os.isWindows()) {
            this.winMove(installDir);
        } else {
            this.linuxMove(installDir);
        }
    }

    private final void linuxMove(File installDir) {
        block4: {
            File foundDir = null;
            File foundParent = null;
            Iterable $this$forEach$iv = ExtendFileKt.listFilesSafely(installDir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File parent = (File)element$iv;
                boolean bl = false;
                if (!ExtendFileKt.existsSafely(new File(parent, "lib"))) continue;
                foundDir = new File(parent, "lib");
                foundParent = parent;
            }
            File file = foundDir;
            if (file == null) break block4;
            File it = file;
            boolean bl = false;
            File target = ExtendFileKt.moveSafely$default(it, new File(installDir, "lib"), false, 2, null);
            File file2 = foundParent;
            if (file2 != null) {
                File p = file2;
                boolean bl2 = false;
                ExtendFileKt.deleteDir(p);
                ExtendFileKt.deleteSafely(p);
                ExtendFileKt.deleteOnExitSafely(p);
            }
            Iterable $this$forEach$iv2 = ExtendFileKt.listFilesSafely(installDir);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File deleteCandidate = (File)element$iv;
                boolean bl3 = false;
                if (ExtendFileKt.isSame(deleteCandidate, target)) continue;
                ExtendFileKt.deleteSafely(deleteCandidate);
            }
            $this$forEach$iv2 = ExtendFileKt.listFilesSafely(target);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File moveCandidate = (File)element$iv;
                boolean bl4 = false;
                ExtendFileKt.moveSafely$default(moveCandidate, new File(installDir, moveCandidate.getName()), false, 2, null);
            }
            ExtendFileKt.deleteSafely(target);
        }
    }

    private final void macMove(File installDir) {
        block5: {
            File moveCandidate;
            File file;
            File foundDir = null;
            File foundParent = null;
            Iterable $this$forEach$iv = ExtendFileKt.listFilesSafely(installDir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File parent = (File)element$iv;
                boolean bl = false;
                if (!ExtendFileKt.existsSafely(new File(parent, "Contents"))) continue;
                foundDir = new File(parent, "Contents");
                foundParent = parent;
            }
            File it = file = new File(installDir, "lib");
            boolean bl = false;
            ExtendFileKt.mkdirSafely(it);
            File target = file;
            File file2 = foundDir;
            if (file2 == null) break block5;
            File contents = file2;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = ExtendFileKt.listFilesSafely(new File(contents, "Home/lib"));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                moveCandidate = (File)element$iv;
                boolean bl3 = false;
                ExtendFileKt.moveSafely$default(moveCandidate, new File(target, moveCandidate.getName()), false, 2, null);
            }
            ExtendFileKt.moveSafely$default(new File(contents, "Frameworks"), new File(target, "Frameworks"), false, 2, null);
            File file3 = foundParent;
            if (file3 != null) {
                File p = file3;
                boolean bl4 = false;
                ExtendFileKt.deleteDir(p);
                ExtendFileKt.deleteSafely(p);
                ExtendFileKt.deleteOnExitSafely(p);
            }
            $this$forEach$iv2 = ExtendFileKt.listFilesSafely(installDir);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File deleteCandidate = (File)element$iv;
                boolean bl5 = false;
                if (ExtendFileKt.isSame(deleteCandidate, target)) continue;
                ExtendFileKt.deleteSafely(deleteCandidate);
            }
            $this$forEach$iv2 = ExtendFileKt.listFilesSafely(target);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                moveCandidate = (File)element$iv;
                boolean bl6 = false;
                ExtendFileKt.moveSafely$default(moveCandidate, new File(installDir, moveCandidate.getName()), false, 2, null);
            }
            ExtendFileKt.deleteSafely(target);
        }
    }

    private final void winMove(File installDir) {
        block4: {
            File moveCandidate;
            File foundDir = null;
            Iterable $this$forEach$iv = ExtendFileKt.listFilesSafely(installDir);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File parent = (File)element$iv;
                boolean bl = false;
                if (!ExtendFileKt.existsSafely(new File(parent, "lib"))) continue;
                foundDir = parent;
            }
            File file = foundDir;
            if (file == null) break block4;
            File it = file;
            boolean bl = false;
            File target = ExtendFileKt.moveSafely$default(new File(it, "lib"), new File(installDir, "lib"), false, 2, null);
            Iterable $this$forEach$iv2 = ExtendFileKt.listFilesSafely(new File(it, "bin"));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                moveCandidate = (File)element$iv;
                boolean bl2 = false;
                ExtendFileKt.moveSafely$default(moveCandidate, new File(target, moveCandidate.getName()), false, 2, null);
            }
            $this$forEach$iv2 = ExtendFileKt.listFilesSafely(installDir);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                File deleteCandidate = (File)element$iv;
                boolean bl3 = false;
                if (ExtendFileKt.isSame(deleteCandidate, target)) continue;
                ExtendFileKt.deleteSafely(deleteCandidate);
            }
            $this$forEach$iv2 = ExtendFileKt.listFilesSafely(target);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                moveCandidate = (File)element$iv;
                boolean bl4 = false;
                ExtendFileKt.moveSafely$default(moveCandidate, new File(installDir, moveCandidate.getName()), false, 2, null);
            }
            ExtendFileKt.deleteSafely(target);
        }
    }

    @NotNull
    public String toString() {
        return "TarGzExtractor";
    }

    public int hashCode() {
        return 1618953152;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TarGzExtractor)) {
            return false;
        }
        TarGzExtractor cfr_ignored_0 = (TarGzExtractor)other;
        return true;
    }
}

