/*
 * Decompiled with CFR 0.152.
 */
package dev.dejvokep.boostedyaml.settings.updater;

import dev.dejvokep.boostedyaml.dvs.Pattern;
import dev.dejvokep.boostedyaml.dvs.versioning.AutomaticVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.ManualVersioning;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.route.Route;
import dev.dejvokep.boostedyaml.route.RouteFactory;
import dev.dejvokep.boostedyaml.settings.updater.MergeRule;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdaterSettings {
    public static final boolean DEFAULT_AUTO_SAVE = true;
    public static final boolean DEFAULT_ENABLE_DOWNGRADING = true;
    public static final boolean DEFAULT_KEEP_ALL = false;
    public static final Map<MergeRule, Boolean> DEFAULT_MERGE_RULES = Collections.unmodifiableMap(new HashMap<MergeRule, Boolean>(){
        {
            this.put(MergeRule.MAPPINGS, true);
            this.put(MergeRule.MAPPING_AT_SECTION, false);
            this.put(MergeRule.SECTION_AT_MAPPING, false);
        }
    });
    public static final Versioning DEFAULT_VERSIONING = null;
    public static final UpdaterSettings DEFAULT = UpdaterSettings.builder().build();
    private final boolean autoSave;
    private final boolean enableDowngrading;
    private final boolean keepAll;
    private final Map<MergeRule, Boolean> mergeRules;
    private final Map<String, Set<Route>> ignored;
    private final Map<String, Set<String>> stringIgnored;
    private final Map<String, Map<Route, Route>> relocations;
    private final Map<String, Map<String, String>> stringRelocations;
    private final Versioning versioning;

    public UpdaterSettings(Builder builder) {
        this.autoSave = builder.autoSave;
        this.enableDowngrading = builder.enableDowngrading;
        this.keepAll = builder.keepAll;
        this.mergeRules = builder.mergeRules;
        this.ignored = builder.ignored;
        this.stringIgnored = builder.stringIgnored;
        this.relocations = builder.relocations;
        this.stringRelocations = builder.stringRelocations;
        this.versioning = builder.versioning;
    }

    public Map<MergeRule, Boolean> getMergeRules() {
        return this.mergeRules;
    }

    public Set<Route> getIgnoredRoutes(@NotNull String versionId, char separator) {
        HashSet<Route> ignored = new HashSet<Route>(this.ignored.getOrDefault(versionId, Collections.emptySet()));
        if (this.stringIgnored.containsKey(versionId)) {
            RouteFactory factory = new RouteFactory(separator);
            for (String route : this.stringIgnored.get(versionId)) {
                ignored.add(factory.create(route));
            }
        }
        return ignored;
    }

    public Map<Route, Route> getRelocations(@NotNull String versionId, char separator) {
        HashMap<Route, Route> relocations = new HashMap<Route, Route>(this.relocations.getOrDefault(versionId, Collections.emptyNavigableMap()));
        if (this.stringRelocations.containsKey(versionId)) {
            RouteFactory factory = new RouteFactory(separator);
            for (Map.Entry<String, String> entry : this.stringRelocations.get(versionId).entrySet()) {
                relocations.computeIfAbsent(factory.create(entry.getKey()), route -> factory.create((String)entry.getValue()));
            }
        }
        return relocations;
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public boolean isEnableDowngrading() {
        return this.enableDowngrading;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UpdaterSettings settings) {
        return UpdaterSettings.builder().setAutoSave(settings.autoSave).setEnableDowngrading(settings.enableDowngrading).setKeepAll(settings.keepAll).setMergeRules(settings.mergeRules).setIgnoredRoutes(settings.ignored).setIgnoredStringRoutes(settings.stringIgnored).setRelocations(settings.relocations).setStringRelocations(settings.stringRelocations).setVersioning(settings.versioning);
    }

    public static class Builder {
        private boolean autoSave = true;
        private boolean enableDowngrading = true;
        private boolean keepAll = false;
        private final Map<MergeRule, Boolean> mergeRules = new HashMap<MergeRule, Boolean>(DEFAULT_MERGE_RULES);
        private final Map<String, Set<Route>> ignored = new HashMap<String, Set<Route>>();
        private final Map<String, Set<String>> stringIgnored = new HashMap<String, Set<String>>();
        private final Map<String, Map<Route, Route>> relocations = new HashMap<String, Map<Route, Route>>();
        private final Map<String, Map<String, String>> stringRelocations = new HashMap<String, Map<String, String>>();
        private Versioning versioning = DEFAULT_VERSIONING;

        private Builder() {
        }

        public Builder setAutoSave(boolean autoSave) {
            this.autoSave = autoSave;
            return this;
        }

        public Builder setEnableDowngrading(boolean enableDowngrading) {
            this.enableDowngrading = enableDowngrading;
            return this;
        }

        public Builder setKeepAll(boolean keepAll) {
            this.keepAll = keepAll;
            return this;
        }

        public Builder setMergeRules(@NotNull Map<MergeRule, Boolean> mergeRules) {
            this.mergeRules.putAll(mergeRules);
            return this;
        }

        public Builder setMergeRule(@NotNull MergeRule rule, boolean preserveDocument) {
            this.mergeRules.put(rule, preserveDocument);
            return this;
        }

        public Builder setIgnoredRoutes(@NotNull Map<String, Set<Route>> routes) {
            this.ignored.putAll(routes);
            return this;
        }

        public Builder setIgnoredRoutes(@NotNull String versionId, @NotNull Set<Route> routes) {
            this.ignored.put(versionId, routes);
            return this;
        }

        public Builder setIgnoredStringRoutes(@NotNull Map<String, Set<String>> routes) {
            this.stringIgnored.putAll(routes);
            return this;
        }

        public Builder setIgnoredStringRoutes(@NotNull String versionId, @NotNull Set<String> routes) {
            this.stringIgnored.put(versionId, routes);
            return this;
        }

        public Builder setRelocations(@NotNull Map<String, Map<Route, Route>> relocations) {
            this.relocations.putAll(relocations);
            return this;
        }

        public Builder setRelocations(@NotNull String versionId, @NotNull Map<Route, Route> relocations) {
            this.relocations.put(versionId, relocations);
            return this;
        }

        public Builder setStringRelocations(@NotNull Map<String, Map<String, String>> relocations) {
            this.stringRelocations.putAll(relocations);
            return this;
        }

        public Builder setStringRelocations(@NotNull String versionId, @NotNull Map<String, String> relocations) {
            this.stringRelocations.put(versionId, relocations);
            return this;
        }

        public Builder setVersioning(@NotNull Versioning versioning) {
            this.versioning = versioning;
            return this;
        }

        public Builder setVersioning(@NotNull Pattern pattern, @Nullable String documentVersionId, @NotNull String defaultsVersionId) {
            return this.setVersioning(new ManualVersioning(pattern, documentVersionId, defaultsVersionId));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull Route route) {
            return this.setVersioning(new AutomaticVersioning(pattern, route));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull String route) {
            return this.setVersioning(new AutomaticVersioning(pattern, route));
        }

        public UpdaterSettings build() {
            return new UpdaterSettings(this);
        }
    }
}

