/*
 * Decompiled with CFR 0.152.
 */
package dev.dejvokep.boostedyaml.updater;

import dev.dejvokep.boostedyaml.block.Block;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.dvs.Version;
import dev.dejvokep.boostedyaml.route.Route;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Relocator {
    private final Section section;
    private final Version documentVersion;
    private final Version defaultsVersion;

    public Relocator(@NotNull Section section, @NotNull Version documentVersion, @NotNull Version defaultsVersion) {
        this.section = section;
        this.documentVersion = documentVersion;
        this.defaultsVersion = defaultsVersion;
    }

    public void apply(@NotNull UpdaterSettings settings, char separator) {
        Version current = this.documentVersion.copy();
        while (current.compareTo(this.defaultsVersion) <= 0) {
            current.next();
            Map<Route, Route> relocations = settings.getRelocations(current.asID(), separator);
            if (relocations.isEmpty()) continue;
            while (relocations.size() > 0) {
                this.apply(relocations, relocations.keySet().iterator().next());
            }
        }
    }

    private void apply(@NotNull Map<Route, Route> relocations, @Nullable Route from) {
        if (from == null || !relocations.containsKey(from)) {
            return;
        }
        Optional<Section> parent = this.section.getParent(from);
        if (!parent.isPresent()) {
            relocations.remove(from);
            return;
        }
        Object lastKey = from.get(from.length() - 1);
        Block block = (Block)((Map)parent.get().getStoredValue()).get(lastKey);
        if (block == null) {
            relocations.remove(from);
            return;
        }
        Route to = relocations.get(from);
        relocations.remove(from);
        ((Map)parent.get().getStoredValue()).remove(lastKey);
        this.removeParents(parent.get());
        this.apply(relocations, to);
        this.section.set(to, (Object)block);
    }

    private void removeParents(@NotNull Section section) {
        if (section.isEmpty(false) && !section.isRoot()) {
            ((Map)section.getParent().getStoredValue()).remove(section.getName());
            this.removeParents(section.getParent());
        }
    }
}

