/*
 * Decompiled with CFR 0.152.
 */
package dev.dejvokep.boostedyaml.updater;

import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.dvs.Version;
import dev.dejvokep.boostedyaml.dvs.versioning.Versioning;
import dev.dejvokep.boostedyaml.route.Route;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import dev.dejvokep.boostedyaml.updater.Merger;
import dev.dejvokep.boostedyaml.updater.Relocator;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Updater {
    private static final Updater instance = new Updater();

    public static void update(@NotNull Section document, @NotNull Section defaults, @NotNull UpdaterSettings updaterSettings, @NotNull GeneralSettings generalSettings) throws IOException {
        if (instance.runVersionDependent(document, defaults, updaterSettings, generalSettings.getRouteSeparator())) {
            return;
        }
        Merger.merge(document, defaults, updaterSettings);
        if (updaterSettings.getVersioning() != null) {
            updaterSettings.getVersioning().updateVersionID(document, defaults);
        }
        if (updaterSettings.isAutoSave()) {
            document.getRoot().save();
        }
    }

    private boolean runVersionDependent(@NotNull Section document, @NotNull Section defaults, @NotNull UpdaterSettings settings, char separator) {
        int compared;
        Versioning versioning = settings.getVersioning();
        if (versioning == null) {
            return false;
        }
        Version documentVersion = versioning.getDocumentVersion(document, false);
        Version defaultsVersion = Objects.requireNonNull(versioning.getDocumentVersion(defaults, true), "Version ID of the defaults cannot be null! Is it malformed or not specified?");
        int n = compared = documentVersion != null ? documentVersion.compareTo(defaultsVersion) : -1;
        if (compared > 0 && !settings.isEnableDowngrading()) {
            throw new UnsupportedOperationException(String.format("Downgrading is not enabled (%s > %s)!", defaultsVersion.asID(), documentVersion.asID()));
        }
        if (compared == 0) {
            return true;
        }
        if (compared < 0) {
            Relocator relocator = new Relocator(document, documentVersion != null ? documentVersion : versioning.getFirstVersion(), defaultsVersion);
            relocator.apply(settings, separator);
        }
        for (Route route : settings.getIgnoredRoutes(defaultsVersion.asID(), separator)) {
            document.getOptionalBlock(route).ifPresent(block -> block.setIgnored(true));
        }
        return false;
    }
}

