/*
 * Decompiled with CFR 0.152.
 */
package dev.dialector.inkt.next;

import dev.dialector.inkt.next.DatabaseContext;
import dev.dialector.inkt.next.DerivedValue;
import dev.dialector.inkt.next.InputValue;
import dev.dialector.inkt.next.QueryContext;
import dev.dialector.inkt.next.QueryDatabase;
import dev.dialector.inkt.next.QueryDatabaseImpl;
import dev.dialector.inkt.next.QueryDefinition;
import dev.dialector.inkt.next.QueryExecutionContext;
import dev.dialector.inkt.next.QueryFrame;
import dev.dialector.inkt.next.QueryKey;
import dev.dialector.inkt.next.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\nH\u0002JK\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\u00152\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017JA\u0010\u0018\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\t2\u0006\u0010\u001a\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010\u001bJ4\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010\n\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\u0015H\u0002J>\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u0002H\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\n0\b\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\tH\u0002J4\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0006\u0010!\u001a\u00020\"J9\u0010\u001e\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\t2\u0006\u0010\u001a\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010#J,\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H%0'\u00a2\u0006\u0002\b)H\u0016\u00a2\u0006\u0002\u0010*J9\u0010+\u001a\u00020\"\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\t2\u0006\u0010\u001a\u001a\u0002H\u0012H\u0002\u00a2\u0006\u0002\u0010-JA\u0010.\u001a\u00020\"\"\b\b\u0000\u0010\u0012*\u00020\u0013\"\u0004\b\u0001\u0010\u00112\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u0002H\u00110\t2\u0006\u0010\u001a\u001a\u0002H\u00122\u0006\u0010\u000f\u001a\u0002H\u0011H\u0002\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J,\u00101\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002H%0'\u00a2\u0006\u0002\b)H\u0016\u00a2\u0006\u0002\u0010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ldev/dialector/inkt/next/QueryDatabaseImpl;", "Ldev/dialector/inkt/next/QueryDatabase;", "()V", "currentRevision", "", "lock", "Ljava/lang/Object;", "storage", "", "Ldev/dialector/inkt/next/QueryDefinition;", "Ldev/dialector/inkt/next/Value;", "deepVerify", "", "context", "Ldev/dialector/inkt/next/QueryExecutionContext;", "value", "execute", "V", "K", "", "queryKey", "Ldev/dialector/inkt/next/QueryKey;", "Ldev/dialector/inkt/next/DerivedValue;", "(Ldev/dialector/inkt/next/QueryExecutionContext;Ldev/dialector/inkt/next/QueryKey;Ldev/dialector/inkt/next/DerivedValue;)Ljava/lang/Object;", "fetch", "queryDef", "key", "(Ldev/dialector/inkt/next/QueryExecutionContext;Ldev/dialector/inkt/next/QueryDefinition;Ljava/lang/Object;)Ljava/lang/Object;", "get", "getQueryStorage", "query", "maybeChangedAfter", "asOfRevision", "print", "", "(Ldev/dialector/inkt/next/QueryDefinition;Ljava/lang/Object;)Ljava/lang/Object;", "readTransaction", "T", "body", "Lkotlin/Function1;", "Ldev/dialector/inkt/next/QueryContext;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "remove", "inputDef", "(Ldev/dialector/inkt/next/QueryDefinition;Ljava/lang/Object;)V", "set", "(Ldev/dialector/inkt/next/QueryDefinition;Ljava/lang/Object;Ljava/lang/Object;)V", "shallowVerify", "writeTransaction", "Ldev/dialector/inkt/next/DatabaseContext;", "QueryExecutionContextImpl", "inkt"})
@SourceDebugExtension(value={"SMAP\nQueryDatabaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryDatabaseImpl.kt\ndev/dialector/inkt/next/QueryDatabaseImpl\n+ 2 QueryDatabaseImpl.kt\ndev/dialector/inkt/next/QueryDatabaseImplKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,272:1\n38#2,2:273\n1#3:275\n2624#4,3:276\n215#5:279\n215#5,2:280\n216#5:282\n*S KotlinDebug\n*F\n+ 1 QueryDatabaseImpl.kt\ndev/dialector/inkt/next/QueryDatabaseImpl\n*L\n134#1:273,2\n175#1:276,3\n224#1:279\n226#1:280,2\n224#1:282\n*E\n"})
public final class QueryDatabaseImpl
implements QueryDatabase {
    @NotNull
    private final Map<QueryDefinition<?, ?>, Map<?, ? extends Value<?>>> storage = new LinkedHashMap();
    private int currentRevision;
    @NotNull
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T readTransaction(@NotNull Function1<? super QueryContext, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Object object2 = body.invoke((Object)new QueryContext(this){
                final /* synthetic */ QueryDatabaseImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public <K, V> V query(@NotNull QueryDefinition<K, V> definition, @NotNull K key) {
                    Intrinsics.checkNotNullParameter(definition, (String)"definition");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    return (V)QueryDatabaseImpl.access$query(this.this$0, definition, key);
                }

                public <V> V query(@NotNull QueryDefinition<Unit, V> definition) {
                    return QueryContext.DefaultImpls.query(this, definition);
                }
            });
            return (T)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T writeTransaction(@NotNull Function1<? super DatabaseContext, ? extends T> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            Object object2 = body.invoke((Object)new DatabaseContext(this){
                final /* synthetic */ QueryDatabaseImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public <K, V> V query(@NotNull QueryDefinition<K, V> definition, @NotNull K key) {
                    Intrinsics.checkNotNullParameter(definition, (String)"definition");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    return (V)QueryDatabaseImpl.access$query(this.this$0, definition, key);
                }

                public <K, V> void set(@NotNull QueryDefinition<K, V> definition, @NotNull K key, V value) {
                    Intrinsics.checkNotNullParameter(definition, (String)"definition");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    QueryDatabaseImpl.access$set(this.this$0, definition, key, value);
                }

                public <K, V> void remove(@NotNull QueryDefinition<K, V> definition, @NotNull K key) {
                    Intrinsics.checkNotNullParameter(definition, (String)"definition");
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    QueryDatabaseImpl.access$remove(this.this$0, definition, key);
                }

                public <V> V query(@NotNull QueryDefinition<Unit, V> definition) {
                    return DatabaseContext.DefaultImpls.query(this, definition);
                }

                public <V> void set(@NotNull QueryDefinition<Unit, V> definition, V value) {
                    DatabaseContext.DefaultImpls.set(this, definition, value);
                }

                public <V> void remove(@NotNull QueryDefinition<Unit, V> definition) {
                    DatabaseContext.DefaultImpls.remove(this, definition);
                }
            });
            return (T)object2;
        }
    }

    private final <K, V> Map<K, Value<V>> getQueryStorage(QueryDefinition<K, V> query2) {
        Map map = this.storage.computeIfAbsent(query2, arg_0 -> QueryDatabaseImpl.getQueryStorage$lambda$2(getQueryStorage.1.INSTANCE, arg_0));
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<K of dev.dialector.inkt.next.QueryDatabaseImpl.getQueryStorage, dev.dialector.inkt.next.Value<V of dev.dialector.inkt.next.QueryDatabaseImpl.getQueryStorage>>");
        return TypeIntrinsics.asMutableMap((Object)map);
    }

    private final <K, V> Value<V> get(QueryKey<K, V> queryKey) {
        return this.getQueryStorage(queryKey.getQueryDef()).get(queryKey.getKey());
    }

    private final <K, V> void set(QueryDefinition<K, V> inputDef, K key, V value) {
        Map<K, Value<InputValue<V>>> queryStorage = this.getQueryStorage(inputDef);
        Value<V> currentValue = queryStorage.get(key);
        if (currentValue instanceof InputValue) {
            ((InputValue)currentValue).setValue(value);
            ++this.currentRevision;
            ((InputValue)currentValue).setChangedAt(this.currentRevision);
        } else {
            ++this.currentRevision;
            queryStorage.put(key, new InputValue<V>(value, this.currentRevision));
        }
    }

    private final <K, V> void remove(QueryDefinition<K, V> inputDef, K key) {
        this.getQueryStorage(inputDef).remove(key);
        ++this.currentRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K, V> V query(QueryDefinition<K, V> queryDef, K key) {
        V v;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            v = this.fetch(new QueryExecutionContextImpl(this), queryDef, key);
        }
        return v;
    }

    private final <K, V> V fetch(QueryExecutionContext context, QueryDefinition<K, V> queryDef, K key) {
        Object object;
        QueryKey<K, V> queryKey = new QueryKey<K, V>(queryDef, key);
        Map<K, Value<V>> queryStorage = this.getQueryStorage(queryDef);
        Value<V> existingValue = queryStorage.get(key);
        if (existingValue instanceof InputValue) {
            context.addDependency(queryKey, ((InputValue)existingValue).getChangedAt());
            object = ((InputValue)existingValue).getValue();
        } else if (existingValue instanceof DerivedValue) {
            if (this.deepVerify(context, existingValue)) {
                context.addDependency(queryKey, ((DerivedValue)existingValue).getChangedAt());
                object = ((DerivedValue)existingValue).getValue();
            } else {
                object = this.execute(context, queryKey, (DerivedValue)existingValue);
            }
        } else if (existingValue == null) {
            object = QueryDatabaseImpl.execute$default(this, context, queryKey, null, 4, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final <K, V> V execute(QueryExecutionContext context, QueryKey<K, V> queryKey, DerivedValue<V> storage) {
        int queryRevision = this.currentRevision;
        QueryDefinition<K, V> definition = queryKey.component1();
        K key = queryKey.component2();
        QueryExecutionContext $this$withFrame$iv = context;
        boolean $i$f$withFrame = false;
        $this$withFrame$iv.pushFrame(queryKey);
        boolean bl = false;
        Pair pair = TuplesKt.to(definition.execute(context, key), $this$withFrame$iv.popFrame());
        Object value = pair.component1();
        QueryFrame frame = (QueryFrame)pair.component2();
        boolean bl2 = bl = queryRevision == this.currentRevision;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-QueryDatabaseImpl$execute$32 = false;
            String $i$a$-assert-QueryDatabaseImpl$execute$32 = "Database revision was modified during query execution.";
            throw new AssertionError((Object)$i$a$-assert-QueryDatabaseImpl$execute$32);
        }
        Map<K, Value<DerivedValue<Object>>> queryStorage = this.getQueryStorage(definition);
        DerivedValue<V> derivedValue = storage;
        int changedAt = (derivedValue != null ? derivedValue.getValue() : null) != null && Intrinsics.areEqual(storage.getValue(), (Object)value) ? storage.getChangedAt() : frame.getMaxRevision();
        queryStorage.put(key, new DerivedValue<Object>(value, CollectionsKt.toList((Iterable)frame.getDependencies()), queryRevision, changedAt));
        return (V)value;
    }

    static /* synthetic */ Object execute$default(QueryDatabaseImpl queryDatabaseImpl, QueryExecutionContext queryExecutionContext, QueryKey queryKey, DerivedValue derivedValue, int n, Object object) {
        if ((n & 4) != 0) {
            derivedValue = null;
        }
        return queryDatabaseImpl.execute(queryExecutionContext, queryKey, derivedValue);
    }

    private final boolean shallowVerify(Value<?> value) {
        boolean bl;
        Value<?> value2 = value;
        if (value2 instanceof InputValue) {
            bl = value.getChangedAt() <= this.currentRevision;
        } else if (value2 instanceof DerivedValue) {
            bl = ((DerivedValue)value).getVerifiedAt() == this.currentRevision;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final boolean deepVerify(QueryExecutionContext context, Value<?> value) {
        Value<?> value2 = value;
        if (!(value2 instanceof InputValue)) {
            if (value2 instanceof DerivedValue) {
                boolean noDepsChanged;
                block9: {
                    boolean bl;
                    if (this.shallowVerify(value)) {
                        return true;
                    }
                    Iterable $this$none$iv = ((DerivedValue)value).getDependencies();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            boolean bl2;
                            QueryKey dep = (QueryKey)element$iv;
                            boolean bl3 = false;
                            if (this.get(dep) != null) {
                                Value it;
                                boolean bl4 = false;
                                bl2 = this.maybeChangedAfter(context, dep, it, ((DerivedValue)value).getVerifiedAt());
                            } else {
                                bl2 = true;
                            }
                            if (!bl2) continue;
                            bl = false;
                            break block9;
                        }
                        bl = noDepsChanged = true;
                    }
                }
                if (noDepsChanged) {
                    ((DerivedValue)value).setVerifiedAt(this.currentRevision);
                }
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        return this.shallowVerify(value);
    }

    private final boolean maybeChangedAfter(QueryExecutionContext context, QueryKey<?, ?> key, Value<?> value, int asOfRevision) {
        if (value instanceof InputValue) {
            return this.shallowVerify(value);
        }
        if (this.shallowVerify(value)) {
            return value.getChangedAt() > asOfRevision;
        }
        if (this.deepVerify(context, value)) {
            return value.getChangedAt() > asOfRevision;
        }
        Object newValue = QueryDatabaseImpl.execute$default(this, context, key, null, 4, null);
        return !Intrinsics.areEqual(value, (Object)newValue);
    }

    public final void print() {
        System.out.println((Object)"=========================");
        System.out.println((Object)("Current revision = " + this.currentRevision));
        Map<QueryDefinition<?, ?>, Map<?, Value<?>>> $this$forEach$iv = this.storage;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<QueryDefinition<?, ?>, Map<?, Value<?>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<QueryDefinition<?, ?>, Map<?, Value<?>>> element$iv;
            Map.Entry<QueryDefinition<?, ?>, Map<?, Value<?>>> entry = element$iv = iterator.next();
            boolean bl = false;
            QueryDefinition<?, ?> query2 = entry.getKey();
            Map<?, Value<?>> store = entry.getValue();
            System.out.println((Object)("Query store: " + query2));
            Map<?, Value<?>> $this$forEach$iv2 = store;
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<?, Value<?>>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<?, Value<?>> element$iv2;
                Map.Entry<?, Value<?>> entry2 = element$iv2 = iterator2.next();
                boolean bl2 = false;
                Object key = entry2.getKey();
                Value<?> value = entry2.getValue();
                System.out.println((Object)("  " + key + " to " + value));
            }
        }
        System.out.println((Object)"=========================");
    }

    private static final Map getQueryStorage$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$query(QueryDatabaseImpl $this, QueryDefinition queryDef, Object key) {
        return $this.query(queryDef, key);
    }

    public static final /* synthetic */ void access$set(QueryDatabaseImpl $this, QueryDefinition inputDef, Object key, Object value) {
        $this.set(inputDef, key, value);
    }

    public static final /* synthetic */ void access$remove(QueryDatabaseImpl $this, QueryDefinition inputDef, Object key) {
        $this.remove(inputDef, key);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0016J9\u0010\u0011\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\u0004\b\u0001\u0010\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\u00162\u0006\u0010\n\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/dialector/inkt/next/QueryDatabaseImpl$QueryExecutionContextImpl;", "Ldev/dialector/inkt/next/QueryExecutionContext;", "database", "Ldev/dialector/inkt/next/QueryDatabaseImpl;", "(Ldev/dialector/inkt/next/QueryDatabaseImpl;)V", "queryStack", "", "Ldev/dialector/inkt/next/QueryFrame;", "addDependency", "", "key", "Ldev/dialector/inkt/next/QueryKey;", "revision", "", "checkCanceled", "popFrame", "pushFrame", "query", "V", "K", "", "definition", "Ldev/dialector/inkt/next/QueryDefinition;", "(Ldev/dialector/inkt/next/QueryDefinition;Ljava/lang/Object;)Ljava/lang/Object;", "inkt"})
    @SourceDebugExtension(value={"SMAP\nQueryDatabaseImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryDatabaseImpl.kt\ndev/dialector/inkt/next/QueryDatabaseImpl$QueryExecutionContextImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1747#2,3:273\n*S KotlinDebug\n*F\n+ 1 QueryDatabaseImpl.kt\ndev/dialector/inkt/next/QueryDatabaseImpl$QueryExecutionContextImpl\n*L\n242#1:273,3\n*E\n"})
    public static final class QueryExecutionContextImpl
    implements QueryExecutionContext {
        @NotNull
        private final QueryDatabaseImpl database;
        @NotNull
        private final List<QueryFrame<?>> queryStack;

        public QueryExecutionContextImpl(@NotNull QueryDatabaseImpl database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            this.database = database;
            this.queryStack = new ArrayList();
        }

        @Override
        public <K, V> V query(@NotNull QueryDefinition<K, V> definition, @NotNull K key) {
            Intrinsics.checkNotNullParameter(definition, (String)"definition");
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return (V)this.database.fetch(this, definition, key);
        }

        private final void checkCanceled() {
        }

        @Override
        public void pushFrame(@NotNull QueryKey<?, ?> key) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                this.checkCanceled();
                Iterable $this$any$iv = this.queryStack;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        QueryFrame it = (QueryFrame)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getQueryKey(), key)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException("Cycle detected: " + key.presentation() + " already in " + CollectionsKt.joinToString$default((Iterable)this.queryStack, null, null, null, (int)0, null, (Function1)pushFrame.2.INSTANCE, (int)31, null));
            }
            this.queryStack.add(new QueryFrame(key, 0, null, 6, null));
        }

        @Override
        @NotNull
        public QueryFrame<?> popFrame() {
            QueryFrame endedFrame;
            block1: {
                endedFrame = (QueryFrame)CollectionsKt.removeLast(this.queryStack);
                QueryFrame queryFrame = (QueryFrame)CollectionsKt.lastOrNull(this.queryStack);
                if (queryFrame == null) break block1;
                QueryFrame priorFrame = queryFrame;
                boolean bl = false;
                ((Collection)priorFrame.getDependencies()).add(endedFrame.getQueryKey());
                if (priorFrame.getMaxRevision() < endedFrame.getMaxRevision()) {
                    priorFrame.setMaxRevision(endedFrame.getMaxRevision());
                }
            }
            return endedFrame;
        }

        @Override
        public void addDependency(@NotNull QueryKey<?, ?> key, int revision) {
            block1: {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                QueryFrame queryFrame = (QueryFrame)CollectionsKt.lastOrNull(this.queryStack);
                if (queryFrame == null) break block1;
                QueryFrame frame = queryFrame;
                boolean bl = false;
                ((Collection)frame.getDependencies()).add(key);
                if (frame.getMaxRevision() < revision) {
                    frame.setMaxRevision(revision);
                }
            }
        }

        @Override
        public <V> V query(@NotNull QueryDefinition<Unit, V> definition) {
            return QueryExecutionContext.DefaultImpls.query(this, definition);
        }
    }
}

