/*
 * Decompiled with CFR 0.152.
 */
package dev.diceroll.parser;

import dev.diceroll.parser.Comparison;
import dev.diceroll.parser.CompoundingDice;
import dev.diceroll.parser.DiceExpression;
import dev.diceroll.parser.DiceRollingVisitor;
import dev.diceroll.parser.DiceRollingVisitorKt;
import dev.diceroll.parser.DiceVisitor;
import dev.diceroll.parser.DiceX;
import dev.diceroll.parser.ExplodingDice;
import dev.diceroll.parser.FudgeDice;
import dev.diceroll.parser.KeepDice;
import dev.diceroll.parser.KeepLowDice;
import dev.diceroll.parser.MathExpression;
import dev.diceroll.parser.MaxDiceExpression;
import dev.diceroll.parser.MinDiceExpression;
import dev.diceroll.parser.NDice;
import dev.diceroll.parser.NegativeDiceExpression;
import dev.diceroll.parser.NumberExpression;
import dev.diceroll.parser.Operation;
import dev.diceroll.parser.ResultTree;
import dev.diceroll.parser.SortedDiceExpression;
import dev.diceroll.parser.TargetPoolDice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J:\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001c\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0002J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\rH\u0002J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u00101\u001a\u000202H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010\u001c\u001a\u00020\u00022\u0006\u00107\u001a\u000208H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ldev/diceroll/parser/DiceRollingVisitor;", "Ldev/diceroll/parser/DiceVisitor;", "Ldev/diceroll/parser/ResultTree;", "()V", "randomGenerator", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "compoundRoll", "", "numberOfDice", "numberOfFaces", "predicate", "", "maxRolls", "doFudgeRoll", "sides", "weight", "explodeRoll", "makeNegative", "resultTree", "orderResultTree", "ascending", "comparison", "Ldev/diceroll/parser/Comparison;", "target", "random", "recursiveRoll", "visit", "compoundingDice", "Ldev/diceroll/parser/CompoundingDice;", "diceX", "Ldev/diceroll/parser/DiceX;", "explodingDice", "Ldev/diceroll/parser/ExplodingDice;", "fudgeDice", "Ldev/diceroll/parser/FudgeDice;", "keepDice", "Ldev/diceroll/parser/KeepDice;", "keepLowDice", "Ldev/diceroll/parser/KeepLowDice;", "mathExpressionResult", "Ldev/diceroll/parser/MathExpression;", "maxDiceExpression", "Ldev/diceroll/parser/MaxDiceExpression;", "minDiceExpression", "Ldev/diceroll/parser/MinDiceExpression;", "nDice", "Ldev/diceroll/parser/NDice;", "negativeDiceExpression", "Ldev/diceroll/parser/NegativeDiceExpression;", "value", "Ldev/diceroll/parser/NumberExpression;", "sortedDiceExpression", "Ldev/diceroll/parser/SortedDiceExpression;", "targetPoolDice", "Ldev/diceroll/parser/TargetPoolDice;", "dice-parser"})
@SourceDebugExtension(value={"SMAP\nDiceRollingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiceRollingVisitor.kt\ndev/diceroll/parser/DiceRollingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1549#2:230\n1620#2,3:231\n1549#2:234\n1620#2,3:235\n1549#2:238\n1620#2,3:239\n1549#2:242\n1620#2,3:243\n1549#2:246\n1620#2,3:247\n1549#2:250\n1620#2,3:251\n1549#2:254\n1620#2,3:255\n1549#2:258\n1620#2,3:259\n1549#2:262\n1620#2,3:263\n1549#2:266\n1620#2,3:267\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n1549#2:278\n1620#2,3:279\n1549#2:282\n1620#2,3:283\n1549#2:286\n1620#2,3:287\n1549#2:290\n1620#2,3:291\n1549#2:294\n1620#2,3:295\n1549#2:298\n1620#2,3:299\n1549#2:302\n1620#2,3:303\n766#2:306\n857#2,2:307\n1360#2:309\n1446#2,5:310\n1549#2:315\n1620#2,3:316\n766#2:319\n857#2,2:320\n1549#2:322\n1620#2,3:323\n*S KotlinDebug\n*F\n+ 1 DiceRollingVisitor.kt\ndev/diceroll/parser/DiceRollingVisitor\n*L\n104#1:230\n104#1:231,3\n105#1:234\n105#1:235,3\n107#1:238\n107#1:239,3\n120#1:242\n120#1:243,3\n121#1:246\n121#1:247,3\n123#1:250\n123#1:251,3\n128#1:254\n128#1:255,3\n129#1:258\n129#1:259,3\n131#1:262\n131#1:263,3\n136#1:266\n136#1:267,3\n137#1:270\n137#1:271,3\n139#1:274\n139#1:275,3\n144#1:278\n144#1:279,3\n145#1:282\n145#1:283,3\n151#1:286\n151#1:287,3\n152#1:290\n152#1:291,3\n157#1:294\n157#1:295,3\n158#1:298\n158#1:299,3\n159#1:302\n159#1:303,3\n159#1:306\n159#1:307,2\n166#1:309\n166#1:310,5\n192#1:315\n192#1:316,3\n196#1:319\n196#1:320,2\n197#1:322\n197#1:323,3\n*E\n"})
public final class DiceRollingVisitor
implements DiceVisitor<ResultTree> {
    @NotNull
    private final Function1<Integer, Integer> randomGenerator;

    public DiceRollingVisitor(@NotNull Function1<? super Integer, Integer> randomGenerator) {
        Intrinsics.checkNotNullParameter(randomGenerator, (String)"randomGenerator");
        this.randomGenerator = randomGenerator;
    }

    public DiceRollingVisitor() {
        this((Function1<? super Integer, Integer>)DiceRollingVisitorKt.access$getDefaultRandomGenerator$p());
    }

    private final int random(int numberOfFaces) {
        return ((Number)this.randomGenerator.invoke((Object)numberOfFaces)).intValue();
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull NumberExpression value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new ResultTree(value, value.getValue(), null, 4, null);
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull MathExpression mathExpressionResult) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mathExpressionResult, (String)"mathExpressionResult");
        ResultTree left = (ResultTree)this.visit(mathExpressionResult.getLeft());
        ResultTree right = (ResultTree)this.visit(mathExpressionResult.getRight());
        switch (WhenMappings.$EnumSwitchMapping$0[mathExpressionResult.getOperation().ordinal()]) {
            case 1: {
                n = Math.addExact(left.getValue(), right.getValue());
                break;
            }
            case 2: {
                n = Math.subtractExact(left.getValue(), right.getValue());
                break;
            }
            case 3: {
                n = Math.multiplyExact(left.getValue(), right.getValue());
                break;
            }
            case 4: {
                n = Math.floorDiv(left.getValue(), right.getValue());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int result = n;
        Object[] objectArray = new ResultTree[]{left, right};
        return new ResultTree(mathExpressionResult, result, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull NegativeDiceExpression negativeDiceExpression) {
        Intrinsics.checkNotNullParameter((Object)negativeDiceExpression, (String)"negativeDiceExpression");
        ResultTree resultTree = this.makeNegative((ResultTree)this.visit(negativeDiceExpression.getValue()));
        return new ResultTree(negativeDiceExpression, resultTree.getValue(), resultTree.getResults());
    }

    private final ResultTree makeNegative(ResultTree resultTree) {
        DiceExpression expression = resultTree.getExpression();
        int value = Math.multiplyExact(resultTree.getValue(), -1);
        List<ResultTree> results2 = resultTree.getResults().stream().map(arg_0 -> DiceRollingVisitor.makeNegative$lambda$0((Function1)new Function1<ResultTree, ResultTree>(this){
            final /* synthetic */ DiceRollingVisitor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ResultTree invoke(ResultTree r) {
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                return DiceRollingVisitor.access$makeNegative(this.this$0, r);
            }
        }, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(results2, (String)"results");
        return new ResultTree(expression, value, results2);
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull SortedDiceExpression sortedDiceExpression) {
        Intrinsics.checkNotNullParameter((Object)sortedDiceExpression, (String)"sortedDiceExpression");
        ResultTree resultTree = this.orderResultTree((ResultTree)this.visit(sortedDiceExpression.getValue()), sortedDiceExpression.getSortAscending());
        return new ResultTree(sortedDiceExpression, resultTree.getValue(), resultTree.getResults());
    }

    private final ResultTree orderResultTree(ResultTree resultTree, boolean ascending) {
        Comparator<Object> orderComparator2 = ascending ? Comparator.comparing(arg_0 -> DiceRollingVisitor.orderResultTree$lambda$1((Function1)orderResultTree.orderComparator.1.INSTANCE, arg_0)) : Comparator.comparing(arg_0 -> DiceRollingVisitor.orderResultTree$lambda$2((Function1)orderResultTree.orderComparator.2.INSTANCE, arg_0)).reversed();
        List<ResultTree> results2 = resultTree.getResults().stream().map(arg_0 -> DiceRollingVisitor.orderResultTree$lambda$3((Function1)new Function1<ResultTree, ResultTree>(this, ascending){
            final /* synthetic */ DiceRollingVisitor this$0;
            final /* synthetic */ boolean $ascending;
            {
                this.this$0 = $receiver;
                this.$ascending = $ascending;
                super(1);
            }

            public final ResultTree invoke(ResultTree r) {
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                return DiceRollingVisitor.access$orderResultTree(this.this$0, r, this.$ascending);
            }
        }, arg_0)).sorted(orderComparator2).collect(Collectors.toList());
        DiceExpression diceExpression = resultTree.getExpression();
        int n = resultTree.getValue();
        Intrinsics.checkNotNullExpressionValue(results2, (String)"results");
        return new ResultTree(diceExpression, n, results2);
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull MinDiceExpression minDiceExpression) {
        Intrinsics.checkNotNullParameter((Object)minDiceExpression, (String)"minDiceExpression");
        ResultTree left = (ResultTree)this.visit(minDiceExpression.getLeft());
        ResultTree right = (ResultTree)this.visit(minDiceExpression.getRight());
        return left.getValue() > right.getValue() ? right : left;
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull MaxDiceExpression maxDiceExpression) {
        Intrinsics.checkNotNullParameter((Object)maxDiceExpression, (String)"maxDiceExpression");
        ResultTree left = (ResultTree)this.visit(maxDiceExpression.getLeft());
        ResultTree right = (ResultTree)this.visit(maxDiceExpression.getRight());
        return left.getValue() > right.getValue() ? left : right;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull NDice nDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)nDice, (String)"nDice");
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, nDice.getNumberOfDice());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.random(nDice.getNumberOfFaces()));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(nDice.getNumberOfFaces(), 0, 2, null), it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map2 = values;
        DiceExpression diceExpression = nDice;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.getValue());
        }
        Object e = ((List)destination$iv$iv2).stream().reduce(DiceRollingVisitor::visit$lambda$7).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull DiceX diceX) {
        Intrinsics.checkNotNullParameter((Object)diceX, (String)"diceX");
        NDice nDice = new NDice(diceX.getNumberOfFaces(), diceX.getNumberOfDice());
        ResultTree left = this.visit(nDice);
        ResultTree right = this.visit(nDice);
        Object[] objectArray = new ResultTree[]{left, right};
        return new ResultTree(diceX, Math.multiplyExact(left.getValue(), right.getValue()), CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull FudgeDice fudgeDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)fudgeDice, (String)"fudgeDice");
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, fudgeDice.getNumberOfDice());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.doFudgeRoll(fudgeDice.getNumberOfFaces(), fudgeDice.getWeight()));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new FudgeDice(1, fudgeDice.getNumberOfFaces(), fudgeDice.getWeight()), it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map2 = values;
        DiceExpression diceExpression = fudgeDice;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.getValue());
        }
        Object e = ((List)destination$iv$iv2).stream().reduce(DiceRollingVisitor::visit$lambda$11).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull KeepDice keepDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)keepDice, (String)"keepDice");
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, keepDice.getNumberOfDice());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.random(keepDice.getNumberOfFaces()));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(keepDice.getNumberOfFaces(), 0, 2, null), it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map2 = values;
        DiceExpression diceExpression = keepDice;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.getValue());
        }
        Object e = CollectionsKt.take((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2))), (int)keepDice.getNumberToKeep()).stream().reduce(DiceRollingVisitor::visit$lambda$15).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull KeepLowDice keepLowDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)keepLowDice, (String)"keepLowDice");
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, keepLowDice.getNumberOfDice());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.random(keepLowDice.getNumberOfFaces()));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(keepLowDice.getNumberOfFaces(), 0, 2, null), it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map2 = values;
        DiceExpression diceExpression = keepLowDice;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.getValue());
        }
        Object e = CollectionsKt.take((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)), (int)keepLowDice.getNumberToKeep()).stream().reduce(DiceRollingVisitor::visit$lambda$19).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull ExplodingDice explodingDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)explodingDice, (String)"explodingDice");
        Iterable $this$map$iv2 = this.explodeRoll(explodingDice.getNumberOfDice(), explodingDice.getNumberOfFaces(), this.predicate(explodingDice.getComparison(), explodingDice.getTarget()));
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(explodingDice.getNumberOfFaces(), 0, 2, null), (int)it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map22 = values;
        DiceExpression diceExpression = explodingDice;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getValue());
        }
        Object e = ((List)destination$iv$iv2).stream().reduce(DiceRollingVisitor::visit$lambda$22).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull CompoundingDice compoundingDice) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)compoundingDice, (String)"compoundingDice");
        Iterable $this$map$iv2 = this.compoundRoll(compoundingDice.getNumberOfDice(), compoundingDice.getNumberOfFaces(), this.predicate(compoundingDice.getComparison(), compoundingDice.getTarget()), 100);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(compoundingDice.getNumberOfFaces(), 0, 2, null), (int)it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $i$f$map22 = values;
        DiceExpression diceExpression = compoundingDice;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getValue());
        }
        Object e = ((List)destination$iv$iv2).stream().reduce(DiceRollingVisitor::visit$lambda$25).get();
        Intrinsics.checkNotNullExpressionValue(e, (String)"values.map { it.value }.\u2026th.addExact(x, y) }.get()");
        List list = values;
        int n = ((Number)e).intValue();
        DiceExpression diceExpression2 = diceExpression;
        return new ResultTree(diceExpression2, n, list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResultTree visit(@NotNull TargetPoolDice targetPoolDice) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)targetPoolDice, (String)"targetPoolDice");
        Iterable $this$map$iv = (Iterable)new IntRange(1, targetPoolDice.getNumberOfDice());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.random(targetPoolDice.getNumberOfFaces()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ResultTree(new NDice(targetPoolDice.getNumberOfFaces(), 0, 2, null), it, null, 4, null));
        }
        List values = (List)destination$iv$iv;
        Iterable $this$map$iv2 = values;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultTree bl = (ResultTree)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getValue());
        }
        $this$map$iv2 = (List)destination$iv$iv2;
        Function1<Integer, Boolean> predicate$iv = this.predicate(targetPoolDice.getComparison(), targetPoolDice.getTarget());
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        int value = ((Collection)((List)destination$iv$iv3)).size();
        return new ResultTree(targetPoolDice, value, values);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> explodeRoll(int numberOfDice, int numberOfFaces, Function1<? super Integer, Boolean> predicate2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = (Iterable)new IntRange(1, numberOfDice);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv$iv;
            int it = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable list$iv$iv = this.recursiveRoll(numberOfFaces, predicate2, 50);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Integer> recursiveRoll(int numberOfFaces, Function1<? super Integer, Boolean> predicate2, int maxRolls) {
        if (!(maxRolls >= 0)) {
            boolean bl = false;
            String string = "Dice exploded too many times in a role, one of the following likely happened, your random number generator isn't actually random, you tried to explode a 'd1', or you just happened to be really lucky";
            throw new IllegalStateException(string.toString());
        }
        int result = this.random(numberOfFaces);
        return (Boolean)predicate2.invoke((Object)result) != false ? CollectionsKt.plus((Collection)this.recursiveRoll(numberOfFaces, predicate2, maxRolls - 1), (Object)result) : CollectionsKt.listOf((Object)result);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> compoundRoll(int numberOfDice, int numberOfFaces, Function1<? super Integer, Boolean> predicate2, int maxRolls) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        int n;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        if (!(maxRolls >= 0)) {
            boolean $i$a$-check-DiceRollingVisitor$compoundRoll$22 = false;
            String $i$a$-check-DiceRollingVisitor$compoundRoll$22 = "Dice compound too many times in a role, one of the following likely happened, your random number generator isn't actually random, you tried to explode a 'd1', or you just happened to be really lucky";
            throw new IllegalStateException($i$a$-check-DiceRollingVisitor$compoundRoll$22.toString());
        }
        Iterable $i$a$-check-DiceRollingVisitor$compoundRoll$22 = (Iterable)new IntRange(1, numberOfDice);
        boolean $i$f$map22 = false;
        void var8_10 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            n = 0;
            collection.add(this.random(numberOfFaces));
        }
        List dice = (List)destination$iv$iv;
        Iterable $i$f$map22 = dice;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.compoundRoll(numberOfDice, numberOfFaces, predicate2, maxRolls - 1));
        }
        List anotherRole = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
        return CollectionsKt.plus((Collection)dice, (Iterable)anotherRole);
    }

    private final Function1<Integer, Boolean> predicate(Comparison comparison, int target) {
        Function1 function1;
        switch (WhenMappings.$EnumSwitchMapping$1[comparison.ordinal()]) {
            case 1: {
                function1 = (Function1)new Function1<Integer, Boolean>(target){
                    final /* synthetic */ int $target;
                    {
                        this.$target = $target;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(int it) {
                        return it >= this.$target;
                    }
                };
                break;
            }
            case 2: {
                function1 = (Function1)new Function1<Integer, Boolean>(target){
                    final /* synthetic */ int $target;
                    {
                        this.$target = $target;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(int it) {
                        return it <= this.$target;
                    }
                };
                break;
            }
            case 3: {
                function1 = (Function1)new Function1<Integer, Boolean>(target){
                    final /* synthetic */ int $target;
                    {
                        this.$target = $target;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(int it) {
                        return it == this.$target;
                    }
                };
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function1;
    }

    private final int doFudgeRoll(int sides, int weight) {
        int random = this.random(sides);
        return random > Math.subtractExact(sides, weight) ? 1 : (random > Math.subtractExact(sides, Math.multiplyExact(weight, 2)) ? -1 : 0);
    }

    static /* synthetic */ int doFudgeRoll$default(DiceRollingVisitor diceRollingVisitor, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 6;
        }
        if ((n3 & 2) != 0) {
            n2 = Math.floorDiv(n, 3);
        }
        return diceRollingVisitor.doFudgeRoll(n, n2);
    }

    @Override
    @NotNull
    public ResultTree visit(@NotNull DiceExpression diceExpression) {
        return DiceVisitor.DefaultImpls.visit(this, diceExpression);
    }

    private static final ResultTree makeNegative$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResultTree)$tmp0.invoke(p0);
    }

    private static final Integer orderResultTree$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final Integer orderResultTree$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final ResultTree orderResultTree$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ResultTree)$tmp0.invoke(p0);
    }

    private static final Integer visit$lambda$7(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    private static final Integer visit$lambda$11(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    private static final Integer visit$lambda$15(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    private static final Integer visit$lambda$19(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    private static final Integer visit$lambda$22(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    private static final Integer visit$lambda$25(Integer x, Integer y) {
        Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
        int n = x;
        Intrinsics.checkNotNullExpressionValue((Object)y, (String)"y");
        return Math.addExact(n, y);
    }

    public static final /* synthetic */ ResultTree access$makeNegative(DiceRollingVisitor $this, ResultTree resultTree) {
        return $this.makeNegative(resultTree);
    }

    public static final /* synthetic */ ResultTree access$orderResultTree(DiceRollingVisitor $this, ResultTree resultTree, boolean ascending) {
        return $this.orderResultTree(resultTree, ascending);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Operation.values().length];
            try {
                nArray[Operation.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.SUBTRACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.MULTIPLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Operation.DIVIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Comparison.values().length];
            try {
                nArray[Comparison.GREATER_THAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Comparison.LESS_THAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Comparison.EQUAL_TO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

