/*
 * Decompiled with CFR 0.152.
 */
package dev.diceroll.parser.impl;

import dev.diceroll.parser.AddExpression;
import dev.diceroll.parser.Comparison;
import dev.diceroll.parser.CompoundingDice;
import dev.diceroll.parser.DiceExpression;
import dev.diceroll.parser.DivideExpression;
import dev.diceroll.parser.ExplodingDice;
import dev.diceroll.parser.FudgeDice;
import dev.diceroll.parser.KeepDice;
import dev.diceroll.parser.KeepLowDice;
import dev.diceroll.parser.MaxDiceExpression;
import dev.diceroll.parser.MinDiceExpression;
import dev.diceroll.parser.MultiplyExpression;
import dev.diceroll.parser.NDice;
import dev.diceroll.parser.NegativeDiceExpression;
import dev.diceroll.parser.NumberExpression;
import dev.diceroll.parser.ParseException;
import dev.diceroll.parser.SortedDiceExpression;
import dev.diceroll.parser.SubtractExpression;
import dev.diceroll.parser.TargetPoolDice;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u001d\u0018\u0000 82\u00020\u0001:\u00018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000fJ(\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010/\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00101\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00105\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00106\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u00107\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002RE\u0010\u0003\u001a6\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004j\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00069"}, d2={"Ldev/diceroll/parser/impl/RegexDice;", "", "()V", "parsers", "Ljava/util/LinkedHashMap;", "Lkotlin/text/Regex;", "Lkotlin/reflect/KFunction1;", "Lkotlin/text/MatchResult;", "Ldev/diceroll/parser/DiceExpression;", "Lkotlin/collections/LinkedHashMap;", "getParsers", "()Ljava/util/LinkedHashMap;", "comparisonFrom", "Ldev/diceroll/parser/Comparison;", "text", "", "fudgeRoll", "weight", "", "sides", "parse", "expression", "rollTargetPool", "numberOfDice", "numberOfFaces", "comp", "targetNumber", "validExpression", "", "visitAdd", "match", "visitCompoundDice", "visitCompoundDiceTarget", "visitDiceFace", "visitDiceFaceX", "visitDivide", "visitExplode", "visitExplodeTarget", "visitFudgeDice", "visitFudgeDiceDot", "visitInt", "visitKeepDice", "visitKeepLowDice", "visitMax", "visitMin", "visitMultiply", "visitNDiceFace", "visitNDiceFaceX", "visitNFudgeDice", "visitNFudgeDiceDot", "visitNegative", "visitNested", "visitSort", "visitSubtract", "visitTargetPool", "visitTargetPoolMod", "Companion", "dice-parser"})
@SourceDebugExtension(value={"SMAP\nRegexDice.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexDice.kt\ndev/diceroll/parser/impl/RegexDice\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,327:1\n515#2:328\n500#2,6:329\n457#2:335\n403#2:336\n467#2,7:341\n515#2:352\n500#2,6:353\n467#2,7:359\n1238#3,4:337\n125#4:348\n152#4,3:349\n1#5:366\n*S KotlinDebug\n*F\n+ 1 RegexDice.kt\ndev/diceroll/parser/impl/RegexDice\n*L\n97#1:328\n97#1:329,6\n98#1:335\n98#1:336\n99#1:341,7\n110#1:352\n110#1:353,6\n111#1:359,7\n98#1:337,4\n100#1:348\n100#1:349,3\n*E\n"})
public final class RegexDice {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<Regex, KFunction<DiceExpression>> parsers;
    @NotNull
    private static final String INT = "[0-9]+";
    @NotNull
    private static final String D = "[dD]";
    @NotNull
    private static final String X = "[xX]";
    @NotNull
    private static final String K = "[kK]";
    @NotNull
    private static final String L = "[lL]";
    @NotNull
    private static final String F = "[fF]";
    @NotNull
    private static final String DOT = "\\.";
    @NotNull
    private static final String LPAREN = "\\(";
    @NotNull
    private static final String RPAREN = "\\)";
    @NotNull
    private static final String LESS_THEN_EQUAL = "\\<";
    @NotNull
    private static final String GREATER_THEN_EQUAL = "\\>";
    @NotNull
    private static final String EQUAL = "=";
    @NotNull
    private static final String BANG = "!";
    @NotNull
    private static final String DICE_FACE = D + "(?<FACES>" + INT + ')';
    @NotNull
    private static final String N_DICE_FACE = "(?<numberOfDice>" + INT + ')' + DICE_FACE;
    @NotNull
    private static final String DICE_FACE_X = DICE_FACE + X;
    @NotNull
    private static final String N_DICE_FACE_X = "(?<numberOfDice>" + INT + ')' + DICE_FACE + X;
    @NotNull
    private static final String FUDGE_DICE = D + F;
    @NotNull
    private static final String N_FUDGE_DICE = "(?<numberOfDice>" + INT + ')' + D + F;
    @NotNull
    private static final String DOT_FUDGE_DICE = FUDGE_DICE + DOT + "(?<weight>" + INT + ')';
    @NotNull
    private static final String N_DOT_FUDGE_DICE = N_FUDGE_DICE + DOT + "(?<weight>" + INT + ')';
    @NotNull
    private static final String COMPOUND_DICE = N_DICE_FACE + BANG + BANG;
    @NotNull
    private static final String COMPOUND_DICE_TARGET = COMPOUND_DICE + "(?<comp>[" + LESS_THEN_EQUAL + GREATER_THEN_EQUAL + EQUAL + "]?)(?<target>" + INT + ')';
    @NotNull
    private static final String EXPLODE_DICE = N_DICE_FACE + BANG;
    @NotNull
    private static final String EXPLODE_DICE_TARGET = EXPLODE_DICE + "(?<comp>[" + LESS_THEN_EQUAL + GREATER_THEN_EQUAL + EQUAL + "]?)(?<target>" + INT + ')';
    @NotNull
    private static final Regex KEEP_DICE = new Regex(N_DICE_FACE + K + "(?<keep>" + INT + ')');
    @NotNull
    private static final Regex KEEP_LOW_DICE = new Regex(N_DICE_FACE + L + "(?<keep>" + INT + ')');
    @NotNull
    private static final String TARGET_POOL = N_DICE_FACE + "(?<operator>[" + LESS_THEN_EQUAL + GREATER_THEN_EQUAL + EQUAL + "])(?<target>" + INT + ')';
    @NotNull
    private static final String TARGET_POOL_PARENS = LPAREN + N_DICE_FACE + "(?<operation>[+-]?)(?<modifier>" + INT + ')' + RPAREN + "(?<operator>[" + LESS_THEN_EQUAL + GREATER_THEN_EQUAL + EQUAL + "])(?<target>" + INT + ')';
    @NotNull
    private static final Regex NESTED = new Regex("(?<LEFT>.*)" + LPAREN + "(?<NESTED>.*)" + RPAREN + "(?<RIGHT>.*)");
    @NotNull
    private static final Regex MUL = new Regex("(?<left>.+)\\*(?<right>.+)");
    @NotNull
    private static final Regex DIV = new Regex("(?<left>.+)/(?<right>.+)");
    @NotNull
    private static final Regex ADD = new Regex("(?<left>.+)\\+(?<right>.+)");
    @NotNull
    private static final Regex SUB = new Regex("(?<left>.+)-(?<right>.+)");
    @NotNull
    private static final Regex NEGATIVE = new Regex("-.+");
    @NotNull
    private static final Regex SORT = new Regex("(.+)(asc|desc)");
    @NotNull
    private static final Regex MIN = new Regex("(?<left>.+)min(?<right>.+)");
    @NotNull
    private static final Regex MAX = new Regex("(?<left>.+)max(?<right>.+)");

    public RegexDice() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SORT, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitSort((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(N_DICE_FACE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNDiceFace((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)KEEP_DICE, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitKeepDice((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)KEEP_LOW_DICE, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitKeepLowDice((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(DICE_FACE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitDiceFace((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(DICE_FACE_X), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitDiceFaceX((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(N_DICE_FACE_X), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNDiceFaceX((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(FUDGE_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitFudgeDice((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(N_FUDGE_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNFudgeDice((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(DOT_FUDGE_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitFudgeDiceDot((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(N_DOT_FUDGE_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNFudgeDiceDot((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(COMPOUND_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitCompoundDice((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(COMPOUND_DICE_TARGET), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitCompoundDiceTarget((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(EXPLODE_DICE), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitExplode((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(EXPLODE_DICE_TARGET), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitExplodeTarget((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(TARGET_POOL), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitTargetPool((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(TARGET_POOL_PARENS), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitTargetPoolMod((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)MIN, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitMin((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)MAX, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitMax((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)NESTED, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNested((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)ADD, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitAdd((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)SUB, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitSubtract((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)MUL, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitMultiply((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)DIV, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitDivide((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)NEGATIVE, (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitNegative((RegexDice)this.receiver, p0);
            }
        }), TuplesKt.to((Object)new Regex(INT), (Object)new Function1<MatchResult, DiceExpression>((Object)this){

            @NotNull
            public final DiceExpression invoke(@NotNull MatchResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RegexDice.access$visitInt((RegexDice)this.receiver, p0);
            }
        })};
        this.parsers = MapsKt.linkedMapOf((Pair[])pairArray);
    }

    @NotNull
    public final LinkedHashMap<Regex, KFunction<DiceExpression>> getParsers() {
        return this.parsers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DiceExpression parse(@NotNull String expression) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map $this$filterKeys$iv;
        Object object;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String trimmedExpression = ((Object)StringsKt.trim((CharSequence)expression)).toString();
        Map $this$filter$iv = this.parsers;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean bl = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            it = element$iv$iv;
            boolean bl2 = false;
            if (!((Regex)it.getKey()).matches((CharSequence)trimmedExpression)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$mapKeys = false;
        $this$filterTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean bl3 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it2;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            MatchResult matchResult = ((Regex)it2.getKey()).matchEntire((CharSequence)trimmedExpression);
            Map map2 = object;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            map2.put(matchResult, v);
        }
        $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            MatchResult it3 = (MatchResult)entry.getKey();
            boolean bl5 = false;
            if (!(it3 != null)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean bl6 = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            it = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl7 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k);
            object.add(new Pair(k, it.getValue()));
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (pair == null) {
            throw new ParseException("Failed to parse expression '" + expression + '\'');
        }
        Pair result = pair;
        return (DiceExpression)((Function1)result.getSecond()).invoke(result.getFirst());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validExpression(@NotNull String expression) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String trimmedExpression = ((Object)StringsKt.trim((CharSequence)expression)).toString();
        Map $this$filter$iv = this.parsers;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Regex)it.getKey()).matches((CharSequence)trimmedExpression)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$filterKeys$iv = destination$iv$iv;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Regex it = (Regex)entry$iv.getKey();
            boolean bl = false;
            if (!true) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return !((Map)result$iv).isEmpty();
    }

    private final DiceExpression visitInt(MatchResult match) {
        return new NumberExpression(Integer.parseInt(match.getValue()));
    }

    private final DiceExpression visitNested(MatchResult match) {
        DiceExpression middle = this.parse((String)match.getGroupValues().get(2));
        DiceExpression left = ((CharSequence)match.getGroupValues().get(1)).length() > 0 ? (DiceExpression)new MultiplyExpression(this.parse((String)match.getGroupValues().get(1)), middle) : middle;
        return ((CharSequence)match.getGroupValues().get(3)).length() > 0 ? (DiceExpression)new MultiplyExpression(left, this.parse((String)match.getGroupValues().get(3))) : left;
    }

    private final DiceExpression visitDiceFace(MatchResult match) {
        return this.visitDiceFace((String)match.getGroupValues().get(1));
    }

    private final DiceExpression visitDiceFace(String numberOfFaces) {
        return this.visitDiceFace(Integer.parseInt(numberOfFaces));
    }

    private final DiceExpression visitDiceFace(int numberOfFaces) {
        return new NDice(numberOfFaces, 0, 2, null);
    }

    private final DiceExpression visitNDiceFace(MatchResult match) {
        CharSequence charSequence;
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        CharSequence charSequence2 = (CharSequence)match.getGroupValues().get(1);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "1";
        } else {
            charSequence = charSequence2;
        }
        int numberOfDice = Integer.parseInt((String)charSequence);
        return new NDice(numberOfFaces, numberOfDice);
    }

    private final DiceExpression visitDiceFaceX(MatchResult match) {
        String numberOfFaces = (String)match.getGroupValues().get(1);
        return new MultiplyExpression(this.visitDiceFace(numberOfFaces), this.visitDiceFace(numberOfFaces));
    }

    private final DiceExpression visitNDiceFaceX(MatchResult match) {
        CharSequence charSequence;
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        CharSequence charSequence2 = (CharSequence)match.getGroupValues().get(1);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "1";
        } else {
            charSequence = charSequence2;
        }
        int numberOfDice = Integer.parseInt((String)charSequence);
        return new MultiplyExpression(new NDice(numberOfFaces, numberOfDice), new NDice(numberOfFaces, numberOfDice));
    }

    private final DiceExpression visitAdd(MatchResult match) {
        DiceExpression left = this.parse((String)match.getGroupValues().get(1));
        DiceExpression right = this.parse((String)match.getGroupValues().get(2));
        return new AddExpression(left, right);
    }

    private final DiceExpression visitSubtract(MatchResult match) {
        DiceExpression left = this.parse((String)match.getGroupValues().get(1));
        DiceExpression right = this.parse((String)match.getGroupValues().get(2));
        return new SubtractExpression(left, right);
    }

    private final DiceExpression visitMultiply(MatchResult match) {
        DiceExpression left = this.parse((String)match.getGroupValues().get(1));
        DiceExpression right = this.parse((String)match.getGroupValues().get(2));
        return new MultiplyExpression(left, right);
    }

    private final DiceExpression visitDivide(MatchResult match) {
        DiceExpression left = this.parse((String)match.getGroupValues().get(1));
        DiceExpression right = this.parse((String)match.getGroupValues().get(2));
        return new DivideExpression(left, right);
    }

    private final DiceExpression visitFudgeDice(MatchResult match) {
        return new FudgeDice(0, 0, 0, 7, null);
    }

    private final DiceExpression visitNFudgeDice(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        return new FudgeDice(numberOfDice, 0, 0, 6, null);
    }

    private final DiceExpression visitFudgeDiceDot(MatchResult match) {
        int weight = Integer.parseInt((String)match.getGroupValues().get(1));
        return RegexDice.fudgeRoll$default(this, weight, 0, 2, null);
    }

    private final DiceExpression visitNFudgeDiceDot(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int weight = Integer.parseInt((String)match.getGroupValues().get(2));
        return new FudgeDice(numberOfDice, 6, weight);
    }

    private final DiceExpression fudgeRoll(int weight, int sides) {
        return new FudgeDice(1, weight, 0, 4, null);
    }

    static /* synthetic */ DiceExpression fudgeRoll$default(RegexDice regexDice, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 6;
        }
        return regexDice.fudgeRoll(n, n2);
    }

    private final DiceExpression visitKeepDice(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        int numberToKeep = Integer.parseInt((String)match.getGroupValues().get(3));
        return new KeepDice(numberOfFaces, numberOfDice, numberToKeep);
    }

    private final DiceExpression visitKeepLowDice(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        int numberToKeep = Integer.parseInt((String)match.getGroupValues().get(3));
        return new KeepLowDice(numberOfFaces, numberOfDice, numberToKeep);
    }

    @NotNull
    public final Comparison comparisonFrom(@NotNull String text) {
        Comparison comparison;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text;
        if (Intrinsics.areEqual((Object)string, (Object)Comparison.GREATER_THAN.getDescription())) {
            comparison = Comparison.GREATER_THAN;
        } else if (Intrinsics.areEqual((Object)string, (Object)Comparison.LESS_THAN.getDescription())) {
            comparison = Comparison.LESS_THAN;
        } else if (Intrinsics.areEqual((Object)string, (Object)Comparison.EQUAL_TO.getDescription())) {
            comparison = Comparison.EQUAL_TO;
        } else {
            throw new IllegalArgumentException("Could not parse Comparison operator from '" + text + '\'');
        }
        return comparison;
    }

    private final DiceExpression visitTargetPool(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int diceFace = Integer.parseInt((String)match.getGroupValues().get(2));
        String comp = (String)match.getGroupValues().get(3);
        int targetNumber = Integer.parseInt((String)match.getGroupValues().get(4));
        return this.rollTargetPool(numberOfDice, diceFace, comp, targetNumber);
    }

    private final DiceExpression visitTargetPoolMod(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int diceFace = Integer.parseInt((String)match.getGroupValues().get(2));
        String operation = (String)match.getGroupValues().get(3);
        int modifier = Integer.parseInt((String)match.getGroupValues().get(4));
        String comp = (String)match.getGroupValues().get(5);
        int targetNumber = Integer.parseInt((String)match.getGroupValues().get(6));
        if (Intrinsics.areEqual((Object)operation, (Object)"+")) {
            targetNumber -= modifier;
        } else if (Intrinsics.areEqual((Object)operation, (Object)"-")) {
            targetNumber += modifier;
        }
        return this.rollTargetPool(numberOfDice, diceFace, comp, targetNumber);
    }

    private final DiceExpression rollTargetPool(int numberOfDice, int numberOfFaces, String comp, int targetNumber) {
        return new TargetPoolDice(numberOfFaces, numberOfDice, this.comparisonFrom(comp), targetNumber, 0, 16, null);
    }

    private final DiceExpression visitCompoundDice(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        return new CompoundingDice(numberOfFaces, numberOfDice, null, 0, 12, null);
    }

    private final DiceExpression visitCompoundDiceTarget(MatchResult match) {
        CharSequence charSequence;
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        CharSequence charSequence2 = (CharSequence)match.getGroupValues().get(3);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "=";
        } else {
            charSequence = charSequence2;
        }
        String comp = (String)charSequence;
        int target = Integer.parseInt((String)match.getGroupValues().get(4));
        return new CompoundingDice(numberOfFaces, numberOfDice, this.comparisonFrom(comp), target);
    }

    private final DiceExpression visitExplode(MatchResult match) {
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        return new ExplodingDice(numberOfFaces, numberOfDice, null, 0, 12, null);
    }

    private final DiceExpression visitExplodeTarget(MatchResult match) {
        CharSequence charSequence;
        int numberOfDice = Integer.parseInt((String)match.getGroupValues().get(1));
        int numberOfFaces = Integer.parseInt((String)match.getGroupValues().get(2));
        CharSequence charSequence2 = (CharSequence)match.getGroupValues().get(3);
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "=";
        } else {
            charSequence = charSequence2;
        }
        String comp = (String)charSequence;
        int target = Integer.parseInt((String)match.getGroupValues().get(4));
        return new ExplodingDice(numberOfFaces, numberOfDice, this.comparisonFrom(comp), target);
    }

    private final DiceExpression visitNegative(MatchResult match) {
        String string = ((Object)StringsKt.trim((CharSequence)match.getValue())).toString().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        return new NegativeDiceExpression(this.parse(string));
    }

    private final DiceExpression visitSort(MatchResult match) {
        String diceExpression = (String)match.getGroupValues().get(1);
        String order = (String)match.getGroupValues().get(2);
        return new SortedDiceExpression(this.parse(diceExpression), Intrinsics.areEqual((Object)order, (Object)"asc"));
    }

    private final DiceExpression visitMin(MatchResult match) {
        String left = (String)match.getGroupValues().get(1);
        String right = (String)match.getGroupValues().get(2);
        return new MinDiceExpression(this.parse(left), this.parse(right));
    }

    private final DiceExpression visitMax(MatchResult match) {
        String left = (String)match.getGroupValues().get(1);
        String right = (String)match.getGroupValues().get(2);
        return new MaxDiceExpression(this.parse(left), this.parse(right));
    }

    public static final /* synthetic */ DiceExpression access$visitSort(RegexDice $this, MatchResult match) {
        return $this.visitSort(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNDiceFace(RegexDice $this, MatchResult match) {
        return $this.visitNDiceFace(match);
    }

    public static final /* synthetic */ DiceExpression access$visitKeepDice(RegexDice $this, MatchResult match) {
        return $this.visitKeepDice(match);
    }

    public static final /* synthetic */ DiceExpression access$visitKeepLowDice(RegexDice $this, MatchResult match) {
        return $this.visitKeepLowDice(match);
    }

    public static final /* synthetic */ DiceExpression access$visitDiceFace(RegexDice $this, MatchResult match) {
        return $this.visitDiceFace(match);
    }

    public static final /* synthetic */ DiceExpression access$visitDiceFaceX(RegexDice $this, MatchResult match) {
        return $this.visitDiceFaceX(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNDiceFaceX(RegexDice $this, MatchResult match) {
        return $this.visitNDiceFaceX(match);
    }

    public static final /* synthetic */ DiceExpression access$visitFudgeDice(RegexDice $this, MatchResult match) {
        return $this.visitFudgeDice(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNFudgeDice(RegexDice $this, MatchResult match) {
        return $this.visitNFudgeDice(match);
    }

    public static final /* synthetic */ DiceExpression access$visitFudgeDiceDot(RegexDice $this, MatchResult match) {
        return $this.visitFudgeDiceDot(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNFudgeDiceDot(RegexDice $this, MatchResult match) {
        return $this.visitNFudgeDiceDot(match);
    }

    public static final /* synthetic */ DiceExpression access$visitCompoundDice(RegexDice $this, MatchResult match) {
        return $this.visitCompoundDice(match);
    }

    public static final /* synthetic */ DiceExpression access$visitCompoundDiceTarget(RegexDice $this, MatchResult match) {
        return $this.visitCompoundDiceTarget(match);
    }

    public static final /* synthetic */ DiceExpression access$visitExplode(RegexDice $this, MatchResult match) {
        return $this.visitExplode(match);
    }

    public static final /* synthetic */ DiceExpression access$visitExplodeTarget(RegexDice $this, MatchResult match) {
        return $this.visitExplodeTarget(match);
    }

    public static final /* synthetic */ DiceExpression access$visitTargetPool(RegexDice $this, MatchResult match) {
        return $this.visitTargetPool(match);
    }

    public static final /* synthetic */ DiceExpression access$visitTargetPoolMod(RegexDice $this, MatchResult match) {
        return $this.visitTargetPoolMod(match);
    }

    public static final /* synthetic */ DiceExpression access$visitMin(RegexDice $this, MatchResult match) {
        return $this.visitMin(match);
    }

    public static final /* synthetic */ DiceExpression access$visitMax(RegexDice $this, MatchResult match) {
        return $this.visitMax(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNested(RegexDice $this, MatchResult match) {
        return $this.visitNested(match);
    }

    public static final /* synthetic */ DiceExpression access$visitAdd(RegexDice $this, MatchResult match) {
        return $this.visitAdd(match);
    }

    public static final /* synthetic */ DiceExpression access$visitSubtract(RegexDice $this, MatchResult match) {
        return $this.visitSubtract(match);
    }

    public static final /* synthetic */ DiceExpression access$visitMultiply(RegexDice $this, MatchResult match) {
        return $this.visitMultiply(match);
    }

    public static final /* synthetic */ DiceExpression access$visitDivide(RegexDice $this, MatchResult match) {
        return $this.visitDivide(match);
    }

    public static final /* synthetic */ DiceExpression access$visitNegative(RegexDice $this, MatchResult match) {
        return $this.visitNegative(match);
    }

    public static final /* synthetic */ DiceExpression access$visitInt(RegexDice $this, MatchResult match) {
        return $this.visitInt(match);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b%\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/diceroll/parser/impl/RegexDice$Companion;", "", "()V", "ADD", "Lkotlin/text/Regex;", "BANG", "", "COMPOUND_DICE", "COMPOUND_DICE_TARGET", "D", "DICE_FACE", "DICE_FACE_X", "DIV", "DOT", "DOT_FUDGE_DICE", "EQUAL", "EXPLODE_DICE", "EXPLODE_DICE_TARGET", "F", "FUDGE_DICE", "GREATER_THEN_EQUAL", "INT", "K", "KEEP_DICE", "KEEP_LOW_DICE", "L", "LESS_THEN_EQUAL", "LPAREN", "MAX", "MIN", "MUL", "NEGATIVE", "NESTED", "N_DICE_FACE", "N_DICE_FACE_X", "N_DOT_FUDGE_DICE", "N_FUDGE_DICE", "RPAREN", "SORT", "SUB", "TARGET_POOL", "TARGET_POOL_PARENS", "X", "dice-parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

