/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo;

import dev.ditsche.mailo.MailAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Mail {
    private String subject;
    private MailAddress from;
    private final Set<MailAddress> recipients;
    private final Set<MailAddress> cc;
    private final Set<MailAddress> bcc;
    private MailAddress replyTo;
    private String body;

    public Mail(String subject) {
        this(subject, new MailAddress[0]);
    }

    public Mail(String subject, MailAddress ... to) {
        if (subject == null || subject.trim().isEmpty()) {
            throw new IllegalArgumentException("The mails \"subject\" can not be null or empty");
        }
        this.subject = subject = subject.trim();
        this.recipients = new HashSet<MailAddress>();
        if (to != null) {
            this.recipients.addAll(Arrays.asList((MailAddress[])to.clone()));
        }
        this.cc = new HashSet<MailAddress>();
        this.bcc = new HashSet<MailAddress>();
        this.body = null;
    }

    public void addRecipient(MailAddress ... mailAddress) {
        if (mailAddress == null || mailAddress.length == 0) {
            throw new IllegalArgumentException("At least one MailAddress must be provided");
        }
        this.recipients.addAll(Arrays.asList(mailAddress));
    }

    public void addCC(MailAddress ... mailAddress) {
        if (mailAddress == null || mailAddress.length == 0) {
            throw new IllegalArgumentException("At least one MailAddress must be provided");
        }
        this.cc.addAll(Arrays.asList(mailAddress));
    }

    public void addBCC(MailAddress ... mailAddress) {
        if (mailAddress == null || mailAddress.length == 0) {
            throw new IllegalArgumentException("At least one MailAddress must be provided");
        }
        this.bcc.addAll(Arrays.asList(mailAddress));
    }

    public Set<MailAddress> getRecipients() {
        return Collections.unmodifiableSet(this.recipients);
    }

    public Set<MailAddress> getCC() {
        return Collections.unmodifiableSet(this.cc);
    }

    public Set<MailAddress> getBCC() {
        return Collections.unmodifiableSet(this.bcc);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MailAddress getFrom() {
        return this.from;
    }

    public void setFrom(MailAddress from) {
        this.from = from;
    }

    public MailAddress getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(MailAddress replyTo) {
        this.replyTo = replyTo;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

