/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MailAddress {
    @JsonProperty(value="Email")
    private String email;
    @JsonProperty(value="Name")
    private String name;

    public MailAddress(String email) {
        this(email, null);
    }

    public MailAddress(String email, String name) {
        if (email == null || email.trim().isEmpty()) {
            throw new IllegalArgumentException("Field \"email\" can not be null or empty");
        }
        if (name != null && name.trim().isEmpty()) {
            throw new IllegalArgumentException("Field \"name\" can not be empty");
        }
        if (!this.isValid(email)) {
            throw new IllegalArgumentException(String.format("\"%s\" is not a valid email adress", email));
        }
        this.email = email.trim().toLowerCase();
        this.name = name != null ? name.trim() : null;
    }

    private boolean isValid(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public InternetAddress toAddress() {
        return new InternetAddress(this.email, this.name);
    }

    public String toString() {
        if (this.name != null) {
            return this.name + "<" + this.email + ">";
        }
        return this.email;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="Email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="Name")
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress other = (MailAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailAddress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }
}

