/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo.config;

import dev.ditsche.mailo.MailAddress;

public final class MailoConfig {
    private static MailoConfig instance;
    private String templateDirectory;
    private String mjmlAppId;
    private String mjmlAppSecret;
    private MailAddress defaultSender;
    private MailAddress defaultReplyTo;

    private MailoConfig() {
        this.init();
    }

    private void init() {
        this.templateDirectory = System.getenv("MAILO_TEMPLATE_DIR") != null ? System.getenv("MAILO_TEMPLATE_DIR") : "./templates/";
        this.mjmlAppId = System.getenv("MAILO_APP_ID");
        this.mjmlAppSecret = System.getenv("MAILO_APP_SECRET");
        this.defaultSender = null;
        this.defaultReplyTo = null;
    }

    public static MailoConfig get() {
        if (instance == null) {
            instance = new MailoConfig();
        }
        return instance;
    }

    public void setTemplateDirectory(String templateDirectory) {
        if (templateDirectory == null) {
            throw new IllegalArgumentException("templateDirectory can not be null");
        }
        this.templateDirectory = templateDirectory.trim();
    }

    public void setMjmlAppId(String mjmlAppId) {
        if (mjmlAppId == null) {
            throw new IllegalArgumentException("mjmlAppId can not be null");
        }
        this.mjmlAppId = mjmlAppId.trim();
    }

    public void setMjmlAppSecret(String mjmlAppSecret) {
        if (mjmlAppSecret == null) {
            throw new IllegalArgumentException("mjmlAppSecret can not be null");
        }
        this.mjmlAppSecret = mjmlAppSecret.trim();
    }

    public void reset() {
        this.init();
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public String getMjmlAppId() {
        return this.mjmlAppId;
    }

    public String getMjmlAppSecret() {
        return this.mjmlAppSecret;
    }

    public MailAddress getDefaultSender() {
        return this.defaultSender;
    }

    public void setDefaultSender(MailAddress defaultSender) {
        this.defaultSender = defaultSender;
    }

    public MailAddress getDefaultReplyTo() {
        return this.defaultReplyTo;
    }

    public void setDefaultReplyTo(MailAddress defaultReplyTo) {
        this.defaultReplyTo = defaultReplyTo;
    }
}

