/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo.factory;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import dev.ditsche.mailo.Mail;
import dev.ditsche.mailo.MailAddress;
import dev.ditsche.mailo.config.MailoConfig;
import dev.ditsche.mailo.exception.MailBuildException;
import dev.ditsche.mailo.exception.TemplateNotFoundException;
import dev.ditsche.mailo.factory.MailBuilder;
import dev.ditsche.mailo.factory.TemplateMailBuilder;
import dev.ditsche.mailo.mjml.MjmlClient;
import dev.ditsche.mailo.util.ClassLoaderUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class MjmlMailBuilder
implements TemplateMailBuilder {
    private final MjmlClient mjmlClient = new MjmlClient();
    private String subject;
    private final Set<MailAddress> toList = new HashSet<MailAddress>();
    private final Set<MailAddress> ccList = new HashSet<MailAddress>();
    private final Set<MailAddress> bccList = new HashSet<MailAddress>();
    private MailAddress from;
    private MailAddress replyTo;
    private final HashMap<String, Object> params = new HashMap();
    private String body;

    protected MjmlMailBuilder() {
    }

    @Override
    public TemplateMailBuilder subject(String subject) {
        if (subject == null || subject.trim().isEmpty()) {
            throw new IllegalArgumentException("Subject can not be null or empty");
        }
        this.subject = subject.trim();
        return this;
    }

    @Override
    public TemplateMailBuilder to(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.toList.add(recipient);
        return this;
    }

    @Override
    public TemplateMailBuilder cc(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.ccList.add(recipient);
        return this;
    }

    @Override
    public TemplateMailBuilder bcc(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.bccList.add(recipient);
        return this;
    }

    @Override
    public TemplateMailBuilder from(MailAddress from) {
        if (from == null) {
            throw new IllegalArgumentException("Sender can not be null");
        }
        this.from = from;
        return this;
    }

    @Override
    public TemplateMailBuilder replyTo(MailAddress replyTo) {
        if (replyTo == null) {
            throw new IllegalArgumentException("Reply To can not be null");
        }
        this.replyTo = replyTo;
        return this;
    }

    @Override
    public TemplateMailBuilder param(String key, Object value) {
        if (key == null || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter key can not be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value can not be null");
        }
        this.params.put(key.trim(), value);
        return this;
    }

    @Override
    public MailBuilder loadTemplate(String templatePath) {
        if (templatePath == null || ((String)templatePath).trim().isEmpty()) {
            throw new IllegalArgumentException("Template path can not be null or empty");
        }
        if (!((String)templatePath).endsWith(".mjml")) {
            templatePath = (String)templatePath + ".mjml";
        }
        this.body = this.renderMustacheTemplate((String)templatePath);
        return this;
    }

    private String renderMustacheTemplate(String templatePath) {
        MailoConfig config = MailoConfig.get();
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        templatePath = config.getTemplateDirectory() + (String)templatePath;
        if (ClassLoaderUtil.getResource((String)templatePath, MjmlMailBuilder.class) == null) {
            throw new TemplateNotFoundException("Template file \"" + (String)templatePath + "\" can not be found in classpath");
        }
        Mustache mustache = mf.compile((String)templatePath);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, this.params);
        return stringWriter.toString();
    }

    @Override
    public Mail build() {
        MailoConfig config = MailoConfig.get();
        if (this.subject == null || this.subject.isEmpty()) {
            throw new MailBuildException("The subject of the mail can not be null or empty");
        }
        if (this.toList.size() == 0) {
            throw new MailBuildException("The mail needs to have at least one recipient");
        }
        if (this.from == null && config.getDefaultSender() == null) {
            throw new MailBuildException("The mail needs to have a from address defined");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new MailBuildException("The mail needs to have a non empty body");
        }
        Mail mail = new Mail(this.subject);
        this.toList.forEach(xva$0 -> mail.addRecipient((MailAddress)xva$0));
        this.ccList.forEach(xva$0 -> mail.addCC((MailAddress)xva$0));
        this.bccList.forEach(xva$0 -> mail.addBCC((MailAddress)xva$0));
        mail.setFrom(this.from != null ? this.from : config.getDefaultSender());
        mail.setReplyTo(this.replyTo != null ? this.replyTo : config.getDefaultReplyTo());
        mail.setBody(this.mjmlClient.render(this.body));
        return mail;
    }
}

