/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo.factory;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import dev.ditsche.mailo.Mail;
import dev.ditsche.mailo.MailAddress;
import dev.ditsche.mailo.config.MailoConfig;
import dev.ditsche.mailo.exception.MailBuildException;
import dev.ditsche.mailo.factory.MailBuilder;
import dev.ditsche.mailo.factory.StringMailBuilder;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class PlainMailBuilder
implements StringMailBuilder {
    private String subject;
    private final Set<MailAddress> toList = new HashSet<MailAddress>();
    private final Set<MailAddress> ccList = new HashSet<MailAddress>();
    private final Set<MailAddress> bccList = new HashSet<MailAddress>();
    private MailAddress from;
    private MailAddress replyTo;
    private final HashMap<String, Object> params = new HashMap();
    private String body;

    protected PlainMailBuilder() {
    }

    @Override
    public StringMailBuilder subject(String subject) {
        if (subject == null || subject.trim().isEmpty()) {
            throw new IllegalArgumentException("Subject can not be null or empty");
        }
        this.subject = subject.trim();
        return this;
    }

    @Override
    public StringMailBuilder to(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.toList.add(recipient);
        return this;
    }

    @Override
    public StringMailBuilder cc(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.ccList.add(recipient);
        return this;
    }

    @Override
    public StringMailBuilder bcc(MailAddress recipient) {
        if (recipient == null) {
            throw new IllegalArgumentException("Recipient can not be null");
        }
        this.bccList.add(recipient);
        return this;
    }

    @Override
    public StringMailBuilder from(MailAddress from) {
        if (from == null) {
            throw new IllegalArgumentException("Sender can not be null");
        }
        this.from = from;
        return this;
    }

    @Override
    public StringMailBuilder replyTo(MailAddress replyTo) {
        if (replyTo == null) {
            throw new IllegalArgumentException("Reply To can not be null");
        }
        this.replyTo = replyTo;
        return this;
    }

    @Override
    public StringMailBuilder param(String key, Object value) {
        if (key == null || key.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameter key can not be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value can not be null");
        }
        this.params.put(key.trim(), value);
        return this;
    }

    @Override
    public MailBuilder body(String body) {
        if (body == null || body.trim().isEmpty()) {
            throw new IllegalArgumentException("Body can not be null or empty");
        }
        this.body = this.renderMustacheString(body.trim());
        return this;
    }

    private String renderMustacheString(String body) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        Mustache mustache = mf.compile((Reader)new StringReader(body), "inline");
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, this.params);
        return stringWriter.toString();
    }

    @Override
    public Mail build() {
        MailoConfig config = MailoConfig.get();
        if (this.subject == null || this.subject.isEmpty()) {
            throw new MailBuildException("The subject of the mail can not be null or empty");
        }
        if (this.toList.size() == 0) {
            throw new MailBuildException("The mail needs to have at least one recipient");
        }
        if (this.from == null && config.getDefaultSender() == null) {
            throw new MailBuildException("The mail needs to have a from address defined");
        }
        if (this.body == null || this.body.isEmpty()) {
            throw new MailBuildException("The mail needs to have a non empty body");
        }
        Mail mail = new Mail(this.subject);
        this.toList.forEach(xva$0 -> mail.addRecipient((MailAddress)xva$0));
        this.ccList.forEach(xva$0 -> mail.addCC((MailAddress)xva$0));
        this.bccList.forEach(xva$0 -> mail.addBCC((MailAddress)xva$0));
        mail.setFrom(this.from != null ? this.from : config.getDefaultSender());
        mail.setReplyTo(this.replyTo != null ? this.replyTo : config.getDefaultReplyTo());
        mail.setBody(this.body);
        return mail;
    }
}

