/*
 * Decompiled with CFR 0.152.
 */
package dev.ditsche.mailo.provider;

import dev.ditsche.mailo.Mail;
import dev.ditsche.mailo.MailAddress;
import dev.ditsche.mailo.config.SmtpConfig;
import dev.ditsche.mailo.factory.MailBuilder;
import dev.ditsche.mailo.provider.AbstractMailProvider;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class SmtpMailProvider
extends AbstractMailProvider {
    private final Session session;

    public SmtpMailProvider(final SmtpConfig smtpConfig) {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpConfig.getHost());
        props.put("mail.smtp.port", (Object)smtpConfig.getPort());
        props.put("mail.smtp.auth", (Object)(smtpConfig.getUsername() != null ? 1 : 0));
        if (smtpConfig.isSsl()) {
            props.put("mail.smtp.starttls.enable", (Object)smtpConfig.isSsl());
        } else {
            props.put("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpConfig.getUsername(), smtpConfig.getPassword());
            }
        };
        this.session = Session.getInstance((Properties)props, (Authenticator)auth);
    }

    @Override
    public boolean send(MailBuilder mailBuilder) {
        return this.send(mailBuilder.build());
    }

    @Override
    public boolean send(Mail mail) {
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.addHeader("Content-type", "text/HTML; charset=UTF-8");
            message.addHeader("format", "flowed");
            message.addHeader("Content-Transfer-Encoding", "8bit");
            message.setFrom((Address)mail.getFrom().toAddress());
            if (mail.getReplyTo() != null) {
                message.setReplyTo(List.of(mail.getReplyTo().toAddress()).toArray(new Address[1]));
            }
            for (MailAddress address : mail.getRecipients()) {
                message.addRecipient(Message.RecipientType.TO, (Address)address.toAddress());
            }
            for (MailAddress address : mail.getCC()) {
                message.addRecipient(Message.RecipientType.CC, (Address)address.toAddress());
            }
            for (MailAddress address : mail.getBCC()) {
                message.addRecipient(Message.RecipientType.BCC, (Address)address.toAddress());
            }
            message.setSubject(mail.getSubject(), "UTF-8");
            message.setContent((Object)mail.getBody(), "text/html");
            Transport.send((Message)message);
            return true;
        }
        catch (MessagingException e) {
            e.printStackTrace();
            return false;
        }
    }
}

