/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine;

import dev.dominion.ecs.api.Composition;
import dev.dominion.ecs.api.Entity;
import dev.dominion.ecs.engine.DataComposition;
import dev.dominion.ecs.engine.IntEntity;
import dev.dominion.ecs.engine.PreparedComposition;
import dev.dominion.ecs.engine.collections.ChunkedPool;
import dev.dominion.ecs.engine.system.ClassIndex;
import dev.dominion.ecs.engine.system.Config;
import dev.dominion.ecs.engine.system.IndexKey;
import dev.dominion.ecs.engine.system.Logging;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.stream.Collectors;

public final class CompositionRepository
implements AutoCloseable {
    private static final System.Logger LOGGER = Logging.getLogger();
    private final NodeCache nodeCache = new NodeCache();
    private final ClassIndex classIndex;
    private final ChunkedPool<IntEntity> pool;
    private final ChunkedPool.IdSchema idSchema;
    private final PreparedComposition preparedComposition;
    private final Map<Class<?>, Composition.ByAdding1AndRemoving<?>> addingTypeModifiers = new ConcurrentHashMap();
    private final Map<Class<?>, Composition.ByRemoving> removingTypeModifiers = new ConcurrentHashMap();
    private final Node root;
    private final Logging.Context loggingContext;

    public CompositionRepository(Logging.Context loggingContext) {
        this(Config.DominionSize.MEDIUM.classIndexBit(), Config.DominionSize.MEDIUM.chunkBit(), loggingContext);
    }

    public CompositionRepository(int classIndexBit, int chunkBit, Logging.Context loggingContext) {
        this.classIndex = new ClassIndex(classIndexBit, true, loggingContext);
        chunkBit = Math.max(8, Math.min(chunkBit, 16));
        this.idSchema = new ChunkedPool.IdSchema(chunkBit);
        this.loggingContext = loggingContext;
        if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(loggingContext.subject(), "Creating " + this.getClass().getSimpleName()));
        }
        this.pool = new ChunkedPool(this.idSchema, loggingContext);
        this.preparedComposition = new PreparedComposition(this);
        this.root = new Node(new Class[0]);
        this.root.composition = new DataComposition(this, this.pool, this.classIndex, this.idSchema, loggingContext, new Class[0]);
    }

    public ChunkedPool<IntEntity> getPool() {
        return this.pool;
    }

    public ChunkedPool.IdSchema getIdSchema() {
        return this.idSchema;
    }

    public PreparedComposition getPreparedComposition() {
        return this.preparedComposition;
    }

    public Composition.ByAdding1AndRemoving<Object> fetchAddingTypeModifier(Class<?> compType) {
        Composition.ByAdding1AndRemoving byAdding1AndRemoving = this.addingTypeModifiers.get(compType);
        return byAdding1AndRemoving == null ? this.addingTypeModifiers.computeIfAbsent(compType, k -> this.preparedComposition.byAdding1AndRemoving((Class)compType, new Class[0])) : byAdding1AndRemoving;
    }

    public Composition.ByRemoving fetchRemovingTypeModifier(Class<?> compType) {
        Composition.ByRemoving byRemoving = this.removingTypeModifiers.get(compType);
        return byRemoving == null ? this.removingTypeModifiers.computeIfAbsent(compType, k -> this.preparedComposition.byRemoving(compType)) : byRemoving;
    }

    public DataComposition getOrCreate(Object[] components) {
        int componentsLength = components == null ? 0 : components.length;
        switch (componentsLength) {
            case 0: {
                return this.root.composition;
            }
            case 1: {
                return this.getSingleTypeComposition(components[0].getClass());
            }
        }
        IndexKey indexKey = this.classIndex.getIndexKey(components);
        Node node = this.nodeCache.getNode(indexKey);
        if (node == null) {
            node = this.nodeCache.getOrCreateNode(indexKey, this.getComponentTypes(components));
        }
        return this.getNodeComposition(node);
    }

    public DataComposition getOrCreateByType(Class<?>[] componentTypes) {
        int length = componentTypes == null ? 0 : componentTypes.length;
        switch (length) {
            case 0: {
                return this.root.composition;
            }
            case 1: {
                return this.getSingleTypeComposition(componentTypes[0]);
            }
        }
        IndexKey indexKey = this.classIndex.getIndexKeyByType(componentTypes);
        Node node = this.nodeCache.getNode(indexKey);
        if (node == null) {
            node = this.nodeCache.getOrCreateNode(indexKey, componentTypes);
        }
        return this.getNodeComposition(node);
    }

    private DataComposition getSingleTypeComposition(Class<?> componentType) {
        IndexKey key = new IndexKey(this.classIndex.getIndex(componentType));
        Node node = this.nodeCache.getNode(key);
        if (node == null) {
            key = new IndexKey(this.classIndex.getIndexOrAddClass(componentType));
            node = this.nodeCache.getNode(key);
            if (node == null) {
                node = this.nodeCache.getOrCreateNode(key, componentType);
            }
        } else {
            node.linkNode(new IndexKey(this.classIndex.getIndex(componentType)), node);
        }
        return this.getNodeComposition(node);
    }

    private Class<?>[] getComponentTypes(Object[] components) {
        Class[] componentTypes = new Class[components.length];
        for (int i = 0; i < components.length; ++i) {
            componentTypes[i] = components[i].getClass();
        }
        return componentTypes;
    }

    private DataComposition getNodeComposition(Node link) {
        DataComposition composition = link.getComposition();
        if (composition != null) {
            return composition;
        }
        return link.getOrCreateComposition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modifyComponents(IntEntity entity, PreparedComposition.TargetComposition targetComposition, Object addedComponent, Object[] addedComponents) {
        ChunkedPool.Tenant<IntEntity> prevTenant;
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.loggingContext.subject(), "Modifying " + entity + " from " + entity.getComposition() + " to " + targetComposition.target()));
        }
        ChunkedPool.Tenant<IntEntity> tenant = prevTenant = entity.getChunk().getTenant();
        synchronized (prevTenant) {
            ChunkedPool.Tenant<IntEntity> prevStateTenant;
            int prevId = entity.getId();
            ChunkedPool.Tenant<IntEntity> tenant2 = targetComposition.target().getTenant();
            synchronized (tenant2) {
                targetComposition.target().attachEntity(entity, targetComposition.indexMapping(), targetComposition.addedIndexMapping(), addedComponent, addedComponents);
            }
            prevTenant.freeId(prevId);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (entity.stateChunk == null) return;
            ChunkedPool.Tenant<IntEntity> tenant3 = prevStateTenant = entity.stateChunk.getTenant();
            synchronized (prevStateTenant) {
                prevStateTenant.freeStateId(entity.getStateId());
                entity.stateChunk = targetComposition.target().fetchStateTenants((IndexKey)prevStateTenant.getSubject()).registerState(entity);
                // ** MonitorExit[var7_8] (shouldn't be in output)
                return;
            }
        }
    }

    public Entity addComponent(IntEntity entity, Object component) {
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.loggingContext.subject(), "Adding [" + component.getClass().getSimpleName() + "] to " + entity));
        }
        Composition.ByAdding1AndRemoving<Object> modifier = this.fetchAddingTypeModifier(component.getClass());
        PreparedComposition.NewEntityComposition mod = (PreparedComposition.NewEntityComposition)modifier.withValue((Entity)entity, component);
        this.modifyComponents(mod.entity(), mod.targetComposition(), mod.addedComponent(), mod.addedComponents());
        return entity;
    }

    public boolean removeComponentType(IntEntity entity, Class<?> componentType) {
        Composition.ByRemoving modifier;
        PreparedComposition.NewEntityComposition mod;
        if (componentType == null) {
            return false;
        }
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.loggingContext.subject(), "Removing [" + componentType.getSimpleName() + "] from " + entity));
        }
        if ((mod = (PreparedComposition.NewEntityComposition)(modifier = this.fetchRemovingTypeModifier(componentType)).withValue((Entity)entity)) == null) {
            return false;
        }
        this.modifyComponents(mod.entity(), mod.targetComposition(), mod.addedComponent(), mod.addedComponents());
        return true;
    }

    public Map<IndexKey, Node> findWith(Class<?> ... componentTypes) {
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.loggingContext.subject(), "Find entities with " + Arrays.toString(componentTypes)));
        }
        switch (componentTypes.length) {
            case 0: {
                return null;
            }
            case 1: {
                Node node = this.nodeCache.getNode(new IndexKey(this.classIndex.getIndex(componentTypes[0])));
                return node == null ? null : node.copyOfLinkedNodes();
            }
        }
        Map<IndexKey, Node> currentCompositions = null;
        for (int i = 0; i < componentTypes.length; ++i) {
            Node node = this.nodeCache.getNode(new IndexKey(this.classIndex.getIndex(componentTypes[i])));
            if (node == null) {
                return null;
            }
            currentCompositions = currentCompositions == null ? node.copyOfLinkedNodes() : this.intersect(currentCompositions, node.linkedNodes);
        }
        return currentCompositions;
    }

    public void mapWithout(Map<IndexKey, Node> nodeMap, Class<?> ... componentTypes) {
        if (nodeMap == null) {
            return;
        }
        for (Class<?> componentType : componentTypes) {
            IndexKey indexKey = new IndexKey(this.classIndex.getIndex(componentType));
            nodeMap.remove(indexKey);
            Node node = this.nodeCache.getNode(indexKey);
            if (node == null) continue;
            for (IndexKey linkedNodeKey : node.linkedNodes.keySet()) {
                nodeMap.remove(linkedNodeKey);
            }
        }
    }

    public void mapWithAlso(Map<IndexKey, Node> nodeMap, Class<?> ... componentTypes) {
        if (nodeMap == null) {
            return;
        }
        for (Class<?> componentType : componentTypes) {
            Node node = this.nodeCache.getNode(new IndexKey(this.classIndex.getIndex(componentType)));
            if (node == null) {
                nodeMap.clear();
                return;
            }
            this.intersect(nodeMap, node.linkedNodes);
        }
    }

    private Map<IndexKey, Node> intersect(Map<IndexKey, Node> subject, Map<IndexKey, Node> other) {
        Set<IndexKey> indexKeySet = subject.keySet();
        Iterator<IndexKey> iterator = indexKeySet.iterator();
        while (iterator.hasNext()) {
            if (other.containsKey(iterator.next())) continue;
            iterator.remove();
        }
        return subject;
    }

    public ClassIndex getClassIndex() {
        return this.classIndex;
    }

    public Node getRoot() {
        return this.root;
    }

    public NodeCache getNodeCache() {
        return this.nodeCache;
    }

    public Logging.Context getLoggingContext() {
        return this.loggingContext;
    }

    @Override
    public void close() {
        this.nodeCache.clear();
        this.classIndex.close();
        this.pool.close();
    }

    public final class NodeCache {
        private final Map<IndexKey, Node> data = new ConcurrentHashMap<IndexKey, Node>();

        public Node getOrCreateNode(IndexKey key, Class<?> ... componentTypes) {
            Node node = this.data.computeIfAbsent(key, k -> new Node(componentTypes));
            if (componentTypes.length > 1) {
                for (int i = 0; i < componentTypes.length; ++i) {
                    Class<?> componentType = componentTypes[i];
                    IndexKey typeKey = new IndexKey(CompositionRepository.this.classIndex.getIndex(componentType));
                    Node singleTypeNode = this.data.computeIfAbsent(typeKey, k -> new Node(componentType));
                    singleTypeNode.linkNode(key, node);
                }
            } else {
                node.linkNode(key, node);
            }
            return node;
        }

        public Node getNode(IndexKey key) {
            return this.data.get(key);
        }

        public boolean contains(IndexKey key) {
            return this.data.containsKey(key);
        }

        public void clear() {
            this.data.clear();
        }
    }

    public final class Node {
        private final StampedLock lock = new StampedLock();
        private final Map<IndexKey, Node> linkedNodes = new ConcurrentHashMap<IndexKey, Node>();
        private final Class<?>[] componentTypes;
        private DataComposition composition;

        public Node(Class<?> ... componentTypes) {
            this.componentTypes = componentTypes;
            if (Logging.isLoggable(CompositionRepository.this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, Logging.format(CompositionRepository.this.loggingContext.subject(), "Creating " + this));
            }
        }

        public void linkNode(IndexKey key, Node node) {
            this.linkedNodes.putIfAbsent(key, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DataComposition getOrCreateComposition() {
            long stamp = this.lock.tryOptimisticRead();
            try {
                DataComposition value;
                while (true) {
                    if (stamp != 0L) {
                        value = this.composition;
                        if (this.lock.validate(stamp)) {
                            if (value != null) break;
                            if ((stamp = this.lock.tryConvertToWriteLock(stamp)) != 0L) {
                                value = this.composition = new DataComposition(CompositionRepository.this, CompositionRepository.this.pool, CompositionRepository.this.classIndex, CompositionRepository.this.idSchema, CompositionRepository.this.loggingContext, this.componentTypes);
                                break;
                            }
                        }
                    }
                    stamp = this.lock.writeLock();
                }
                DataComposition dataComposition = value;
                return dataComposition;
            }
            finally {
                if (StampedLock.isWriteLockStamp(stamp)) {
                    this.lock.unlockWrite(stamp);
                }
            }
        }

        public DataComposition getComposition() {
            return this.composition;
        }

        public Map<IndexKey, Node> getLinkedNodes() {
            return Collections.unmodifiableMap(this.linkedNodes);
        }

        public Map<IndexKey, Node> copyOfLinkedNodes() {
            return new ConcurrentHashMap<IndexKey, Node>(this.linkedNodes);
        }

        public String toString() {
            return "Node={types=[" + (this.componentTypes == null ? "" : Arrays.stream(this.componentTypes).map(Class::getSimpleName).sorted().collect(Collectors.joining(","))) + "]}";
        }
    }
}

