/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine;

import dev.dominion.ecs.api.Composition;
import dev.dominion.ecs.api.Dominion;
import dev.dominion.ecs.api.Entity;
import dev.dominion.ecs.api.Results;
import dev.dominion.ecs.api.Scheduler;
import dev.dominion.ecs.engine.CompositionRepository;
import dev.dominion.ecs.engine.DataComposition;
import dev.dominion.ecs.engine.IntEntity;
import dev.dominion.ecs.engine.PreparedComposition;
import dev.dominion.ecs.engine.ResultSet;
import dev.dominion.ecs.engine.SystemScheduler;
import dev.dominion.ecs.engine.system.Config;
import dev.dominion.ecs.engine.system.IndexKey;
import dev.dominion.ecs.engine.system.Logging;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

public final class EntityRepository
implements Dominion {
    private static final System.Logger LOGGER = Logging.getLogger();
    private final String name;
    private final Logging.Context loggingContext;
    private final CompositionRepository compositions;
    private final int systemTimeoutSeconds;
    private final AtomicBoolean closed = new AtomicBoolean();

    public EntityRepository(String name, int classIndexBit, int chunkBit, int systemTimeoutSeconds, Logging.Context loggingContext) {
        this.name = name;
        this.systemTimeoutSeconds = systemTimeoutSeconds;
        this.loggingContext = loggingContext;
        this.compositions = new CompositionRepository(classIndexBit, chunkBit, loggingContext);
    }

    public String getName() {
        return this.name;
    }

    public Entity createEntity(Object ... components) {
        this.checkState();
        Object[] componentArray = components.length == 0 ? null : components;
        DataComposition composition = this.compositions.getOrCreate(componentArray);
        IntEntity entity = composition.createEntity(false, componentArray);
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.loggingContext.subject(), "Creating " + entity + " with " + composition));
        }
        return entity;
    }

    public Entity createPreparedEntity(Composition.OfTypes withValues) {
        this.checkState();
        DataComposition composition = (DataComposition)withValues.getContext();
        return composition.createEntity(true, withValues.getComponents());
    }

    public Entity createEntityAs(Entity prefab, Object ... components) {
        int originArrayLength;
        this.checkState();
        IntEntity origin = (IntEntity)prefab;
        if (origin.getComponentArray() == null || (originArrayLength = origin.getArrayLength()) == 0) {
            return this.createEntity(components);
        }
        Object[] targetComponents = Arrays.copyOf(components, originArrayLength + components.length);
        System.arraycopy(origin.getComponentArray(), 0, targetComponents, components.length, originArrayLength);
        return this.createEntity(targetComponents);
    }

    public boolean deleteEntity(Entity entity) {
        this.checkState();
        return ((IntEntity)entity).delete();
    }

    public boolean modifyEntity(Composition.Modifier modifier) {
        this.checkState();
        PreparedComposition.NewEntityComposition mod = (PreparedComposition.NewEntityComposition)modifier;
        if (mod == null) {
            return false;
        }
        return mod.entity().modify(this.compositions, mod.targetComposition(), mod.addedComponent(), mod.addedComponents());
    }

    public Composition composition() {
        return this.compositions.getPreparedComposition();
    }

    public Scheduler createScheduler() {
        this.checkState();
        return new SystemScheduler(this.systemTimeoutSeconds, this.loggingContext);
    }

    public <T> Results<T> findCompositionsWith(Class<T> type) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type);
        return new ResultSet.With<T>(this.compositions, nodes, type);
    }

    public <T1, T2> Results<Results.With2<T1, T2>> findCompositionsWith(Class<T1> type1, Class<T2> type2) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2);
        return new ResultSet.With2<T1, T2>(this.compositions, nodes, false, type1, type2);
    }

    public <T1, T2, T3> Results<Results.With3<T1, T2, T3>> findCompositionsWith(Class<T1> type1, Class<T2> type2, Class<T3> type3) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3);
        return new ResultSet.With3<T1, T2, T3>(this.compositions, nodes, false, type1, type2, type3);
    }

    public <T1, T2, T3, T4> Results<Results.With4<T1, T2, T3, T4>> findCompositionsWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4);
        return new ResultSet.With4<T1, T2, T3, T4>(this.compositions, nodes, false, type1, type2, type3, type4);
    }

    public <T1, T2, T3, T4, T5> Results<Results.With5<T1, T2, T3, T4, T5>> findCompositionsWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4, type5);
        return new ResultSet.With5<T1, T2, T3, T4, T5>(this.compositions, nodes, false, type1, type2, type3, type4, type5);
    }

    public <T1, T2, T3, T4, T5, T6> Results<Results.With6<T1, T2, T3, T4, T5, T6>> findCompositionsWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4, type5, type6);
        return new ResultSet.With6<T1, T2, T3, T4, T5, T6>(this.compositions, nodes, false, type1, type2, type3, type4, type5, type6);
    }

    public <T extends Entity> Results<T> findAllEntities() {
        this.checkState();
        return new ResultSet.All(this.compositions);
    }

    public <T> Results<Results.With1<T>> findEntitiesWith(Class<T> type) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type);
        return new ResultSet.With1<T>(this.compositions, nodes, type);
    }

    public <T1, T2> Results<Results.With2<T1, T2>> findEntitiesWith(Class<T1> type1, Class<T2> type2) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2);
        return new ResultSet.With2<T1, T2>(this.compositions, nodes, true, type1, type2);
    }

    public <T1, T2, T3> Results<Results.With3<T1, T2, T3>> findEntitiesWith(Class<T1> type1, Class<T2> type2, Class<T3> type3) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3);
        return new ResultSet.With3<T1, T2, T3>(this.compositions, nodes, true, type1, type2, type3);
    }

    public <T1, T2, T3, T4> Results<Results.With4<T1, T2, T3, T4>> findEntitiesWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4);
        return new ResultSet.With4<T1, T2, T3, T4>(this.compositions, nodes, true, type1, type2, type3, type4);
    }

    public <T1, T2, T3, T4, T5> Results<Results.With5<T1, T2, T3, T4, T5>> findEntitiesWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4, type5);
        return new ResultSet.With5<T1, T2, T3, T4, T5>(this.compositions, nodes, true, type1, type2, type3, type4, type5);
    }

    public <T1, T2, T3, T4, T5, T6> Results<Results.With6<T1, T2, T3, T4, T5, T6>> findEntitiesWith(Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
        this.checkState();
        Map<IndexKey, CompositionRepository.Node> nodes = this.compositions.findWith(type1, type2, type3, type4, type5, type6);
        return new ResultSet.With6<T1, T2, T3, T4, T5, T6>(this.compositions, nodes, true, type1, type2, type3, type4, type5, type6);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.compositions.close();
    }

    private void checkState() {
        if (this.isClosed()) {
            throw new IllegalStateException(this + " has already been closed.");
        }
    }

    public String toString() {
        return "Dominion '" + this.name + "'";
    }

    public static class Factory
    implements Dominion.Factory {
        public static final int NAME_MAX_LENGTH = 48;
        private static final AtomicInteger counter = new AtomicInteger(1);

        private static String normalizeName(String name) {
            name = name == null || ((String)name).isEmpty() ? "dominion-" + counter.getAndIncrement() : name;
            name = ((String)name).trim().toLowerCase(Locale.ROOT).replaceAll("[^a-zA-Z\\d-_.]", "");
            return ((String)name).substring(0, Math.min(48, ((String)name).length()));
        }

        public Dominion create() {
            return this.create(null);
        }

        public Dominion create(String name) {
            name = Factory.normalizeName(name);
            Optional<System.Logger.Level> fetchLoggingLevel = Config.fetchLoggingLevel(name);
            System.Logger.Level level = fetchLoggingLevel.orElse(Logging.DEFAULT_LOGGING_LEVEL);
            Optional<Config.DominionSize> fetchSize = Config.fetchSize(name);
            Config.DominionSize size = fetchSize.orElse(Config.DominionSize.MEDIUM);
            Optional<Integer> fetchClassIndexBit = Config.fetchIntValue(name, "class-index-bit");
            int classIndexBit = fetchClassIndexBit.orElse(fetchSize.orElse(Config.DominionSize.MEDIUM).classIndexBit());
            Optional<Integer> fetchChunkBit = Config.fetchIntValue(name, "chunk-bit");
            int chunkBit = fetchChunkBit.orElse(fetchSize.orElse(Config.DominionSize.MEDIUM).chunkBit());
            Optional<Integer> fetchSystemTimeoutSeconds = Config.fetchIntValue(name, "system-timeout-seconds");
            int systemTimeoutSeconds = fetchSystemTimeoutSeconds.orElse(3);
            if (Config.showBanner()) {
                Logging.printPanel("Dominion '" + name + "'", "  Logging-Level: '" + level + (String)(fetchLoggingLevel.isEmpty() ? "' (set sys-property '" + Config.getPropertyName(name, "logging-level") + "')" : "'"), "  Dominion-Size: '" + size + (String)(fetchSize.isEmpty() ? "' (set sys-property '" + Config.getPropertyName(name, "size") + "')" : "'"), "  ClassIndex-Bit: " + classIndexBit + (String)(fetchClassIndexBit.isEmpty() && fetchSize.isEmpty() ? " (set sys-property '" + Config.getPropertyName(name, "class-index-bit") + "')" : ""), "  Chunk-Bit: " + chunkBit + (String)(fetchChunkBit.isEmpty() && fetchSize.isEmpty() ? " (set sys-property '" + Config.getPropertyName(name, "chunk-bit") + "')" : ""), "  SystemTimeout-Seconds: " + systemTimeoutSeconds + (String)(fetchSystemTimeoutSeconds.isEmpty() ? " (set sys-property '" + Config.getPropertyName(name, "system-timeout-seconds") + "')" : ""));
                if (fetchSize.isEmpty()) {
                    Logging.printPanel((String[])Stream.concat(Stream.of("Dominion 'Size' options:"), Arrays.stream(Config.DominionSize.values()).map(Config.DominionSize::toString)).toArray(String[]::new));
                }
            }
            int loggingLevelIndex = Logging.registerLoggingLevel(level);
            return new EntityRepository(name, classIndexBit, chunkBit, systemTimeoutSeconds, new Logging.Context(name, loggingLevelIndex));
        }
    }
}

