/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine;

import dev.dominion.ecs.api.Entity;
import dev.dominion.ecs.engine.CompositionRepository;
import dev.dominion.ecs.engine.DataComposition;
import dev.dominion.ecs.engine.PreparedComposition;
import dev.dominion.ecs.engine.collections.ChunkedPool;
import java.util.Arrays;

public final class IntEntity
implements Entity,
ChunkedPool.Item {
    ChunkedPool.LinkedChunk<IntEntity> chunk;
    ChunkedPool.LinkedChunk<IntEntity> stateChunk;
    private int id;
    private int stateId;
    private Object[] shelf;

    public IntEntity(int id) {
        this.id = id;
        this.stateId = Integer.MIN_VALUE;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    public int getStateId() {
        return this.stateId;
    }

    @Override
    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    public DataComposition getComposition() {
        return (DataComposition)this.chunk.getTenant().getOwner();
    }

    public ChunkedPool.LinkedChunk<IntEntity> getChunk() {
        return this.chunk;
    }

    @Override
    public void setChunk(ChunkedPool.LinkedChunk<? extends ChunkedPool.Item> chunk) {
        this.chunk = chunk;
    }

    public ChunkedPool.LinkedChunk<IntEntity> getStateChunk() {
        return this.stateChunk;
    }

    @Override
    public void setStateChunk(ChunkedPool.LinkedChunk<? extends ChunkedPool.Item> chunk) {
        this.stateChunk = chunk;
    }

    public Object[] getComponentArray() {
        if (this.chunk == null || this.getArrayLength() == 0) {
            return null;
        }
        return this.chunk.getData(this.id);
    }

    public int getArrayLength() {
        return this.chunk.getDataLength();
    }

    public String getName() {
        return null;
    }

    public synchronized Entity add(Object component) {
        if (!this.isEnabled()) {
            return this;
        }
        return this.getComposition().getRepository().addComponent(this, component);
    }

    public synchronized boolean remove(Object component) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.getComposition().getRepository().removeComponentType(this, component.getClass());
    }

    public synchronized boolean modify(CompositionRepository compositions, PreparedComposition.TargetComposition targetComposition, Object addedComponent, Object[] addedComponents) {
        if (!this.isEnabled()) {
            return false;
        }
        compositions.modifyComponents(this, targetComposition, addedComponent, addedComponents);
        return true;
    }

    public synchronized boolean removeType(Class<?> componentType) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.getComposition().getRepository().removeComponentType(this, componentType);
    }

    public boolean has(Class<?> componentType) {
        int dataLength;
        if (this.chunk == null || (dataLength = this.chunk.getDataLength()) == 0) {
            return false;
        }
        if (dataLength == 1) {
            return this.chunk.getFromDataArray(this.id).getClass().equals(componentType);
        }
        DataComposition composition = (DataComposition)this.chunk.getTenant().getOwner();
        return composition.fetchComponentIndex(componentType) > -1;
    }

    public boolean contains(Object component) {
        int dataLength;
        if (this.chunk == null || (dataLength = this.chunk.getDataLength()) == 0) {
            return false;
        }
        if (dataLength == 1) {
            return this.chunk.getFromDataArray(this.id).equals(component);
        }
        DataComposition composition = (DataComposition)this.chunk.getTenant().getOwner();
        int idx = composition.fetchComponentIndex(component.getClass());
        return idx > -1 && this.chunk.getData(this.getId())[idx].equals(component);
    }

    public <T> T get(Class<T> componentType) {
        int dataLength;
        if (this.chunk == null || (dataLength = this.chunk.getDataLength()) == 0) {
            return null;
        }
        if (dataLength == 1) {
            Object fromDataArray = this.chunk.getFromDataArray(this.id);
            return (T)(fromDataArray.getClass().equals(componentType) ? fromDataArray : null);
        }
        DataComposition composition = (DataComposition)this.chunk.getTenant().getOwner();
        int componentIndex = composition.fetchComponentIndex(componentType);
        return (T)(componentIndex > -1 ? this.chunk.getFromMultiDataArray(this.id, componentIndex) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <S extends Enum<S>> Entity setState(S state) {
        ChunkedPool.Tenant<IntEntity> tenant;
        ChunkedPool.Tenant<IntEntity> tenant2;
        if (!this.isEnabled()) {
            return this;
        }
        if (state == null && this.stateChunk != null) {
            ChunkedPool.Tenant<IntEntity> tenant3;
            ChunkedPool.Tenant<IntEntity> tenant4 = tenant3 = this.stateChunk.getTenant();
            synchronized (tenant3) {
                tenant3.freeStateId(this.stateId);
                this.stateChunk = null;
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return this;
            }
        }
        DataComposition composition = this.getComposition();
        if (this.stateChunk != null) {
            tenant2 = this.stateChunk.getTenant();
            if (tenant2 == composition.getStateTenant(state)) {
                return this;
            }
            tenant = this.stateChunk.getTenant();
            synchronized (tenant) {
                tenant2.freeStateId(this.stateId);
            }
        }
        tenant2 = composition.fetchStateTenants(state);
        tenant = tenant2;
        synchronized (tenant2) {
            this.stateChunk = tenant2.registerState(this);
            // ** MonitorExit[var4_7] (shouldn't be in output)
            return this;
        }
    }

    public boolean isEnabled() {
        return !this.isDeleted() && this.shelf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entity setEnabled(boolean enabled) {
        if (enabled && !this.isEnabled()) {
            ChunkedPool.Tenant<IntEntity> tenant = this.chunk.getTenant();
            synchronized (tenant) {
                this.chunk.unshelve(this, this.shelf);
                this.shelf = null;
            }
        }
        if (!enabled && this.isEnabled()) {
            ChunkedPool.Tenant<IntEntity> tenant = this.chunk.getTenant();
            synchronized (tenant) {
                this.shelf = this.chunk.shelve(this);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized boolean delete() {
        ChunkedPool.Tenant<IntEntity> tenant;
        ChunkedPool.Tenant<IntEntity> tenant2 = tenant = this.chunk.getTenant();
        synchronized (tenant) {
            tenant.freeId(this.id);
            this.flagDetachedId();
            this.chunk = null;
            this.shelf = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.stateChunk == null) return true;
            tenant2 = tenant = this.stateChunk.getTenant();
            synchronized (tenant) {
                tenant.freeStateId(this.stateId);
                this.stateChunk = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }
    }

    public boolean isDeleted() {
        return (this.id & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    void flagDetachedId() {
        this.setId(this.id | Integer.MIN_VALUE);
    }

    public String toString() {
        ChunkedPool.IdSchema idSchema = this.getComposition().getIdSchema();
        return "Entity={id=" + idSchema.idToString(this.id) + "-> " + Arrays.toString(this.getComponentArray()) + ", stateId=" + idSchema.idToString(this.stateId) + ", enabled=" + this.isEnabled() + "}";
    }
}

