/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine;

import dev.dominion.ecs.api.Entity;
import dev.dominion.ecs.api.Results;
import dev.dominion.ecs.engine.CompositionRepository;
import dev.dominion.ecs.engine.DataComposition;
import dev.dominion.ecs.engine.IntEntity;
import dev.dominion.ecs.engine.collections.ChunkedPool;
import dev.dominion.ecs.engine.system.IndexKey;
import dev.dominion.ecs.engine.system.Logging;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ResultSet<T>
implements Results<T> {
    private static final System.Logger LOGGER = Logging.getLogger();
    protected final boolean withEntity;
    protected final CompositionRepository compositionRepository;
    private final Map<IndexKey, CompositionRepository.Node> nodeMap;
    protected IndexKey stateKey;

    public ResultSet(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity) {
        this.compositionRepository = compositionRepository;
        this.nodeMap = nodeMap;
        this.withEntity = withEntity;
        if (Logging.isLoggable(compositionRepository.getLoggingContext().levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(compositionRepository.getLoggingContext().subject(), "Creating " + this));
        }
    }

    public String toString() {
        return "ResultSet{nodes=" + (this.nodeMap == null ? null : this.nodeMap.values()) + ", withEntity=" + this.withEntity + ", stateKey=" + this.stateKey + "}";
    }

    abstract Iterator<T> compositionIterator(DataComposition var1);

    public Iterator<T> iterator() {
        return this.nodeMap != null && this.nodeMap.size() > 0 ? (this.nodeMap.size() > 1 ? new IteratorWrapper(this, this.nodeMap.values().iterator()) : this.compositionIterator(this.nodeMap.values().iterator().next().getComposition())) : new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                return null;
            }
        };
    }

    public <S extends Enum<S>> Results<T> withState(S state) {
        this.stateKey = this.compositionRepository.getClassIndex().getIndexKeyByEnum(state);
        if (Logging.isLoggable(this.compositionRepository.getLoggingContext().levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(this.compositionRepository.getLoggingContext().subject(), "Setting state " + state + " to " + this));
        }
        return this;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), true);
    }

    public Results<T> without(Class<?> ... componentTypes) {
        this.compositionRepository.mapWithout(this.nodeMap, componentTypes);
        return this;
    }

    public Results<T> withAlso(Class<?> ... componentTypes) {
        this.compositionRepository.mapWithAlso(this.nodeMap, componentTypes);
        return this;
    }

    protected ChunkedPool.PoolDataIterator<IntEntity> getPoolDataIterator(DataComposition composition, boolean multiData) {
        ChunkedPool.PoolDataIterator<IntEntity> iterator;
        boolean withState;
        boolean bl = withState = this.stateKey != null;
        if (withState) {
            ChunkedPool.Tenant<IntEntity> tenant = composition.getStateTenant(this.stateKey);
            iterator = tenant == null ? new ChunkedPool.PoolDataEmptyIterator<IntEntity>() : (this.withEntity ? tenant.iteratorWithState(multiData) : tenant.noItemIteratorWithState(multiData));
        } else {
            ChunkedPool.Tenant<IntEntity> tenant = composition.getTenant();
            iterator = this.withEntity ? tenant.iterator() : tenant.noItemIterator();
        }
        return iterator;
    }

    private static final class IteratorWrapper<T>
    implements Iterator<T> {
        private final ResultSet<T> owner;
        private final Iterator<CompositionRepository.Node> nodesIterator;
        private Iterator<T> wrapped;

        public IteratorWrapper(ResultSet<T> owner, Iterator<CompositionRepository.Node> nodesIterator) {
            this.owner = owner;
            this.nodesIterator = nodesIterator;
            this.wrapped = this.nodesIterator.hasNext() ? owner.compositionIterator(this.nodesIterator.next().getComposition()) : new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    return null;
                }
            };
        }

        @Override
        public boolean hasNext() {
            if (this.wrapped.hasNext()) {
                return true;
            }
            while (this.nodesIterator.hasNext()) {
                this.wrapped = this.owner.compositionIterator(this.nodesIterator.next().getComposition());
                if (!this.wrapped.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.wrapped.next();
        }
    }

    public static final class NextWith6<T1, T2, T3, T4, T5, T6>
    implements ChunkedPool.PoolIteratorNextWith6 {
        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int i2, int i3, int i4, int i5, int i6, int next, ChunkedPool.Item item) {
            return new Results.With6(multiDataArray[i1][next], multiDataArray[i2][next], multiDataArray[i3][next], multiDataArray[i4][next], multiDataArray[i5][next], multiDataArray[i6][next], (Entity)item);
        }
    }

    public static final class NextWith5<T1, T2, T3, T4, T5>
    implements ChunkedPool.PoolIteratorNextWith5 {
        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int i2, int i3, int i4, int i5, int next, ChunkedPool.Item item) {
            return new Results.With5(multiDataArray[i1][next], multiDataArray[i2][next], multiDataArray[i3][next], multiDataArray[i4][next], multiDataArray[i5][next], (Entity)item);
        }
    }

    public static final class NextWith4<T1, T2, T3, T4>
    implements ChunkedPool.PoolIteratorNextWith4 {
        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int i2, int i3, int i4, int next, ChunkedPool.Item item) {
            return new Results.With4(multiDataArray[i1][next], multiDataArray[i2][next], multiDataArray[i3][next], multiDataArray[i4][next], (Entity)item);
        }
    }

    public static final class NextWith3<T1, T2, T3>
    implements ChunkedPool.PoolIteratorNextWith3 {
        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int i2, int i3, int next, ChunkedPool.Item item) {
            return new Results.With3(multiDataArray[i1][next], multiDataArray[i2][next], multiDataArray[i3][next], (Entity)item);
        }
    }

    public static final class NextWith2<T1, T2>
    implements ChunkedPool.PoolIteratorNextWith2 {
        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int i2, int next, ChunkedPool.Item item) {
            return new Results.With2(multiDataArray[i1][next], multiDataArray[i2][next], (Entity)item);
        }
    }

    public static final class NextWith1<T1>
    implements ChunkedPool.PoolIteratorNextWith1 {
        @Override
        public Object fetchNext(Object[] dataArray, int next, ChunkedPool.Item item) {
            return new Results.With1(dataArray[next], (Entity)item);
        }

        @Override
        public Object fetchNext(Object[][] multiDataArray, int i1, int next, ChunkedPool.Item item) {
            return new Results.With1(multiDataArray[i1][next], (Entity)item);
        }
    }

    public static final class With6<T1, T2, T3, T4, T5, T6>
    extends ResultSet<Results.With6<T1, T2, T3, T4, T5, T6>> {
        private final Class<T1> type1;
        private final Class<T2> type2;
        private final Class<T3> type3;
        private final Class<T4> type4;
        private final Class<T5> type5;
        private final Class<T6> type6;
        private final NextWith6<T1, T2, T3, T4, T5, T6> nextWith6 = new NextWith6();

        public With6(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5, Class<T6> type6) {
            super(compositionRepository, nodeMap, withEntity);
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
            this.type4 = type4;
            this.type5 = type5;
            this.type6 = type6;
        }

        @Override
        Iterator<Results.With6<T1, T2, T3, T4, T5, T6>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, true);
            NextWith6<T1, T2, T3, T4, T5, T6> fetcher = iterator instanceof ChunkedPool.PoolMultiDataIteratorWithState ? this.nextWith6 : null;
            return composition.select(this.type1, this.type2, this.type3, this.type4, this.type5, this.type6, iterator, fetcher);
        }
    }

    public static final class With5<T1, T2, T3, T4, T5>
    extends ResultSet<Results.With5<T1, T2, T3, T4, T5>> {
        private final Class<T1> type1;
        private final Class<T2> type2;
        private final Class<T3> type3;
        private final Class<T4> type4;
        private final Class<T5> type5;
        private final NextWith5<T1, T2, T3, T4, T5> nextWith5 = new NextWith5();

        public With5(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4, Class<T5> type5) {
            super(compositionRepository, nodeMap, withEntity);
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
            this.type4 = type4;
            this.type5 = type5;
        }

        @Override
        Iterator<Results.With5<T1, T2, T3, T4, T5>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, true);
            NextWith5<T1, T2, T3, T4, T5> fetcher = iterator instanceof ChunkedPool.PoolMultiDataIteratorWithState ? this.nextWith5 : null;
            return composition.select(this.type1, this.type2, this.type3, this.type4, this.type5, iterator, fetcher);
        }
    }

    public static final class With4<T1, T2, T3, T4>
    extends ResultSet<Results.With4<T1, T2, T3, T4>> {
        private final Class<T1> type1;
        private final Class<T2> type2;
        private final Class<T3> type3;
        private final Class<T4> type4;
        private final NextWith4<T1, T2, T3, T4> nextWith4 = new NextWith4();

        public With4(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity, Class<T1> type1, Class<T2> type2, Class<T3> type3, Class<T4> type4) {
            super(compositionRepository, nodeMap, withEntity);
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
            this.type4 = type4;
        }

        @Override
        Iterator<Results.With4<T1, T2, T3, T4>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, true);
            NextWith4<T1, T2, T3, T4> fetcher = iterator instanceof ChunkedPool.PoolMultiDataIteratorWithState ? this.nextWith4 : null;
            return composition.select(this.type1, this.type2, this.type3, this.type4, iterator, fetcher);
        }
    }

    public static final class With3<T1, T2, T3>
    extends ResultSet<Results.With3<T1, T2, T3>> {
        private final Class<T1> type1;
        private final Class<T2> type2;
        private final Class<T3> type3;
        private final NextWith3<T1, T2, T3> nextWith3 = new NextWith3();

        public With3(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity, Class<T1> type1, Class<T2> type2, Class<T3> type3) {
            super(compositionRepository, nodeMap, withEntity);
            this.type1 = type1;
            this.type2 = type2;
            this.type3 = type3;
        }

        @Override
        Iterator<Results.With3<T1, T2, T3>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, true);
            NextWith3<T1, T2, T3> fetcher = iterator instanceof ChunkedPool.PoolMultiDataIteratorWithState ? this.nextWith3 : null;
            return composition.select(this.type1, this.type2, this.type3, iterator, fetcher);
        }
    }

    public static final class With2<T1, T2>
    extends ResultSet<Results.With2<T1, T2>> {
        private final Class<T1> type1;
        private final Class<T2> type2;
        private final NextWith2<T1, T2> nextWith2 = new NextWith2();

        public With2(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, boolean withEntity, Class<T1> type1, Class<T2> type2) {
            super(compositionRepository, nodeMap, withEntity);
            this.type1 = type1;
            this.type2 = type2;
        }

        @Override
        Iterator<Results.With2<T1, T2>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, true);
            NextWith2<T1, T2> fetcher = iterator instanceof ChunkedPool.PoolMultiDataIteratorWithState ? this.nextWith2 : null;
            return composition.select(this.type1, this.type2, iterator, fetcher);
        }
    }

    public static final class With1<T>
    extends ResultSet<Results.With1<T>> {
        private final Class<T> type;
        private final NextWith1<T> nextWith1 = new NextWith1();

        public With1(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, Class<T> type) {
            super(compositionRepository, nodeMap, true);
            this.type = type;
        }

        @Override
        Iterator<Results.With1<T>> compositionIterator(DataComposition composition) {
            ChunkedPool.PoolDataIterator<IntEntity> iterator = this.getPoolDataIterator(composition, composition.length() > 1);
            NextWith1<T> fetcher = iterator instanceof ChunkedPool.PoolDataIteratorWithState ? this.nextWith1 : null;
            return composition.select(this.type, iterator, fetcher);
        }
    }

    public static final class All
    extends ResultSet<IntEntity> {
        public All(CompositionRepository compositionRepository) {
            super(compositionRepository, null, false);
        }

        @Override
        Iterator<IntEntity> compositionIterator(DataComposition composition) {
            return null;
        }

        @Override
        public Iterator<IntEntity> iterator() {
            return this.compositionRepository.getPool().allEntities();
        }

        @Override
        public <S extends Enum<S>> Results<IntEntity> withState(S state) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public Results<IntEntity> without(Class<?> ... componentTypes) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }

        @Override
        public Results<IntEntity> withAlso(Class<?> ... componentTypes) {
            throw new UnsupportedOperationException("Unsupported operation.");
        }
    }

    public static final class With<T>
    extends ResultSet<T> {
        private final Class<T> type;

        public With(CompositionRepository compositionRepository, Map<IndexKey, CompositionRepository.Node> nodeMap, Class<T> type) {
            super(compositionRepository, nodeMap, false);
            this.type = type;
        }

        @Override
        Iterator<T> compositionIterator(DataComposition composition) {
            return composition.selectT(this.type, composition.getTenant().noItemIterator());
        }

        @Override
        public <S extends Enum<S>> Results<T> withState(S state) {
            throw new UnsupportedOperationException("Unsupported .findCompositionWith(Class<T> type).withState(S state) call : use .findEntitiesWith(Class<T> type).withState(S state) instead");
        }
    }
}

