/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine;

import dev.dominion.ecs.api.Scheduler;
import dev.dominion.ecs.engine.system.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SystemScheduler
implements Scheduler {
    private static final System.Logger LOGGER = Logging.getLogger();
    private final int timeoutSeconds;
    private final Map<Runnable, Single> taskMap = new HashMap<Runnable, Single>();
    private final List<Task> mainTasks = new ArrayList<Task>();
    private final ExecutorService mainExecutor;
    private final ForkJoinPool workStealExecutor;
    private final ScheduledExecutorService tickExecutor;
    private final Logging.Context loggingContext;
    private final StampedLock scheduleLock = new StampedLock();
    private final ReentrantLock tickLock = new ReentrantLock();
    private ScheduledFuture<?> scheduledTicks;
    private int currentTicksPerSecond = 0;
    private TickTime tickTime;

    public SystemScheduler(int timeoutSeconds, final Logging.Context loggingContext) {
        this.timeoutSeconds = timeoutSeconds;
        this.loggingContext = loggingContext;
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                SchedulerThread schedulerThread = new SchedulerThread(r);
                if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "New scheduler-thread: " + schedulerThread.getName());
                }
                return schedulerThread;
            }
        };
        this.mainExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.tickExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.workStealExecutor = (ForkJoinPool)Executors.newWorkStealingPool(nThreads);
        if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Parallel executor created with max {0} thread count", nThreads);
        }
        this.tickTime = new TickTime(System.nanoTime(), 1L);
    }

    private static TickTime calcTickTime(TickTime currentTickTime) {
        long prevTime = currentTickTime.time;
        long currentTime = System.nanoTime();
        return new TickTime(currentTime, currentTime - prevTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable schedule(Runnable system) {
        long stamp = this.scheduleLock.writeLock();
        try {
            this.taskMap.computeIfAbsent(system, sys -> {
                Single single = new Single((Runnable)sys);
                this.mainTasks.add(single);
                return single;
            });
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Schedule a new system in #{0} position", this.mainTasks.size());
            }
            Runnable runnable = system;
            return runnable;
        }
        finally {
            this.scheduleLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] parallelSchedule(Runnable ... systems) {
        long stamp = this.scheduleLock.writeLock();
        try {
            switch (systems.length) {
                case 0: {
                    Runnable[] runnableArray = systems;
                    return runnableArray;
                }
                case 1: {
                    this.schedule(systems[0]);
                }
            }
            Cluster cluster = new Cluster(systems);
            this.mainTasks.add(cluster);
            this.taskMap.putAll(cluster.taskMap);
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Schedule {0} parallel-systems in #{1} position", systems.length, this.mainTasks.size());
            }
            Runnable[] runnableArray = systems;
            return runnableArray;
        }
        finally {
            this.scheduleLock.unlockWrite(stamp);
        }
    }

    public void forkAndJoin(final Runnable subsystem) {
        block3: {
            Thread currentThread = Thread.currentThread();
            if (!(currentThread instanceof SchedulerThread) && !(currentThread instanceof ForkJoinWorkerThread)) {
                throw new IllegalCallerException("Cannot invoke the forkAndJoin() method from outside other systems.");
            }
            try {
                this.workStealExecutor.invoke(new RecursiveAction(){

                    @Override
                    protected void compute() {
                        subsystem.run();
                    }
                });
            }
            catch (RuntimeException ex) {
                if (!Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.ERROR)) break block3;
                LOGGER.log(System.Logger.Level.ERROR, "invoke", (Throwable)ex);
            }
        }
    }

    public void forkAndJoinAll(Runnable ... subsystems) {
        if (!(Thread.currentThread() instanceof ForkJoinWorkerThread)) {
            throw new IllegalCallerException("Cannot invoke the forkAndJoinAll() method from outside other subsystems.");
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])Arrays.stream(subsystems).map(system -> new RecursiveAction((Runnable)system){
            final /* synthetic */ Runnable val$system;
            {
                this.val$system = runnable;
            }

            @Override
            protected void compute() {
                this.val$system.run();
            }
        }).toArray(ForkJoinTask[]::new));
    }

    public void suspend(Runnable system) {
        Single singleTask = this.taskMap.get(system);
        if (singleTask == null) {
            return;
        }
        singleTask.setEnabled(false);
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "A system has been suspended");
        }
    }

    public void resume(Runnable system) {
        Single singleTask = this.taskMap.get(system);
        if (singleTask == null) {
            return;
        }
        singleTask.setEnabled(true);
        if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "A system has been resumed");
        }
    }

    public void tick() {
        this.tickLock.lock();
        try {
            this.tick(SystemScheduler.calcTickTime(this.tickTime));
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, "tick", (Throwable)ex);
            }
        }
        finally {
            this.tickLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long deltaNanoTime) {
        this.tickLock.lock();
        try {
            this.tick(new TickTime(System.nanoTime(), deltaNanoTime));
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, "tick", (Throwable)ex);
            }
        }
        finally {
            this.tickLock.unlock();
        }
    }

    private void tick(TickTime tickTime) throws InterruptedException, ExecutionException, TimeoutException {
        this.tickTime = tickTime;
        List futures = this.mainExecutor.invokeAll(this.mainTasks);
        futures.get(0).get(this.timeoutSeconds, TimeUnit.SECONDS);
    }

    public void tickAtFixedRate(int ticksPerSecond) {
        this.tickLock.lock();
        try {
            if (this.scheduledTicks != null && ticksPerSecond != this.currentTicksPerSecond) {
                try {
                    this.scheduledTicks.cancel(false);
                    this.scheduledTicks.get(this.timeoutSeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException | CancellationException | ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
                this.scheduledTicks = null;
            }
            this.currentTicksPerSecond = ticksPerSecond;
            if (this.currentTicksPerSecond == 0) {
                return;
            }
            this.scheduledTicks = this.tickExecutor.scheduleAtFixedRate(this::tick, 0L, 1000 / this.currentTicksPerSecond, TimeUnit.MILLISECONDS);
        }
        finally {
            this.tickLock.unlock();
        }
    }

    public double deltaTime() {
        return (double)this.tickTime.deltaTime / 1.0E9;
    }

    public boolean shutDown() {
        this.tickExecutor.shutdown();
        this.mainExecutor.shutdown();
        this.workStealExecutor.shutdown();
        try {
            return this.mainExecutor.awaitTermination(this.timeoutSeconds, TimeUnit.SECONDS) && this.workStealExecutor.awaitTermination(this.timeoutSeconds, TimeUnit.SECONDS) && this.tickExecutor.awaitTermination(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.ERROR)) {
                LOGGER.log(System.Logger.Level.ERROR, "shutdown", (Throwable)ex);
            }
            return false;
        }
    }

    record TickTime(long time, long deltaTime) {
    }

    private final class Cluster
    implements Task {
        private final List<Single> tasks;
        private final Map<Runnable, Single> taskMap;

        private Cluster(Runnable[] systems) {
            this.tasks = Arrays.stream(systems).map(x$0 -> new Single((Runnable)x$0)).toList();
            this.taskMap = this.tasks.stream().collect(Collectors.toMap(Single::getSystem, Function.identity()));
        }

        @Override
        public Void call() {
            SystemScheduler.this.forkAndJoin(() -> ForkJoinTask.invokeAll((ForkJoinTask[])this.tasks.stream().map(single -> new RecursiveAction((Single)single){
                final /* synthetic */ Single val$single;
                {
                    this.val$single = single;
                }

                @Override
                protected void compute() {
                    this.val$single.directRun();
                }
            }).toArray(ForkJoinTask[]::new)));
            return null;
        }
    }

    private static final class SchedulerThread
    extends Thread {
        private static final AtomicInteger counter = new AtomicInteger(0);

        public SchedulerThread(Runnable runnable) {
            super(runnable, "dominion-scheduler-" + counter.getAndIncrement());
        }
    }

    private final class Single
    implements Task {
        private final Runnable system;
        private final AtomicBoolean enabled = new AtomicBoolean(true);

        public Single(Runnable system) {
            this.system = system;
        }

        public Runnable getSystem() {
            return this.system;
        }

        public boolean isEnabled() {
            return this.enabled.get();
        }

        public void setEnabled(boolean enabled) {
            this.enabled.set(enabled);
        }

        @Override
        public Void call() {
            if (this.isEnabled()) {
                SystemScheduler.this.forkAndJoin(this.system);
            }
            return null;
        }

        private void directRun() {
            if (this.isEnabled()) {
                this.system.run();
            }
        }
    }

    private static interface Task
    extends Callable<Void> {
    }
}

