/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.collections;

import dev.dominion.ecs.engine.collections.IntStack;
import dev.dominion.ecs.engine.system.Logging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class ChunkedPool<T extends Item>
implements AutoCloseable {
    private static final System.Logger LOGGER = Logging.getLogger();
    private final LinkedChunk<T>[] chunks;
    private final List<Tenant<T>> tenants = new ArrayList<Tenant<T>>();
    private final IdSchema idSchema;
    private final Logging.Context loggingContext;
    private int chunkIndex = -1;

    public ChunkedPool(IdSchema idSchema, Logging.Context loggingContext) {
        this.idSchema = idSchema;
        this.loggingContext = loggingContext;
        if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(loggingContext.subject(), "Creating " + this));
        }
        this.chunks = new LinkedChunk[idSchema.chunkCount];
    }

    public String toString() {
        return "ChunkedPool={chunkCount=" + this.idSchema.chunkCount + ", chunkCapacity=" + this.idSchema.chunkCapacity + "}";
    }

    private LinkedChunk<T> newChunk(Tenant<T> owner, LinkedChunk<T> previousChunk) {
        int id;
        if ((id = ++this.chunkIndex) > this.idSchema.chunkCount - 1) {
            throw new OutOfMemoryError(ChunkedPool.class.getName() + ": cannot create a new memory chunk");
        }
        LinkedChunk<T> newChunk = new LinkedChunk<T>(id, this.idSchema, previousChunk, owner.dataLength, owner, this.loggingContext);
        if (previousChunk != null) {
            previousChunk.setNext(newChunk);
        }
        this.chunks[id] = newChunk;
        return newChunk;
    }

    private LinkedChunk<T> getChunk(int id) {
        return this.chunks[this.idSchema.fetchChunkId(id)];
    }

    public T getEntry(int id) {
        return this.getChunk(id).get(id);
    }

    public Tenant<T> newTenant() {
        return this.newTenant(0, null, null);
    }

    public Tenant<T> newTenant(int dataLength, Object owner, Object subject) {
        Tenant newTenant = new Tenant(this, this.idSchema, dataLength, owner, subject, this.loggingContext);
        this.tenants.add(newTenant);
        return newTenant;
    }

    public Iterator<T> allEntities() {
        return new PoolAllEntitiesIterator<T>(this.chunks, this.chunkIndex);
    }

    public int size() {
        int sum = 0;
        for (int i = 0; i <= this.chunkIndex; ++i) {
            LinkedChunk<T> chunk = this.chunks[i];
            sum += chunk.size();
        }
        return sum;
    }

    @Override
    public void close() {
        this.tenants.forEach(Tenant::close);
    }

    public record IdSchema(int chunkBit, int chunkCount, int chunkIdBitMask, int chunkIdBitMaskShifted, int chunkCapacity, int objectIdBitMask) {
        public static final int TOTAL_BIT = 31;
        public static final int MIN_CHUNK_BIT = 8;
        public static final int MAX_CHUNK_BIT = 16;
        public static final int DETACHED_BIT_IDX = 31;
        public static final int DETACHED_BIT = Integer.MIN_VALUE;

        public IdSchema(int chunkBit) {
            this(chunkBit, 1 << 31 - chunkBit, (1 << 31 - chunkBit) - 1, (1 << 31 - chunkBit) - 1 << chunkBit, 1 << Math.min(chunkBit, 16), (1 << chunkBit) - 1);
        }

        public String idToString(int id) {
            return "|" + ((id & Integer.MIN_VALUE) >>> 31) + ":" + this.fetchChunkId(id) + ":" + this.fetchObjectId(id) + "|";
        }

        public int createId(int chunkId, int objectId) {
            return (chunkId & this.chunkIdBitMask) << this.chunkBit | objectId & this.objectIdBitMask;
        }

        public int mergeId(int id, int objectId) {
            return id & this.chunkIdBitMaskShifted | objectId;
        }

        public int fetchChunkId(int id) {
            return id >>> this.chunkBit & this.chunkIdBitMask;
        }

        public int fetchObjectId(int id) {
            return id & this.objectIdBitMask;
        }
    }

    public static final class LinkedChunk<T extends Item> {
        private static final System.Logger LOGGER = Logging.getLogger();
        private final IdSchema idSchema;
        private final Item[] itemArray;
        private final Object[] dataArray;
        private final Object[][] multiDataArray;
        private final LinkedChunk<T> previous;
        private final Tenant<T> tenant;
        private final int id;
        private final int dataLength;
        private int index = -1;
        private LinkedChunk<T> next;
        private int sizeOffset = 0;

        public LinkedChunk(int id, IdSchema idSchema, LinkedChunk<T> previous, int dataLength, Tenant<T> tenant, Logging.Context loggingContext) {
            this.idSchema = idSchema;
            this.dataLength = dataLength;
            this.itemArray = new Item[idSchema.chunkCapacity];
            this.dataArray = dataLength == 1 ? new Object[idSchema.chunkCapacity * dataLength] : null;
            this.multiDataArray = dataLength > 1 ? new Object[dataLength][idSchema.chunkCapacity * dataLength] : null;
            this.previous = previous;
            this.tenant = tenant;
            this.id = id;
            if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, Logging.format(loggingContext.subject(), "Creating " + this));
            }
        }

        public int incrementIndex() {
            return ++this.index;
        }

        public int remove(int id, boolean isState) {
            int lastIndex;
            int removedIndex = this.idSchema.fetchObjectId(id);
            if ((lastIndex = --this.index + this.sizeOffset) < 0 || lastIndex >= this.idSchema.chunkCapacity) {
                return Integer.MIN_VALUE;
            }
            Item last = this.itemArray[lastIndex];
            Item removed = this.itemArray[removedIndex];
            if (last != null && last != removed) {
                if (!isState) {
                    last.setId(id);
                } else {
                    last.setStateId(id);
                }
                if (this.dataLength == 1) {
                    this.dataArray[removedIndex] = this.dataArray[lastIndex];
                }
                if (this.dataLength > 1) {
                    for (int i = 0; i < this.dataLength; ++i) {
                        this.multiDataArray[i][removedIndex] = this.multiDataArray[i][lastIndex];
                    }
                }
                this.itemArray[removedIndex] = last;
                this.itemArray[lastIndex] = null;
            } else {
                this.itemArray[removedIndex] = null;
            }
            return this.idSchema.mergeId(id, lastIndex);
        }

        public T get(int id) {
            return (T)this.itemArray[this.idSchema.fetchObjectId(id)];
        }

        public T set(T value, Object[] data) {
            int idx = this.idSchema.fetchObjectId(value.getId());
            if (this.dataLength == 1) {
                this.dataArray[idx] = data[0];
            }
            if (this.dataLength > 1) {
                for (int i = 0; i < this.dataLength; ++i) {
                    this.multiDataArray[i][idx] = data[i];
                }
            }
            value.setChunk(this);
            this.itemArray[idx] = value;
            return (T)this.itemArray[idx];
        }

        public void setState(int stateId, T value) {
            int idx = this.idSchema.fetchObjectId(stateId);
            value.setStateId(stateId);
            value.setStateChunk(this);
            this.itemArray[idx] = value;
        }

        public void copy(T value, LinkedChunk<T> prevChunk, int newId, int[] indexMapping) {
            int prevIdx = this.idSchema.fetchObjectId(value.getId());
            int newIdx = this.idSchema.fetchObjectId(newId);
            if (indexMapping.length > 0) {
                if (this.dataLength == 1) {
                    if (prevChunk.dataLength == 1) {
                        this.dataArray[newIdx] = prevChunk.dataArray[prevIdx];
                    } else {
                        int i = -1;
                        while (indexMapping[++i] != 0) {
                        }
                        this.dataArray[newIdx] = prevChunk.multiDataArray[i][prevIdx];
                    }
                } else if (prevChunk.dataLength == 1) {
                    if (indexMapping[0] > -1) {
                        this.multiDataArray[indexMapping[0]][newIdx] = prevChunk.dataArray[prevIdx];
                    }
                } else {
                    int i = -1;
                    while (indexMapping[++i] < 0) {
                    }
                    --i;
                    while (++i < indexMapping.length) {
                        if (indexMapping[i] <= -1) continue;
                        this.multiDataArray[indexMapping[i]][newIdx] = prevChunk.multiDataArray[i][prevIdx];
                    }
                }
            }
            value.setId(newId);
            value.setChunk(this);
            this.itemArray[newIdx] = value;
        }

        public void add(int id, int[] addedIndexMapping, Object addedComponent, Object[] addedComponents) {
            block7: {
                block6: {
                    int idx = this.idSchema.fetchObjectId(id);
                    if (this.dataLength != 1) break block6;
                    if (addedComponent != null) {
                        this.dataArray[idx] = addedComponent;
                    } else {
                        for (int i = 0; i < addedIndexMapping.length; ++i) {
                            if (addedIndexMapping[i] != 0) continue;
                            this.dataArray[idx] = addedComponents[i];
                        }
                    }
                    break block7;
                }
                if (this.dataLength <= 1) break block7;
                if (addedComponent != null) {
                    this.multiDataArray[addedIndexMapping[0]][idx] = addedComponent;
                } else {
                    for (int i = 0; i < addedIndexMapping.length; ++i) {
                        if (addedIndexMapping[i] <= -1) continue;
                        this.multiDataArray[addedIndexMapping[i]][idx] = addedComponents[i];
                    }
                }
            }
        }

        public Object[] shelve(T value) {
            int id = value.getId();
            Object[] data = this.getData(id);
            this.tenant.freeId(id);
            return data;
        }

        public void unshelve(T value, Object[] dataArray) {
            value.setId(this.tenant.nextId());
            this.tenant.register(value, dataArray);
        }

        public Object[] getData(int id) {
            int idx = this.idSchema.fetchObjectId(id);
            Object[] data = new Object[this.dataLength];
            if (this.dataLength == 1) {
                data[0] = this.dataArray[idx];
            }
            if (this.dataLength > 1) {
                for (int i = 0; i < this.dataLength; ++i) {
                    data[i] = this.multiDataArray[i][idx];
                }
            }
            return data;
        }

        public Object getFromDataArray(int id) {
            return this.dataArray[this.idSchema.fetchObjectId(id)];
        }

        public Object getFromMultiDataArray(int id, int i) {
            return this.multiDataArray[i][this.idSchema.fetchObjectId(id)];
        }

        public Tenant<T> getTenant() {
            return this.tenant;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public boolean hasCapacity() {
            return this.index < this.idSchema.chunkCapacity - 1;
        }

        public LinkedChunk<T> getPrevious() {
            return this.previous;
        }

        private void setNext(LinkedChunk<T> next) {
            this.next = next;
            this.sizeOffset = 1;
        }

        public int size() {
            return this.index + this.sizeOffset;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public String toString() {
            return "LinkedChunk={id=" + this.id + ", dataLength=" + this.dataLength + ", capacity=" + this.idSchema.chunkCapacity + ", size=" + this.size() + ", previous=" + (this.previous == null ? null : Integer.valueOf(this.previous.id)) + ", next=" + (this.next == null ? null : Integer.valueOf(this.next.id)) + ", of " + this.tenant + "}";
        }
    }

    public static final class Tenant<T extends Item>
    implements AutoCloseable {
        private static final AtomicInteger idGenerator = new AtomicInteger();
        private final int id = idGenerator.getAndIncrement();
        private final ChunkedPool<T> pool;
        private final IdSchema idSchema;
        private final IntStack idStack;
        private final LinkedChunk<T> firstChunk;
        private final Logging.Context loggingContext;
        private final int dataLength;
        private final Object owner;
        private final Object subject;
        private LinkedChunk<T> currentChunk;
        private int nextId = Integer.MIN_VALUE;

        private Tenant(ChunkedPool<T> pool, IdSchema idSchema, int dataLength, Object owner, Object subject, Logging.Context loggingContext) {
            this.pool = pool;
            this.idSchema = idSchema;
            this.dataLength = dataLength;
            this.owner = owner;
            this.subject = subject;
            this.loggingContext = loggingContext;
            this.idStack = new IntStack(Integer.MIN_VALUE, idSchema.chunkCapacity << 3);
            this.currentChunk = pool.newChunk(this, null);
            this.firstChunk = this.currentChunk;
            this.nextId();
            if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, Logging.format(loggingContext.subject(), "Creating " + this));
            }
        }

        public String toString() {
            return "Tenant={id=" + this.id + ", dataLength=" + this.dataLength + ", nextId=" + this.idSchema.idToString(this.nextId) + ", subject=" + this.subject + "}";
        }

        public int nextId() {
            boolean loggable = Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.TRACE);
            if (loggable) {
                LOGGER.log(System.Logger.Level.TRACE, Logging.format(this.loggingContext.subject(), "Getting nextId from " + this.currentChunk + " having current nextId " + this.idSchema.idToString(this.nextId)));
            }
            int returnValue = this.idStack.pop();
            if (loggable) {
                LOGGER.log(System.Logger.Level.TRACE, Logging.format(this.loggingContext.subject(), "Popping nextId:" + this.idSchema.idToString(returnValue)));
            }
            if (returnValue != Integer.MIN_VALUE) {
                this.pool.getChunk(returnValue).incrementIndex();
                return returnValue;
            }
            returnValue = this.nextId;
            if (this.currentChunk.index < this.idSchema.chunkCapacity - 1) {
                this.nextId = this.idSchema.createId(this.currentChunk.id, this.currentChunk.incrementIndex());
                return returnValue;
            }
            this.currentChunk = this.pool.newChunk(this, this.currentChunk);
            this.nextId = this.idSchema.createId(this.currentChunk.id, this.currentChunk.incrementIndex());
            return returnValue;
        }

        public int freeId(int id) {
            return this.freeId(id, false);
        }

        public int freeStateId(int stateId) {
            return this.freeId(stateId, true);
        }

        public int freeId(int id, boolean isState) {
            LinkedChunk<T> chunkById = this.pool.getChunk(id);
            boolean loggable = Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.TRACE);
            if (chunkById == null || chunkById.tenant != this || chunkById.isEmpty()) {
                return id;
            }
            int reusableId = chunkById.remove(id, isState);
            if (loggable) {
                LOGGER.log(System.Logger.Level.TRACE, Logging.format(this.loggingContext.subject(), "Freeing " + (isState ? "stateId" : "id") + "=" + this.idSchema.idToString(id) + " > reusableId=" + this.idSchema.idToString(reusableId) + " having current " + this.currentChunk));
            }
            if (reusableId == Integer.MIN_VALUE) {
                return reusableId;
            }
            if (chunkById != this.currentChunk) {
                if (loggable) {
                    LOGGER.log(System.Logger.Level.TRACE, Logging.format(this.loggingContext.subject(), "Pushing reusableId: " + this.idSchema.idToString(reusableId)));
                }
                this.idStack.push(reusableId);
            } else {
                this.nextId = reusableId;
            }
            return reusableId;
        }

        public PoolDataIterator<T> iterator() {
            return this.dataLength == 1 ? new PoolDataIterator<T>(this.firstChunk, this.idSchema) : new PoolMultiDataIterator<T>(this.firstChunk, this.idSchema);
        }

        public PoolDataIterator<T> noItemIterator() {
            return this.dataLength == 1 ? new PoolDataNoItemIterator<T>(this.firstChunk, this.idSchema) : new PoolMultiDataNoItemIterator<T>(this.firstChunk, this.idSchema);
        }

        public PoolDataIterator<T> iteratorWithState(boolean multiData) {
            return multiData ? new PoolMultiDataIteratorWithState<T>(this.firstChunk, this.idSchema) : new PoolDataIteratorWithState<T>(this.firstChunk, this.idSchema);
        }

        public PoolDataIterator<T> noItemIteratorWithState(boolean multiData) {
            return multiData ? new PoolMultiDataNoItemIteratorWithState<T>(this.firstChunk, this.idSchema) : new PoolDataNoItemIteratorWithState<T>(this.firstChunk, this.idSchema);
        }

        public T register(T entry, Object[] data) {
            return this.pool.getChunk(entry.getId()).set(entry, data);
        }

        public LinkedChunk<T> registerState(T entry) {
            int stateId = this.nextId();
            LinkedChunk<T> stateChunk = this.pool.getChunk(stateId);
            stateChunk.setState(stateId, entry);
            if (Logging.isLoggable(this.loggingContext.levelIndex(), System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, Logging.format(this.loggingContext.subject(), "Setting state to " + entry));
            }
            return stateChunk;
        }

        public void migrate(T entry, int newId, int[] indexMapping, int[] addedIndexMapping, Object addedComponent, Object[] addedComponents) {
            LinkedChunk<T> prevChunk = this.pool.getChunk(entry.getId());
            LinkedChunk<T> newChunk = this.pool.getChunk(newId);
            newChunk.copy(entry, prevChunk, newId, indexMapping);
            if (addedIndexMapping != null) {
                newChunk.add(newId, addedIndexMapping, addedComponent, addedComponents);
            }
        }

        public int currentChunkSize() {
            return this.currentChunk.size();
        }

        public int currentChunkLength() {
            return this.currentChunk.dataLength;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public ChunkedPool<T> getPool() {
            return this.pool;
        }

        public Object getOwner() {
            return this.owner;
        }

        public Object getSubject() {
            return this.subject;
        }

        @Override
        public void close() {
            this.idStack.close();
        }
    }

    public static interface Item {
        public int getId();

        public void setId(int var1);

        public void setStateId(int var1);

        public LinkedChunk<? extends Item> getChunk();

        public void setChunk(LinkedChunk<? extends Item> var1);

        public void setStateChunk(LinkedChunk<? extends Item> var1);
    }

    public static class PoolAllEntitiesIterator<T extends Item>
    extends PoolIterator<T> {
        private final LinkedChunk<T>[] chunks;
        private int chunkIndex;

        public PoolAllEntitiesIterator(LinkedChunk<T>[] chunks, int chunkIndex) {
            super(chunks[chunkIndex], null);
            this.chunks = chunks;
            this.chunkIndex = chunkIndex;
            this.currentChunk = chunks[chunkIndex];
        }

        @Override
        public boolean hasNext() {
            return this.next > -1 || this.chunkIndex > 0 && (this.currentChunk = this.chunks[--this.chunkIndex]) != null && !this.currentChunk.isEmpty() && (this.next = this.currentChunk.size() - 1) == this.next;
        }
    }

    public static final class PoolMultiDataNoItemIteratorWithState<T extends Item>
    extends PoolMultiDataIteratorWithState<T> {
        public PoolMultiDataNoItemIteratorWithState(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public T next() {
            --this.next;
            return null;
        }
    }

    public static final class PoolMultiDataNoItemIterator<T extends Item>
    extends PoolMultiDataIterator<T> {
        public PoolMultiDataNoItemIterator(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public T next() {
            --this.next;
            return null;
        }
    }

    public static class PoolMultiDataIteratorWithState<T extends Item>
    extends PoolDataIteratorWithState<T> {
        public PoolMultiDataIteratorWithState(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public Object next(PoolIteratorNextWith1 nextWith1, int i1) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith1.fetchNext(itemChunk.multiDataArray, i1, itemIdx, (Item)this.next());
        }

        @Override
        public Object next(PoolIteratorNextWith2 nextWith2, int i1, int i2) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith2.fetchNext(itemChunk.multiDataArray, i1, i2, itemIdx, (Item)this.next());
        }

        @Override
        public Object next(PoolIteratorNextWith3 nextWith3, int i1, int i2, int i3) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith3.fetchNext(itemChunk.multiDataArray, i1, i2, i3, itemIdx, (Item)this.next());
        }

        @Override
        public Object next(PoolIteratorNextWith4 nextWith4, int i1, int i2, int i3, int i4) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith4.fetchNext(itemChunk.multiDataArray, i1, i2, i3, i4, itemIdx, (Item)this.next());
        }

        @Override
        public Object next(PoolIteratorNextWith5 nextWith5, int i1, int i2, int i3, int i4, int i5) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith5.fetchNext(itemChunk.multiDataArray, i1, i2, i3, i4, i5, itemIdx, (Item)this.next());
        }

        @Override
        public Object next(PoolIteratorNextWith6 nextWith6, int i1, int i2, int i3, int i4, int i5, int i6) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith6.fetchNext(itemChunk.multiDataArray, i1, i2, i3, i4, i5, i6, itemIdx, (Item)this.next());
        }
    }

    public static class PoolMultiDataIterator<T extends Item>
    extends PoolDataIterator<T> {
        public PoolMultiDataIterator(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public Object data(int i) {
            return this.currentChunk.multiDataArray[i][this.next];
        }
    }

    public static final class PoolDataNoItemIteratorWithState<T extends Item>
    extends PoolDataIteratorWithState<T> {
        public PoolDataNoItemIteratorWithState(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public T next() {
            --this.next;
            return null;
        }
    }

    public static final class PoolDataNoItemIterator<T extends Item>
    extends PoolDataIterator<T> {
        public PoolDataNoItemIterator(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public T next() {
            --this.next;
            return null;
        }
    }

    public static class PoolDataIteratorWithState<T extends Item>
    extends PoolDataIterator<T> {
        public PoolDataIteratorWithState(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        @Override
        public Object next(PoolIteratorNextWith1 nextWith1, int i1) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return nextWith1.fetchNext(itemChunk.dataArray, itemIdx, (Item)this.next());
        }

        @Override
        public Object data(int i) {
            Item item = this.currentChunk.itemArray[this.next];
            LinkedChunk<? extends Item> itemChunk = item.getChunk();
            int itemIdx = this.idSchema.fetchObjectId(item.getId());
            return itemChunk.dataArray[itemIdx];
        }
    }

    public static class PoolDataEmptyIterator<T extends Item>
    extends PoolDataIterator<T> {
        public PoolDataEmptyIterator() {
            super(null, null);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public Object data(int i) {
            return null;
        }
    }

    public static class PoolDataIterator<T extends Item>
    extends PoolIterator<T> {
        public PoolDataIterator(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            super(currentChunk, idSchema);
        }

        public Object data(int i) {
            return this.currentChunk.dataArray[this.next];
        }

        public Object next(PoolIteratorNextWith1 nextWith1, int i1) {
            return null;
        }

        public Object next(PoolIteratorNextWith2 nextWith2, int i1, int i2) {
            return null;
        }

        public Object next(PoolIteratorNextWith3 nextWith3, int i1, int i2, int i3) {
            return null;
        }

        public Object next(PoolIteratorNextWith4 nextWith4, int i1, int i2, int i3, int i4) {
            return null;
        }

        public Object next(PoolIteratorNextWith5 nextWith5, int i1, int i2, int i3, int i4, int i5) {
            return null;
        }

        public Object next(PoolIteratorNextWith6 nextWith6, int i1, int i2, int i3, int i4, int i5, int i6) {
            return null;
        }
    }

    public static class PoolIterator<T extends Item>
    implements Iterator<T> {
        protected int next;
        protected LinkedChunk<T> currentChunk;
        protected IdSchema idSchema;
        private int begin;

        public PoolIterator(LinkedChunk<T> currentChunk, IdSchema idSchema) {
            this.currentChunk = currentChunk;
            this.idSchema = idSchema;
            this.begin = currentChunk == null ? 0 : currentChunk.size() - 1;
            this.next = this.begin;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            if (this.next > -1) return true;
            if (this.currentChunk == null) return false;
            this.currentChunk = this.currentChunk.next;
            if (this.currentChunk == null) return false;
            if (this.currentChunk.isEmpty()) return false;
            this.next = this.begin = this.currentChunk.size() - 1;
            if (this.begin != this.begin) return false;
            return true;
        }

        @Override
        public T next() {
            return (T)this.currentChunk.itemArray[this.next--];
        }
    }

    public static interface PoolIteratorNextWith6 {
        public Object fetchNext(Object[][] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Item var9);
    }

    public static interface PoolIteratorNextWith5 {
        public Object fetchNext(Object[][] var1, int var2, int var3, int var4, int var5, int var6, int var7, Item var8);
    }

    public static interface PoolIteratorNextWith4 {
        public Object fetchNext(Object[][] var1, int var2, int var3, int var4, int var5, int var6, Item var7);
    }

    public static interface PoolIteratorNextWith3 {
        public Object fetchNext(Object[][] var1, int var2, int var3, int var4, int var5, Item var6);
    }

    public static interface PoolIteratorNextWith2 {
        public Object fetchNext(Object[][] var1, int var2, int var3, int var4, Item var5);
    }

    public static interface PoolIteratorNextWith1 {
        public Object fetchNext(Object[] var1, int var2, Item var3);

        public Object fetchNext(Object[][] var1, int var2, int var3, Item var4);
    }
}

