/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.collections;

import dev.dominion.ecs.engine.system.UnsafeFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import sun.misc.Unsafe;

public final class IntStack
implements AutoCloseable {
    private static final int INT_BYTES = 4;
    private static final Unsafe unsafe = UnsafeFactory.INSTANCE;
    private final AtomicInteger index = new AtomicInteger(-4);
    private final StampedLock lock = new StampedLock();
    private final int nullInt;
    private long address;
    private int capacity;

    public IntStack(int nullInt, int initialCapacity) {
        this.nullInt = nullInt;
        this.capacity = initialCapacity;
        this.address = unsafe.allocateMemory(initialCapacity);
    }

    public int pop() {
        int i = this.index.get();
        if (i < 0) {
            return this.nullInt;
        }
        int returnValue = unsafe.getInt(this.address + (long)i);
        returnValue = this.index.compareAndSet(i, i - 4) ? returnValue : Integer.MIN_VALUE;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(int id) {
        long offset = this.index.addAndGet(4);
        if (offset >= (long)this.capacity) {
            long l = this.lock.writeLock();
            try {
                int currentCapacity = this.capacity;
                if (offset >= (long)currentCapacity) {
                    int newCapacity = currentCapacity + (currentCapacity >>> 1);
                    long newAddress = unsafe.allocateMemory(newCapacity);
                    unsafe.copyMemory(this.address, newAddress, currentCapacity);
                    this.capacity = newCapacity;
                    this.address = newAddress;
                }
            }
            finally {
                this.lock.unlock(l);
            }
        }
        unsafe.putInt(this.address + offset, id);
        return true;
    }

    public int size() {
        return (this.index.get() >> 2) + 1;
    }

    @Override
    public void close() {
        unsafe.freeMemory(this.address);
    }

    public String toString() {
        return "IntStack={capacity=" + this.capacity + "|off-heap}";
    }
}

