/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.system;

import dev.dominion.ecs.engine.system.IndexKey;
import dev.dominion.ecs.engine.system.Logging;
import dev.dominion.ecs.engine.system.UnsafeFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sun.misc.Unsafe;

public final class ClassIndex
implements AutoCloseable {
    public static final int INT_BYTES_SHIFT = 2;
    public static final int DEFAULT_HASH_BIT = 20;
    public static final int MIN_HASH_BIT = 14;
    public static final int MAX_HASH_BIT = 24;
    private static final System.Logger LOGGER = Logging.getLogger();
    private static final Unsafe unsafe = UnsafeFactory.INSTANCE;
    private final Map<Object, Integer> controlMap = new ConcurrentHashMap<Object, Integer>(1024);
    private final int hashBit;
    private final long memoryAddress;
    private final AtomicBoolean useFallbackMap = new AtomicBoolean(false);
    private final boolean fallbackMapEnabled;
    private final AtomicInteger atomicIndex = new AtomicInteger(0);
    private final int capacity;
    private int index = 1;
    private final ClassValue<Integer> fallbackMap = new ClassValue<Integer>(){

        @Override
        protected Integer computeValue(Class<?> type) {
            return ClassIndex.this.index++;
        }
    };

    public ClassIndex() {
        this(20, true, Logging.Context.TEST);
    }

    public ClassIndex(int hashBit, boolean fallbackMapEnabled, Logging.Context loggingContext) {
        this.hashBit = Math.min(Math.max(hashBit, 14), 24);
        this.fallbackMapEnabled = fallbackMapEnabled;
        this.capacity = 1 << hashBit << 2;
        this.memoryAddress = unsafe.allocateMemory(this.capacity);
        unsafe.setMemory(this.memoryAddress, this.capacity, (byte)0);
        if (Logging.isLoggable(loggingContext.levelIndex(), System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, Logging.format(loggingContext.subject(), "Creating " + this));
        }
    }

    private static long getIdentityAddress(long identityHashCode, long address) {
        return address + (identityHashCode << 2);
    }

    public int getHashBit() {
        return this.hashBit;
    }

    public int addClass(Class<?> newClass) {
        return this.addObject(newClass);
    }

    public int addObject(Object newClass) {
        if (this.useFallbackMap.get()) {
            return this.fallbackMap.get((Class)newClass);
        }
        int identityHashCode = this.capHashCode(System.identityHashCode(newClass), this.hashBit);
        long i = ClassIndex.getIdentityAddress(identityHashCode, this.memoryAddress);
        int currentIndex = unsafe.getInt(i);
        if (currentIndex == 0) {
            int idx = this.fallbackMapEnabled ? this.fallbackMap.get((Class)newClass).intValue() : this.atomicIndex.incrementAndGet();
            unsafe.putIntVolatile(null, i, idx);
            this.controlMap.put(newClass, idx);
            return idx;
        }
        if (!this.controlMap.containsKey(newClass)) {
            int idx = this.fallbackMap.get((Class)newClass);
            this.useFallbackMap.set(true);
            return idx;
        }
        return currentIndex;
    }

    public int getIndex(Class<?> klass) {
        return this.getObjectIndex(klass);
    }

    public int getObjectIndex(Object klass) {
        if (this.useFallbackMap.get()) {
            return this.fallbackMap.get((Class)klass);
        }
        int identityHashCode = this.capHashCode(System.identityHashCode(klass), this.hashBit);
        return unsafe.getInt(ClassIndex.getIdentityAddress(identityHashCode, this.memoryAddress));
    }

    public int getObjectIndexVolatile(Object klass) {
        if (this.useFallbackMap.get()) {
            return this.fallbackMap.get((Class)klass);
        }
        int identityHashCode = this.capHashCode(System.identityHashCode(klass), this.hashBit);
        return unsafe.getIntVolatile(null, ClassIndex.getIdentityAddress(identityHashCode, this.memoryAddress));
    }

    public int getIndexOrAddClass(Class<?> klass) {
        return this.getIndexOrAddObject(klass);
    }

    public int getIndexOrAddObject(Object klass) {
        int value = this.getObjectIndexVolatile(klass);
        if (value != 0) {
            return value;
        }
        return this.addObject(klass);
    }

    public int[] getIndexOrAddClassBatch(Class<?>[] classes) {
        int[] indexes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            indexes[i] = this.getIndexOrAddClass(classes[i]);
        }
        return indexes;
    }

    public IndexKey getIndexKey(Object[] objects) {
        int length = objects.length;
        boolean[] checkArray = new boolean[this.index + length + 1];
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 0; i < length; ++i) {
            int value = this.getIndexOrAddClass(objects[i].getClass());
            if (checkArray[value]) {
                throw new IllegalArgumentException("Duplicate object types are not allowed");
            }
            checkArray[value] = true;
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new IndexKey(checkArray, min, max, length);
    }

    public IndexKey getIndexKeyByType(Class<?>[] classes) {
        int length = classes.length;
        boolean[] checkArray = new boolean[this.index + length + 1];
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 0; i < length; ++i) {
            int value = this.getIndexOrAddClass(classes[i]);
            if (checkArray[value]) {
                throw new IllegalArgumentException("Duplicate object types are not allowed");
            }
            checkArray[value] = true;
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new IndexKey(checkArray, min, max, length);
    }

    public <E extends Enum<E>> IndexKey getIndexKeyByEnum(E enumValue) {
        int cIndex = this.getIndex(enumValue.getClass());
        cIndex = cIndex == 0 ? this.getIndexOrAddClass(enumValue.getClass()) : cIndex;
        return new IndexKey(new int[]{cIndex, enumValue.ordinal()});
    }

    private int capHashCode(int hashCode, int hashBits) {
        return hashCode >> 32 - hashBits;
    }

    public int size() {
        return this.fallbackMapEnabled ? this.index - 1 : this.atomicIndex.get();
    }

    public void useUseFallbackMap() {
        this.useFallbackMap.set(true);
    }

    @Override
    public void close() {
        this.controlMap.clear();
        unsafe.freeMemory(this.memoryAddress);
    }

    public String toString() {
        return "ClassIndex={hashBit=" + this.hashBit + ", capacity=" + this.capacity + "|off-heap}";
    }
}

