/*
 * Decompiled with CFR 0.152.
 */
package dev.dominion.ecs.engine.system;

import java.util.Arrays;

public final class IndexKey {
    private final int hashCode;
    private final byte[] data;

    public IndexKey(int value) {
        this.hashCode = value;
        this.data = null;
    }

    public IndexKey(int[] array) {
        long result = 1L;
        int length = array.length;
        this.data = new byte[length];
        for (int i = 0; i < length; ++i) {
            int value = array[i];
            result = result * 31L + (long)value;
            this.data[i] = (byte)(value ^ value >>> 8);
        }
        this.hashCode = (int)(result ^ result >>> 32);
    }

    public IndexKey(boolean[] checkArray, int min, int max, int length) {
        long result = 1L;
        int idx = 0;
        this.data = new byte[length];
        for (int i = min; i <= max; ++i) {
            if (!checkArray[i]) continue;
            result = result * 31L + (long)i;
            this.data[idx++] = (byte)(i ^ i >>> 8);
        }
        this.hashCode = (int)(result ^ result >>> 32);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(((IndexKey)o).data, this.data);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "|" + this.hashCode + ":" + Arrays.toString(this.data) + "|";
    }
}

